/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tabs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPaneMouseListener;

final class CloseableTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Image CLOSE_IMAGE = ImageManager.getInstance().getImage("images/widgets/tab_close.png", new ClassLoader[0]);
    private static final Image CLOSE_IMAGE_HOVER = ImageManager.getInstance().getImage("images/widgets/tab_close_hover.png", new ClassLoader[0]);
    private static final int CLOSE_ICON_WIDTH = 22;
    private static final int CLOSE_ICON_RIGHT_MARGIN = 4;
    private static final int TAB_CORNER_RADIUS = 4;
    private static final Insets TAB_INSETS = new Insets(1, 2, 1, 3);
    private static final int SEPARATOR_WIDTH = 10;
    private final CloseableTabbedPaneMouseListener _mouseListener;
    private final CloseableTabbedPane _pane;

    public CloseableTabbedPaneUI(CloseableTabbedPane pane) {
        this._pane = pane;
        this._mouseListener = new CloseableTabbedPaneMouseListener(this, pane);
    }

    public CloseableTabbedPane getPane() {
        return this._pane;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return TAB_INSETS;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        return TAB_INSETS;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    public int getRunForTab(int tabCount, int tabIndex) {
        return super.getRunForTab(tabCount, tabIndex);
    }

    private Insets getBorderInsets() {
        Border border = this._pane.getBorder();
        if (border == null) {
            return new Insets(0, 0, 0, 0);
        }
        return border.getBorderInsets(this._pane);
    }

    public Rectangle closeRectFor(int tabIndex) {
        Rectangle rect = this.rects[tabIndex];
        int x = rect.x + rect.width - 22 - 4;
        int y = rect.y + (rect.height - 22) / 2;
        int width = 22;
        int height = 22;
        return new Rectangle(x, y, 22, 22);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (this._pane.getSeparators().contains(tabIndex)) {
            return 10;
        }
        int width = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            width += 22;
        }
        return width;
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets insets = this.getBorderInsets();
        int result = maxTabHeight * horizRunCount + insets.top;
        return result;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int result = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 2;
        return result;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Rectangle r = new Rectangle(textRect);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            r.x -= 11;
        }
        super.paintText(g, tabPlacement, font, metrics, tabIndex, title, r, isSelected);
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        Rectangle r = new Rectangle(iconRect);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            r.x -= 11;
        }
        super.paintIcon(g, tabPlacement, tabIndex, icon, r, isSelected);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            g.setColor(this._pane.getTabBorderColor());
            g.drawLine(x + 4, y, x + w - 4, y);
            g.drawLine(x, y + 4, x, y + h);
            g.drawLine(x + w, y + 4, x + w, y + h);
            g.drawLine(x, y + 4, x + 4, y);
            g.drawLine(x + w - 4, y, x + w, y + 4);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color bottomColor;
        Color topColor;
        if (isSelected) {
            topColor = this._pane.getSelectedTabTopColor();
            bottomColor = this._pane.getSelectedTabBottomColor();
        } else {
            topColor = this._pane.getUnselectedTabTopColor();
            bottomColor = this._pane.getUnselectedTabBottomColor();
        }
        GradientPaint gradient = new GradientPaint(x, y, topColor, x, y + h, bottomColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setPaint(gradient);
        } else {
            g.setColor(bottomColor);
        }
        int height = h * 4;
        g.fillRoundRect(x, y, w, 8, 4, 4);
        g.fillRect(x, y + 4, w, height);
        if (!this._pane.getUnclosables().contains(tabIndex)) {
            Rectangle closeRect = this.closeRectFor(tabIndex);
            Image image = this._mouseListener.getClosedIndex() != tabIndex ? CLOSE_IMAGE : CLOSE_IMAGE_HOVER;
            g.drawImage(image, closeRect.x, closeRect.y, this._pane);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int tabIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        boolean x = false;
        int y = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + tabAreaInsets.bottom;
        int w = width;
        int h = height;
        g.setColor(this._pane.getSelectedTabBottomColor());
        g.fillRect(0, y, w, h);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this._pane.addMouseListener(this._mouseListener);
        this._pane.addMouseMotionListener(this._mouseListener);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        if (this._pane.getSeparators().contains(tabIndex)) {
            return;
        }
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }
}

