/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tree;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.reference.DatastoreDictionary;
import org.eobjects.datacleaner.actions.PreviewSourceDataActionListener;
import org.eobjects.datacleaner.actions.QuickAnalysisActionListener;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;
import org.eobjects.datacleaner.windows.DatastoreDictionaryDialog;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

final class ColumnMouseListener
extends MouseAdapter
implements MouseListener {
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final SchemaTree _schemaTree;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected ColumnMouseListener(SchemaTree schemaTree, AnalysisJobBuilder analysisJobBuilder, InjectorBuilder injectorBuilder) {
        this._schemaTree = schemaTree;
        this._analysisJobBuilder = analysisJobBuilder;
        this._injectorBuilder = injectorBuilder;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this._schemaTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof Column) {
            final Column column = (Column)userObject;
            int button = e.getButton();
            if (button == 1 && e.getClickCount() > 1) {
                this.toggleColumn(column);
            } else if (button == 2 || button == 3) {
                JMenuItem toggleColumnItem = WidgetFactory.createMenuItem(null, "images/actions/toggle-source-column.png");
                if (this._analysisJobBuilder.containsSourceColumn(column)) {
                    toggleColumnItem.setText("Remove column from source");
                } else {
                    toggleColumnItem.setText("Add column to source");
                }
                toggleColumnItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColumnMouseListener.this.toggleColumn(column);
                    }
                });
                JMenuItem createDictionaryItem = WidgetFactory.createMenuItem("Create dictionary from column", "images/model/dictionary.png");
                createDictionaryItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String datastoreName = ColumnMouseListener.this._analysisJobBuilder.getDatastoreConnection().getDatastore().getName();
                        DatastoreDictionary dictionary = new DatastoreDictionary(column.getName(), datastoreName, column.getQualifiedLabel());
                        Injector injector = ColumnMouseListener.this._injectorBuilder.with(DatastoreDictionary.class, (Object)dictionary).createInjector();
                        DatastoreDictionaryDialog dialog = (DatastoreDictionaryDialog)injector.getInstance(DatastoreDictionaryDialog.class);
                        dialog.setVisible(true);
                    }
                });
                JMenuItem quickAnalysisMenuItem = WidgetFactory.createMenuItem("Quick analysis", "images/component-types/analyzer.png");
                Injector injector = this._injectorBuilder.with(Column[].class, (Object)new Column[]{column}).with(Table.class, null).createInjector();
                QuickAnalysisActionListener quickAnalysisActionListener = (QuickAnalysisActionListener)injector.getInstance(QuickAnalysisActionListener.class);
                quickAnalysisMenuItem.addActionListener(quickAnalysisActionListener);
                JMenuItem previewMenuItem = WidgetFactory.createMenuItem("Preview column", "images/actions/preview_data.png");
                previewMenuItem.addActionListener(new PreviewSourceDataActionListener(this._schemaTree.getWindowContext(), this._schemaTree.getDatastore(), column));
                JPopupMenu popup = new JPopupMenu();
                popup.setLabel(column.getName());
                popup.add(toggleColumnItem);
                popup.add(createDictionaryItem);
                popup.add(quickAnalysisMenuItem);
                popup.add(previewMenuItem);
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    public void toggleColumn(Column column) {
        if (this._analysisJobBuilder.containsSourceColumn(column)) {
            this._analysisJobBuilder.removeSourceColumn(column);
        } else {
            this._analysisJobBuilder.addSourceColumn(column);
        }
    }
}

