/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;
import org.eobjects.datacleaner.widgets.tree.TableMouseListener;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class SchemaMouseListener
extends MouseAdapter
implements MouseListener {
    private final SchemaTree _schemaTree;
    private final Provider<TableMouseListener> _tableMouseListenerProvider;

    @Inject
    protected SchemaMouseListener(SchemaTree schemaTree, Provider<TableMouseListener> tableMouseListenerProvider) {
        this._schemaTree = schemaTree;
        this._tableMouseListenerProvider = tableMouseListenerProvider;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this._schemaTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof Schema) {
            final Schema schema = (Schema)userObject;
            int button = e.getButton();
            if (button == 2 || button == 3) {
                JPopupMenu popup = new JPopupMenu();
                popup.setLabel(schema.getName());
                JMenuItem addTableItem = WidgetFactory.createMenuItem("Add all schema tables to source", "images/actions/toggle-source-table.png");
                addTableItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Table[] tables;
                        TableMouseListener tableMouseListener = (TableMouseListener)SchemaMouseListener.this._tableMouseListenerProvider.get();
                        for (Table table : tables = schema.getTables()) {
                            tableMouseListener.addTable(table);
                        }
                    }
                });
                popup.add(addTableItem);
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

