/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tree;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.SchemaComparator;
import org.eobjects.datacleaner.widgets.tree.ColumnMouseListener;
import org.eobjects.datacleaner.widgets.tree.SchemaMouseListener;
import org.eobjects.datacleaner.widgets.tree.TableMouseListener;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jdesktop.swingx.renderer.WrappingIconPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTree
extends JXTree
implements TreeWillExpandListener,
TreeCellRenderer {
    private static final long serialVersionUID = 7763827443642264329L;
    private static final Logger logger = LoggerFactory.getLogger(SchemaTree.class);
    public static final String LOADING_TABLES_STRING = "Loading tables...";
    public static final String LOADING_COLUMNS_STRING = "Loading columns...";
    public static final String UNNAMED_SCHEMA_STRING = "(unnamed schema)";
    public static final String ROOT_NODE_STRING = "Schemas";
    private final Datastore _datastore;
    private final DatastoreConnection _datastoreConnection;
    private final TreeCellRenderer _rendererDelegate;
    private final WindowContext _windowContext;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected SchemaTree(Datastore datastore, @Nullable AnalysisJobBuilder analysisJobBuilder, WindowContext windowContext, InjectorBuilder injectorBuilder) {
        if (datastore == null) {
            throw new IllegalArgumentException("Datastore cannot be null");
        }
        this._datastore = datastore;
        this._windowContext = windowContext;
        this._analysisJobBuilder = analysisJobBuilder;
        this._injectorBuilder = injectorBuilder;
        this._datastoreConnection = datastore.openConnection();
        this._rendererDelegate = new DefaultTreeRenderer();
        this.setCellRenderer(this);
        this.setOpaque(false);
        this.addTreeWillExpandListener(this);
    }

    public void addNotify() {
        super.addNotify();
        Injector injector = this._injectorBuilder.with(SchemaTree.class, (Object)this).createInjector();
        if (this._analysisJobBuilder != null) {
            this.addMouseListener((MouseListener)injector.getInstance(SchemaMouseListener.class));
            this.addMouseListener((MouseListener)injector.getInstance(TableMouseListener.class));
            this.addMouseListener((MouseListener)injector.getInstance(ColumnMouseListener.class));
        }
        this.updateTree();
    }

    public void removeNotify() {
        MouseListener[] mouseListeners;
        super.removeNotify();
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        this._datastoreConnection.close();
    }

    public WindowContext getWindowContext() {
        return this._windowContext;
    }

    private void updateTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        rootNode.setUserObject(this._datastoreConnection.getDatastore());
        SchemaNavigator schemaNavigator = this._datastoreConnection.getSchemaNavigator();
        schemaNavigator.refreshSchemas();
        Schema[] schemas = schemaNavigator.getSchemas();
        Arrays.sort(schemas, new SchemaComparator());
        for (Schema schema : schemas) {
            DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
            schemaNode.add(new DefaultMutableTreeNode(LOADING_TABLES_STRING));
            rootNode.add(schemaNode);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.setModel(treeModel);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path = event.getPath();
        DefaultMutableTreeNode lastTreeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        SwingWorker worker = null;
        if (lastTreeNode.getChildCount() == 1) {
            DefaultMutableTreeNode firstChildNode = (DefaultMutableTreeNode)lastTreeNode.getChildAt(0);
            if (firstChildNode.getUserObject() == LOADING_TABLES_STRING) {
                worker = new LoadTablesSwingWorker(lastTreeNode);
            } else if (firstChildNode.getUserObject() == LOADING_COLUMNS_STRING) {
                worker = new LoadColumnsSwingWorker(path, lastTreeNode);
            }
        }
        if (worker != null) {
            worker.execute();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean opaque;
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        Component component = null;
        ImageManager imageManager = ImageManager.getInstance();
        Icon icon = null;
        if (value instanceof Datastore) {
            component = this._rendererDelegate.getTreeCellRendererComponent(tree, ((Datastore)value).getName(), selected, expanded, leaf, row, hasFocus);
            icon = IconUtils.getDatastoreIcon((Datastore)value, IconUtils.ICON_SIZE_SMALL);
        } else if (value instanceof Schema) {
            Schema schema = (Schema)value;
            String schemaName = schema.getName();
            component = this._rendererDelegate.getTreeCellRendererComponent(tree, schemaName, selected, expanded, leaf, row, hasFocus);
            icon = imageManager.getImageIcon("images/model/schema.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
            if (SchemaComparator.isInformationSchema(schema)) {
                icon = imageManager.getImageIcon("images/model/schema_information.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
            }
        } else if (value instanceof Table) {
            component = this._rendererDelegate.getTreeCellRendererComponent(tree, ((Table)value).getName(), selected, expanded, leaf, row, hasFocus);
            icon = imageManager.getImageIcon("images/model/table.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        } else if (value instanceof Column) {
            Column column = (Column)value;
            String columnLabel = column.getName();
            component = this._rendererDelegate.getTreeCellRendererComponent(tree, columnLabel, selected, expanded, leaf, row, hasFocus);
            icon = IconUtils.getColumnIcon(column, IconUtils.ICON_SIZE_SMALL);
        } else if (value instanceof String) {
            component = this._rendererDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (component == null) {
            throw new IllegalArgumentException("Unexpected value: " + value + " of class: " + (value == null ? "<null>" : value.getClass().getName()));
        }
        boolean bl = opaque = hasFocus || selected;
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(opaque);
        }
        if (icon != null) {
            if (component instanceof WrappingIconPanel) {
                WrappingIconPanel wip = (WrappingIconPanel)component;
                wip.setIcon(icon);
                wip.getComponent().setOpaque(opaque);
            } else {
                logger.warn("Rendered TreeNode Component was not a WrappingIconPanel, cannot set icon!");
            }
        }
        return component;
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    class LoadColumnsSwingWorker
    extends SwingWorker<Void, Column> {
        private final DefaultMutableTreeNode _tableNode;

        public LoadColumnsSwingWorker(TreePath path, DefaultMutableTreeNode tableNode) {
            this._tableNode = tableNode;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Column[] columns;
            Table table = (Table)this._tableNode.getUserObject();
            for (Column column : columns = table.getColumns()) {
                String name = column.getName();
                logger.debug("Publishing column name: {}", (Object)name);
                this.publish(column);
            }
            return null;
        }

        @Override
        protected void process(List<Column> chunks) {
            for (Column column : chunks) {
                DefaultMutableTreeNode columnNode = new DefaultMutableTreeNode(column);
                this._tableNode.add(columnNode);
            }
            SchemaTree.this.updateUI();
        }

        @Override
        protected void done() {
            this._tableNode.remove(0);
            SchemaTree.this.updateUI();
        }
    }

    class LoadTablesSwingWorker
    extends SwingWorker<Void, Table> {
        private final DefaultMutableTreeNode _schemaNode;

        public LoadTablesSwingWorker(DefaultMutableTreeNode schemaNode) {
            this._schemaNode = schemaNode;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Table[] tables;
            Schema schema = (Schema)this._schemaNode.getUserObject();
            for (Table table : tables = schema.getTables()) {
                String name = table.getName();
                logger.debug("Publishing table name: {}", (Object)name);
                this.publish(table);
            }
            return null;
        }

        @Override
        protected void process(List<Table> chunks) {
            for (Table table : chunks) {
                DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table);
                DefaultMutableTreeNode loadingColumnsNode = new DefaultMutableTreeNode(SchemaTree.LOADING_COLUMNS_STRING);
                tableNode.add(loadingColumnsNode);
                this._schemaNode.add(tableNode);
            }
            SchemaTree.this.updateUI();
        }

        @Override
        protected void done() {
            this._schemaNode.remove(0);
            SchemaTree.this.updateUI();
        }
    }
}

