/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tree;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.actions.PreviewSourceDataActionListener;
import org.eobjects.datacleaner.actions.QuickAnalysisActionListener;
import org.eobjects.datacleaner.actions.SaveTableAsCsvFileActionListener;
import org.eobjects.datacleaner.actions.SaveTableAsExcelSpreadsheetActionListener;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

final class TableMouseListener
extends MouseAdapter
implements MouseListener {
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final SchemaTree _schemaTree;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected TableMouseListener(SchemaTree schemaTree, AnalysisJobBuilder analysisJobBuilder, InjectorBuilder injectorBuilder) {
        this._schemaTree = schemaTree;
        this._analysisJobBuilder = analysisJobBuilder;
        this._injectorBuilder = injectorBuilder;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this._schemaTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof Table) {
            final Table table = (Table)userObject;
            int button = e.getButton();
            if (button == 1 && e.getClickCount() > 2) {
                this.addTable(table);
            } else if (button == 2 || button == 3) {
                Column[] columns;
                boolean enableAddTable = false;
                boolean enableRemoveTable = false;
                for (Column column : columns = table.getColumns()) {
                    if (this._analysisJobBuilder.containsSourceColumn(column)) {
                        enableRemoveTable = true;
                    } else {
                        enableAddTable = true;
                    }
                    if (enableAddTable && enableRemoveTable) break;
                }
                JPopupMenu popup = new JPopupMenu();
                popup.setLabel(table.getName());
                if (enableAddTable) {
                    JMenuItem addTableItem = WidgetFactory.createMenuItem("Add table to source", "images/actions/toggle-source-table.png");
                    addTableItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TableMouseListener.this.addTable(table);
                        }
                    });
                    popup.add(addTableItem);
                }
                if (enableRemoveTable) {
                    JMenuItem removeTableItem = WidgetFactory.createMenuItem("Remove table from source", "images/actions/toggle-source-table.png");
                    removeTableItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TableMouseListener.this.removeTable(table);
                        }
                    });
                    popup.add(removeTableItem);
                }
                JMenuItem quickAnalysisMenuItem = WidgetFactory.createMenuItem("Quick analysis", "images/component-types/analyzer.png");
                Injector injector = this._injectorBuilder.with(Table.class, (Object)table).with(Column[].class, null).createInjector();
                QuickAnalysisActionListener quickAnalysisActionListener = (QuickAnalysisActionListener)injector.getInstance(QuickAnalysisActionListener.class);
                quickAnalysisMenuItem.addActionListener(quickAnalysisActionListener);
                popup.add(quickAnalysisMenuItem);
                JMenuItem saveAsExcelFileMenuItem = WidgetFactory.createMenuItem("Save table as Excel spreadsheet", "images/component-types/type_output_writer.png");
                SaveTableAsExcelSpreadsheetActionListener saveTableAsExcelSpreadsheetActionListener = (SaveTableAsExcelSpreadsheetActionListener)injector.getInstance(SaveTableAsExcelSpreadsheetActionListener.class);
                saveAsExcelFileMenuItem.addActionListener(saveTableAsExcelSpreadsheetActionListener);
                popup.add(saveAsExcelFileMenuItem);
                JMenuItem saveAsCsvFileMenuItem = WidgetFactory.createMenuItem("Save table as CSV file", "images/component-types/type_output_writer.png");
                SaveTableAsCsvFileActionListener saveTableAsCsvFileActionListener = (SaveTableAsCsvFileActionListener)injector.getInstance(SaveTableAsCsvFileActionListener.class);
                saveAsCsvFileMenuItem.addActionListener(saveTableAsCsvFileActionListener);
                popup.add(saveAsCsvFileMenuItem);
                JMenuItem previewMenuItem = WidgetFactory.createMenuItem("Preview table", "images/actions/preview_data.png");
                previewMenuItem.addActionListener(new PreviewSourceDataActionListener(this._schemaTree.getWindowContext(), this._schemaTree.getDatastore(), columns));
                popup.add(previewMenuItem);
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    public void addTable(Table table) {
        Column[] columns;
        for (Column column : columns = table.getColumns()) {
            if (this._analysisJobBuilder.containsSourceColumn(column)) continue;
            this._analysisJobBuilder.addSourceColumn(column);
        }
    }

    public void removeTable(Table table) {
        Column[] columns;
        for (Column column : columns = table.getColumns()) {
            this._analysisJobBuilder.removeSourceColumn(column);
        }
    }
}

