/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.visualization;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.TruePredicate;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.InputColumnSinkJob;
import org.eobjects.analyzer.job.InputColumnSourceJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSinkJob;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.MergedOutcomeJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.HasAnalyzerResult;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.GraphUtils;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.visualization.VisualizeJobLayoutTransformer;
import org.eobjects.datacleaner.widgets.visualization.VisualizeJobLink;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisualizeJobGraph {
    private static final String MORE_COLUMNS_VERTEX = "...";
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(VisualizeJobGraph.class);
    private final DirectedGraph<Object, VisualizeJobLink> _graph;
    private final Set<Object> _highlighedVertexes;

    public VisualizeJobGraph() {
        this((DirectedGraph<Object, VisualizeJobLink>)new DirectedSparseGraph());
    }

    public VisualizeJobGraph(DirectedGraph<Object, VisualizeJobLink> graph) {
        this._graph = graph;
        this._highlighedVertexes = new HashSet<Object>();
    }

    public VisualizeJobGraph highlightVertex(Object vertex) {
        this._highlighedVertexes.add(vertex);
        return this;
    }

    public static JComponent create(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        BeanDescriptor descriptor;
        VisualizeJobGraph graph = new VisualizeJobGraph();
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(beanJobBuilder.getAnalysisJobBuilder());
        graph.addNodes(sourceColumnFinder, beanJobBuilder, false, true, 2);
        if (beanJobBuilder instanceof OutcomeSourceJob) {
            Outcome[] outcomes;
            for (Outcome outcome : outcomes = ((OutcomeSourceJob)beanJobBuilder).getOutcomes()) {
                graph.addNodes(null, outcome, true, true, 0);
                graph.addEdge(beanJobBuilder, outcome);
            }
        }
        int maxColumns = 5;
        if (beanJobBuilder instanceof InputColumnSourceJob) {
            InputColumn[] outputColumns = ((InputColumnSourceJob)beanJobBuilder).getOutput();
            for (int i = 0; i < outputColumns.length; ++i) {
                if (i == 5) {
                    graph.addNodes(sourceColumnFinder, MORE_COLUMNS_VERTEX, true, true, 0);
                    graph.addEdge(beanJobBuilder, MORE_COLUMNS_VERTEX);
                    graph.highlightVertex(MORE_COLUMNS_VERTEX);
                    break;
                }
                InputColumn outputColumn = outputColumns[i];
                graph.addNodes(null, outputColumn, true, true, 0);
                graph.addEdge(beanJobBuilder, outputColumn);
            }
        }
        if ((descriptor = beanJobBuilder.getDescriptor()).getComponentCategories().contains(new WriteDataCategory())) {
            logger.debug("Not rendering analyzer result for {} because it is a data writer", (Object)descriptor);
        } else {
            Class componentClass = descriptor.getComponentClass();
            if (ReflectionUtils.is((Type)componentClass, HasAnalyzerResult.class)) {
                try {
                    Class typeParameter = ReflectionUtils.getTypeParameter((Class)componentClass, HasAnalyzerResult.class, (int)0);
                    graph.addNodes(null, typeParameter, true, true, 0);
                    graph.addEdge(beanJobBuilder, typeParameter);
                }
                catch (Exception e) {
                    logger.warn("Could not retrieve and present analyzer result type", (Throwable)e);
                }
            }
        }
        graph.highlightVertex(beanJobBuilder);
        return graph.renderGraph();
    }

    public static JComponent create(AnalysisJobBuilder analysisJobBuilder, boolean displayColumns, boolean displayOutcomes) {
        VisualizeJobGraph graph = new VisualizeJobGraph();
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(analysisJobBuilder);
        List tjbs = analysisJobBuilder.getTransformerJobBuilders();
        for (TransformerJobBuilder tjb : tjbs) {
            graph.addNodes(sourceColumnFinder, tjb, displayColumns, displayOutcomes, -1);
        }
        List ajbs = analysisJobBuilder.getAnalyzerJobBuilders();
        for (AnalyzerJobBuilder ajb : ajbs) {
            graph.addNodes(sourceColumnFinder, ajb, displayColumns, displayOutcomes, -1);
        }
        List fjbs = analysisJobBuilder.getFilterJobBuilders();
        for (FilterJobBuilder fjb : fjbs) {
            graph.addNodes(sourceColumnFinder, fjb, displayColumns, displayOutcomes, -1);
        }
        return graph.renderGraph();
    }

    public JComponent renderGraph() {
        int vertexCount = this._graph.getVertexCount();
        if (vertexCount == 0) {
            this._graph.addVertex((Object)"No components in job");
        }
        logger.debug("Rendering graph with {} vertices", (Object)vertexCount);
        VisualizeJobLayoutTransformer layoutTransformer = new VisualizeJobLayoutTransformer(this._graph);
        Dimension preferredSize = layoutTransformer.getPreferredSize();
        StaticLayout layout = new StaticLayout(this._graph, (Transformer)layoutTransformer, preferredSize);
        Collection vertices = this._graph.getVertices();
        for (Object vertex : vertices) {
            layout.transform(vertex);
        }
        if (!layoutTransformer.isTransformed()) {
            throw new IllegalStateException("Layout transformer was never invoked!");
        }
        VisualizationViewer visualizationViewer = new VisualizationViewer((Layout)layout);
        visualizationViewer.setSize(preferredSize);
        GraphUtils.applyStyles(visualizationViewer);
        RenderContext renderContext = visualizationViewer.getRenderContext();
        renderContext.setVertexFontTransformer((Transformer)new Transformer<Object, Font>(){
            private final Font normalFont = WidgetUtils.FONT_SMALL;
            private final Font highlighedFont = this.normalFont.deriveFont(1);

            public Font transform(Object vertex) {
                if (VisualizeJobGraph.this._highlighedVertexes.contains(vertex)) {
                    return this.highlighedFont;
                }
                return this.normalFont;
            }
        });
        renderContext.setVertexLabelTransformer((Transformer)new Transformer<Object, String>(){

            public String transform(Object obj) {
                if (obj instanceof InputColumn) {
                    return ((InputColumn)obj).getName();
                }
                if (obj instanceof AbstractBeanJobBuilder) {
                    return LabelUtils.getLabel((AbstractBeanJobBuilder)((AbstractBeanJobBuilder)obj));
                }
                if (obj instanceof FilterOutcome) {
                    return ((FilterOutcome)obj).getCategory().name();
                }
                if (obj instanceof MergedOutcomeJobBuilder) {
                    return LabelUtils.getLabel((MergedOutcomeJobBuilder)((MergedOutcomeJobBuilder)obj));
                }
                if (obj instanceof Table) {
                    return ((Table)obj).getName();
                }
                if (obj instanceof Class) {
                    Class cls = (Class)obj;
                    if (ReflectionUtils.is((Type)cls, AnalyzerResult.class)) {
                        return "Analyzer result";
                    }
                    return cls.getSimpleName();
                }
                return obj.toString();
            }
        });
        Predicate edgeArrowPredicate = TruePredicate.getInstance();
        renderContext.setEdgeArrowPredicate(edgeArrowPredicate);
        renderContext.setVertexIconTransformer((Transformer)new Transformer<Object, Icon>(){

            public Icon transform(Object obj) {
                Class cls;
                if (obj == VisualizeJobGraph.MORE_COLUMNS_VERTEX || obj instanceof InputColumn) {
                    return imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                }
                if (obj instanceof AbstractBeanJobBuilder) {
                    return IconUtils.getDescriptorIcon(((AbstractBeanJobBuilder)obj).getDescriptor());
                }
                if (obj instanceof FilterOutcome) {
                    return imageManager.getImageIcon("images/component-types/filter-outcome.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                }
                if (obj instanceof MergedOutcomeJobBuilder) {
                    return imageManager.getImageIcon("images/component-types/merged-outcome.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                }
                if (obj instanceof Table) {
                    return imageManager.getImageIcon("images/model/table.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
                }
                if (obj instanceof Class && ReflectionUtils.is((Type)(cls = (Class)obj), AnalyzerResult.class)) {
                    return imageManager.getImageIcon("images/model/result.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
                }
                return imageManager.getImageIcon("images/status/error.png", new ClassLoader[0]);
            }
        });
        DCPanel panel = new DCPanel();
        panel.setPreferredSize(preferredSize);
        panel.setLayout(new BorderLayout());
        panel.add((Component)visualizationViewer, "Center");
        return panel;
    }

    private void addNodes(SourceColumnFinder scf, Object item, boolean displayColumns, boolean displayFilterOutcomes, int recurseCount) {
        if (!displayColumns && item instanceof InputColumn) {
            return;
        }
        if (!displayFilterOutcomes && item instanceof FilterOutcome) {
            return;
        }
        if (!this._graph.containsVertex(item)) {
            Outcome[] requirements;
            OutcomeSourceJob source;
            this._graph.addVertex(item);
            if (recurseCount == 0) {
                return;
            }
            --recurseCount;
            if (item instanceof InputColumnSinkJob) {
                InputColumn[] inputColumns;
                for (InputColumn inputColumn : inputColumns = ((InputColumnSinkJob)item).getInput()) {
                    Table table;
                    InputColumnSourceJob source2;
                    if (displayColumns) {
                        this.addNodes(scf, inputColumn, displayColumns, displayFilterOutcomes, recurseCount);
                        this.addEdge(inputColumn, item);
                        continue;
                    }
                    if (inputColumn.isVirtualColumn() && (source2 = scf.findInputColumnSource(inputColumn)) != null) {
                        this.addNodes(scf, source2, displayColumns, displayFilterOutcomes, recurseCount);
                        this.addEdge(source2, item);
                    }
                    if (!inputColumn.isPhysicalColumn() || (table = inputColumn.getPhysicalColumn().getTable()) == null) continue;
                    this.addNodes(scf, table, displayColumns, displayFilterOutcomes, recurseCount);
                    this.addEdge(table, item);
                }
            }
            if (item instanceof FilterOutcome && (source = scf.findOutcomeSource((Outcome)((FilterOutcome)item))) != null) {
                this.addNodes(scf, source, displayColumns, displayFilterOutcomes, recurseCount);
                this.addEdge(source, item);
            }
            if (item instanceof OutcomeSinkJob && (requirements = ((OutcomeSinkJob)item).getRequirements()) != null && requirements.length > 0) {
                for (InputColumn inputColumn : requirements) {
                    if (displayFilterOutcomes) {
                        this.addNodes(scf, inputColumn, displayColumns, displayFilterOutcomes, recurseCount);
                        this.addEdge(inputColumn, item);
                        continue;
                    }
                    OutcomeSourceJob source2 = scf.findOutcomeSource((Outcome)inputColumn);
                    if (source2 == null) continue;
                    this.addNodes(scf, source2, displayColumns, displayFilterOutcomes, recurseCount);
                    this.addEdge(source2, item);
                }
            }
            if (item instanceof InputColumn) {
                Table table;
                InputColumnSourceJob source3;
                InputColumn inputColumn = (InputColumn)item;
                if (inputColumn.isVirtualColumn() && (source3 = scf.findInputColumnSource(inputColumn)) != null) {
                    this.addNodes(scf, source3, displayColumns, displayFilterOutcomes, recurseCount);
                    this.addEdge(source3, item);
                }
                if (inputColumn.isPhysicalColumn() && (table = inputColumn.getPhysicalColumn().getTable()) != null) {
                    this.addNodes(scf, table, displayColumns, displayFilterOutcomes, recurseCount);
                    this.addEdge(table, item);
                }
            }
        }
    }

    private void addEdge(Object from, Object to) {
        VisualizeJobLink link = new VisualizeJobLink(from, to);
        if (!this._graph.containsEdge((Object)link)) {
            this._graph.addEdge((Object)link, from, to, EdgeType.DIRECTED);
        }
    }
}

