/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.visualization;

import edu.uci.ics.jung.graph.DirectedGraph;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections15.Transformer;
import org.eobjects.datacleaner.widgets.visualization.VisualizeJobLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizeJobLayoutTransformer
implements Transformer<Object, Point2D> {
    private static final Logger logger = LoggerFactory.getLogger(VisualizeJobLayoutTransformer.class);
    private final Comparator<Object> longestTrailComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int prerequisiteCount1 = VisualizeJobLayoutTransformer.this.getAccumulatedPrerequisiteCount(o1);
            int prerequisiteCount2 = VisualizeJobLayoutTransformer.this.getAccumulatedPrerequisiteCount(o2);
            return prerequisiteCount2 - prerequisiteCount1;
        }
    };
    private static final int X_STEP = 160;
    private static final int X_OFFSET = 40;
    private static final int Y_STEP = 80;
    private static final int Y_OFFSET = 40;
    private final DirectedGraph<Object, VisualizeJobLink> _graph;
    private final Map<Object, Point> _points = new IdentityHashMap<Object, Point>();
    private final Map<Integer, Integer> _yCount = new HashMap<Integer, Integer>();
    private volatile boolean _transformed;

    public VisualizeJobLayoutTransformer(DirectedGraph<Object, VisualizeJobLink> graph) {
        this._graph = graph;
        this.createPoints();
        this._transformed = false;
    }

    private void createPoints() {
        List<Object> vertices = this.getEndpointVertices();
        if (vertices.isEmpty()) {
            return;
        }
        Collections.sort(vertices, this.longestTrailComparator);
        int maxPrerequisiteCount = this.getAccumulatedPrerequisiteCount(vertices.get(0));
        logger.debug("Maximum prerequisite count: {}", (Object)maxPrerequisiteCount);
        int x = maxPrerequisiteCount;
        for (Object vertex : vertices) {
            Point point = this.createPoint(vertex, x);
            this._points.put(vertex, point);
            this.createPrerequisitePoints(vertex, x);
        }
    }

    private void createPrerequisitePoints(Object vertex, int vertexX) {
        List<Object> prerequisites = this.getPrerequisites(vertex);
        Collections.sort(prerequisites, this.longestTrailComparator);
        for (Object prerequisiteVertex : prerequisites) {
            if (this._points.containsKey(prerequisiteVertex)) continue;
            int x = vertexX - 1;
            Point point = this.createPoint(prerequisiteVertex, x);
            this._points.put(prerequisiteVertex, point);
            this.createPrerequisitePoints(prerequisiteVertex, x);
        }
    }

    private List<Object> getEndpointVertices() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object vertex : this._graph.getVertices()) {
            Collection outEdges = this._graph.getOutEdges(vertex);
            if (outEdges != null && !outEdges.isEmpty()) continue;
            result.add(vertex);
        }
        return result;
    }

    private Point createPoint(Object vertex, int x) {
        Integer y = this._yCount.get(x);
        if (y == null) {
            y = 0;
        } else {
            Integer n = y;
            Integer n2 = y = Integer.valueOf(y + 1);
        }
        this._yCount.put(x, y);
        if (logger.isDebugEnabled()) {
            logger.debug("Assigning coordinate ({},{}) to vertex {}", new Object[]{x, y, vertex});
        }
        return this.createPoint(x, (int)y);
    }

    private Point createPoint(int x, int y) {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Negative coordinates are not allowed: x=" + x + ",y=" + y);
        }
        return new Point(x * 160 + 40, y * 80 + 40);
    }

    public Dimension getPreferredSize() {
        int y;
        int x;
        if (this._yCount.isEmpty()) {
            x = 1;
            y = 1;
        } else {
            x = new TreeSet<Integer>(this._yCount.keySet()).last();
            y = new TreeSet<Integer>(this._yCount.values()).last();
        }
        int w = 40 + (x + 1) * 160;
        int h = 40 + (y + 1) * 80;
        return new Dimension(w, h);
    }

    public Point2D transform(Object vertex) {
        Point point = this._points.get(vertex);
        if (point == null) {
            logger.warn("Vertex {} has no assigned coordinate!", vertex);
            return new Point(0, 0);
        }
        this._transformed = true;
        return point;
    }

    public boolean isTransformed() {
        return this._transformed;
    }

    private List<Object> getPrerequisites(Object vertex) {
        Collection edges = this._graph.getInEdges(vertex);
        if (edges == null || edges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (VisualizeJobLink edge : edges) {
            result.add(edge.getFrom());
        }
        return result;
    }

    private int getAccumulatedPrerequisiteCount(Object obj) {
        Collection edges = this._graph.getInEdges(obj);
        if (edges == null || edges.isEmpty()) {
            return 0;
        }
        int max = 0;
        for (VisualizeJobLink edge : edges) {
            assert (edge.getTo() == obj);
            Object from = edge.getFrom();
            int count = this.getAccumulatedPrerequisiteCount(from) + 1;
            max = Math.max(max, count);
        }
        return max;
    }
}

