/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.util.ImmutableEntry;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.widgets.LoadingIcon;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetTableModel;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileBasedDatastoreDialog<D extends FileDatastore>
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int SAMPLE_BUFFER_SIZE = 131072;
    private static final int PREVIEW_COLUMNS = 10;
    protected static final ImageManager imageManager = ImageManager.getInstance();
    protected final MutableDatastoreCatalog _mutableDatastoreCatalog;
    protected final D _originalDatastore;
    protected final JButton _addDatastoreButton;
    private final JLabel _statusLabel;
    private final JXTextField _datastoreNameField;
    private final FilenameTextField _filenameField;
    private final DCPanel _outerPanel = new DCPanel();
    private final DCPanel _previewTablePanel;
    private final DCTable _previewTable;
    private final LoadingIcon _loadingIcon;
    private final UserPreferences _userPreferences;

    protected AbstractFileBasedDatastoreDialog(D originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(windowContext, imageManager.getImage("images/window/banner-datastores.png", new ClassLoader[0]));
        this._originalDatastore = originalDatastore;
        this._mutableDatastoreCatalog = mutableDatastoreCatalog;
        this._userPreferences = userPreferences;
        this._datastoreNameField = WidgetFactory.createTextField("Datastore name");
        this._statusLabel = DCLabel.bright("Please select file");
        this._filenameField = new FilenameTextField(this._userPreferences.getOpenDatastoreDirectory(), true);
        this._addDatastoreButton = WidgetFactory.createButton("Save datastore", this.getDatastoreIconPath());
        this._addDatastoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object datastore = AbstractFileBasedDatastoreDialog.this.createDatastore(AbstractFileBasedDatastoreDialog.this.getDatastoreName(), AbstractFileBasedDatastoreDialog.this.getFilename());
                if (AbstractFileBasedDatastoreDialog.this._originalDatastore != null) {
                    AbstractFileBasedDatastoreDialog.this._mutableDatastoreCatalog.removeDatastore((Datastore)AbstractFileBasedDatastoreDialog.this._originalDatastore);
                }
                AbstractFileBasedDatastoreDialog.this._mutableDatastoreCatalog.addDatastore((Datastore)datastore);
                AbstractFileBasedDatastoreDialog.this.dispose();
            }
        });
        if (this._originalDatastore != null) {
            this._datastoreNameField.setText(this._originalDatastore.getName());
            this._datastoreNameField.setEnabled(false);
            this._filenameField.setFilename(this._originalDatastore.getFilename());
        }
        this._datastoreNameField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                AbstractFileBasedDatastoreDialog.this.validateAndUpdate();
            }
        });
        this.setFileFilters(this._filenameField);
        this._filenameField.getTextField().getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                AbstractFileBasedDatastoreDialog.this.validateAndUpdate();
            }
        });
        this._filenameField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                File dir = file.isDirectory() ? file : file.getParentFile();
                AbstractFileBasedDatastoreDialog.this._userPreferences.setOpenDatastoreDirectory(dir);
                if (StringUtils.isNullOrEmpty((String)AbstractFileBasedDatastoreDialog.this._datastoreNameField.getText())) {
                    AbstractFileBasedDatastoreDialog.this._datastoreNameField.setText(file.getName());
                }
                AbstractFileBasedDatastoreDialog.this.validateAndUpdate();
                AbstractFileBasedDatastoreDialog.this.onFileSelected(file);
            }
        });
        if (this.isDirectoryBased()) {
            this._filenameField.setFileSelectionMode(1);
        }
        if (this.isPreviewTableEnabled()) {
            this._previewTable = new DCTable(new DefaultTableModel(7, 10));
            this._previewTablePanel = this._previewTable.toPanel();
            this._previewTablePanel.setBorder(new EmptyBorder(0, 10, 0, 10));
            this._loadingIcon = new LoadingIcon();
            this._loadingIcon.setVisible(false);
            this._loadingIcon.setPreferredSize(this._previewTablePanel.getPreferredSize());
        } else {
            this._previewTable = null;
            this._previewTablePanel = null;
            this._loadingIcon = null;
        }
    }

    protected void onFileSelected(File file) {
    }

    protected abstract D createDatastore(String var1, String var2);

    protected abstract String getDatastoreIconPath();

    protected abstract void setFileFilters(FilenameTextField var1);

    protected final void validateAndUpdate() {
        boolean valid = this.validateForm();
        this._addDatastoreButton.setEnabled(valid);
        if (valid) {
            this.updatePreviewTable();
        }
    }

    protected void setStatusValid() {
        this._statusLabel.setText("Datastore ready");
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    protected void setStatusWarning(String text) {
        this._statusLabel.setText(text);
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/warning.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    protected void setStatusError(String text) {
        this._statusLabel.setText(text);
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    protected boolean validateForm() {
        String datastoreName;
        String filename = this._filenameField.getFilename();
        if (StringUtils.isNullOrEmpty((String)filename)) {
            this.setStatusError("Please enter or select a filename");
            return false;
        }
        File file = new File(filename);
        if (!file.exists()) {
            this.setStatusError("The file does not exist!");
            return false;
        }
        if (this.isDirectoryBased()) {
            if (!file.isDirectory()) {
                this.setStatusError("Not a valid directory!");
                return false;
            }
        } else if (!file.isFile()) {
            this.setStatusError("Not a valid file!");
            return false;
        }
        if (StringUtils.isNullOrEmpty((String)(datastoreName = this._datastoreNameField.getText()))) {
            this.setStatusError("Please enter a datastore name");
            return false;
        }
        this.setStatusValid();
        return true;
    }

    protected boolean isPreviewTableEnabled() {
        return false;
    }

    @Override
    protected int getDialogWidth() {
        if (this.isPreviewTableEnabled()) {
            return 550;
        }
        return 400;
    }

    protected List<Map.Entry<String, JComponent>> getFormElements() {
        ArrayList<Map.Entry<String, JComponent>> res = new ArrayList<Map.Entry<String, JComponent>>();
        res.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Datastore name", (Object)this._datastoreNameField));
        if (this.isDirectoryBased()) {
            res.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Directory", (Object)this._filenameField));
        } else {
            res.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Filename", (Object)this._filenameField));
        }
        return res;
    }

    public String getDatastoreName() {
        return this._datastoreNameField.getText();
    }

    public String getFilename() {
        return this._filenameField.getFilename();
    }

    @Override
    protected final JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        List<Map.Entry<String, JComponent>> formElements = this.getFormElements();
        int row = 0;
        for (Map.Entry<String, JComponent> entry : formElements) {
            String key = entry.getKey();
            if (StringUtils.isNullOrEmpty((String)key)) {
                WidgetUtils.addToGridBag((Component)entry.getValue(), (JPanel)formPanel, 0, row, 2, 1);
            } else {
                WidgetUtils.addToGridBag(DCLabel.bright(key + ":"), formPanel, 0, row);
                WidgetUtils.addToGridBag(entry.getValue(), formPanel, 1, row);
            }
            ++row;
        }
        if (this.isPreviewTableEnabled()) {
            WidgetUtils.addToGridBag((Component)this._loadingIcon, (JPanel)formPanel, 0, row, 2, 1);
            ++row;
        }
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.add(this._addDatastoreButton);
        DCPanel centerPanel = new DCPanel();
        centerPanel.setLayout((LayoutManager)new VerticalLayout(4));
        centerPanel.add(formPanel);
        if (this.isPreviewTableEnabled()) {
            centerPanel.add(this._previewTablePanel);
        }
        centerPanel.add(buttonPanel);
        centerPanel.setBorder(WidgetUtils.BORDER_TOP_PADDING);
        JXStatusBar statusBar = WidgetFactory.createStatusBar(this._statusLabel);
        this._outerPanel.setLayout(new BorderLayout());
        this._outerPanel.add((Component)centerPanel, "Center");
        this._outerPanel.add((Component)statusBar, "South");
        String descriptionText = this.getDescriptionText();
        if (descriptionText != null) {
            DescriptionLabel descriptionLabel = new DescriptionLabel();
            descriptionLabel.setText(descriptionText);
            this._outerPanel.add((Component)descriptionLabel, "North");
        }
        this.validateAndUpdate();
        return this._outerPanel;
    }

    private void updatePreviewTable() {
        if (!this.isPreviewTableEnabled()) {
            return;
        }
        this._addDatastoreButton.setEnabled(false);
        this._previewTable.setVisible(false);
        this._loadingIcon.setVisible(true);
        new SwingWorker<DataSet, Void>(){

            @Override
            protected DataSet doInBackground() throws Exception {
                return AbstractFileBasedDatastoreDialog.this.getPreviewData(AbstractFileBasedDatastoreDialog.this.getFilename());
            }

            @Override
            protected void done() {
                try {
                    DataSet dataSet = (DataSet)this.get();
                    if (dataSet != null) {
                        DataSetTableModel tableModel = new DataSetTableModel(dataSet);
                        AbstractFileBasedDatastoreDialog.this._previewTable.setModel((TableModel)tableModel);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ExecutionException) {
                        e = e.getCause();
                    }
                    if (AbstractFileBasedDatastoreDialog.this.logger.isWarnEnabled()) {
                        AbstractFileBasedDatastoreDialog.this.logger.warn("Error creating preview data: " + e.getMessage(), e);
                    }
                    AbstractFileBasedDatastoreDialog.this.setStatusError("Error create preview data: " + e.getMessage());
                }
                AbstractFileBasedDatastoreDialog.this._previewTable.setVisible(true);
                AbstractFileBasedDatastoreDialog.this._loadingIcon.setVisible(false);
                AbstractFileBasedDatastoreDialog.this._addDatastoreButton.setEnabled(true);
            }
        }.execute();
    }

    private final DataSet getPreviewData(String filename) {
        if (!this.isPreviewDataAvailable()) {
            this.logger.info("Not displaying preview table because isPreviewDataAvailable() returned false");
            return null;
        }
        D datastore = this.getPreviewDatastore(filename);
        DatastoreConnection con = datastore.openConnection();
        DataContext dc = con.getDataContext();
        Table table = this.getPreviewTable(dc);
        Column[] columns = table.getColumns();
        if (columns.length > this.getPreviewColumns()) {
            columns = Arrays.copyOf(columns, this.getPreviewColumns());
        }
        Query q = dc.query().from(table).select(columns).toQuery();
        q.setMaxRows(Integer.valueOf(7));
        DataSet dataSet = dc.executeQuery(q);
        con.close();
        return dataSet;
    }

    protected String getDescriptionText() {
        return "Configure your datastore in this dialog.";
    }

    protected boolean isPreviewDataAvailable() {
        return true;
    }

    protected Table getPreviewTable(DataContext dc) {
        return dc.getDefaultSchema().getTables()[0];
    }

    protected int getPreviewColumns() {
        return 10;
    }

    protected D getPreviewDatastore(String filename) {
        D datastore = this.createDatastore("Preview", filename);
        return datastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSampleBuffer() {
        byte[] byArray;
        File file = new File(this.getFilename());
        byte[] bytes = new byte[131072];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int bufferSize = fileInputStream.read(bytes, 0, 131072);
            if (bufferSize != -1 && bufferSize != 131072) {
                bytes = Arrays.copyOf(bytes, bufferSize);
            }
            byArray = bytes;
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                this.logger.error("IOException occurred while reading sample buffer", (Throwable)e);
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{fileInputStream});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{fileInputStream});
            return byArray2;
        }
        FileHelper.safeClose((Object[])new Object[]{fileInputStream});
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] readSampleBuffer(byte[] bytes, String charSet) {
        char[] buffer = new char[bytes.length];
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charSet);
            int bufferSize = reader.read(buffer);
            if (bufferSize != -1) {
                buffer = Arrays.copyOf(buffer, bufferSize);
            }
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Error reading from file: " + e.getMessage(), (Throwable)e);
            }
            this.setStatusError("Error reading from file: " + e.getMessage());
            char[] cArray = new char[]{};
            return cArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    this.logger.debug("Could not close reader", (Throwable)ioe);
                }
            }
        }
        return buffer;
    }

    protected DCTable getPreviewTable() {
        return this._previewTable;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage(this.getDatastoreIconPath(), new ClassLoader[0]);
    }

    protected boolean isDirectoryBased() {
        return false;
    }
}

