/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.windows.DCWindow;

public abstract class AbstractWindow
extends JFrame
implements DCWindow,
WindowListener {
    public static final String SYSTEM_PROPERTY_HIDE_WINDOWS = "DataCleaner.Windows.Hide";
    private static final long serialVersionUID = 1L;
    private volatile boolean initialized = false;
    private final WindowContext _windowContext;

    public AbstractWindow(WindowContext windowContext) {
        this._windowContext = windowContext;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.getContentPane().setBackground(WidgetUtils.BG_COLOR_BRIGHT);
    }

    protected void initialize() {
        this.updateWindowTitle();
        this.setIconImage(this.getWindowIcon());
        this.setResizable(this.isWindowResizable());
        JComponent content = this.getWindowContent();
        this.getContentPane().add(content);
        this.autoSetSize(content);
        this._windowContext.onShow(this);
    }

    public Dimension autoSetSize() {
        return this.autoSetSize(this.getContentPane().getComponent(0));
    }

    @Override
    public void open() {
        if ("true".equals(System.getProperty(SYSTEM_PROPERTY_HIDE_WINDOWS))) {
            this.initialize();
            return;
        }
        this.setVisible(true);
    }

    @Override
    public void close() {
        if (this.isVisible()) {
            this.dispose();
        }
    }

    public Dimension autoSetSize(Component content) {
        Dimension preferredSize = content.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int maxWidth = toolkit.getScreenSize().width - 30;
        int maxHeight = toolkit.getScreenSize().height - 30;
        preferredSize.width = Math.min(preferredSize.width, maxWidth);
        preferredSize.height = Math.min(preferredSize.height, maxHeight);
        if (this.isVisible()) {
            Dimension currentSize = this.getContentPane().getSize();
            preferredSize.width = Math.max(preferredSize.width, currentSize.width);
            preferredSize.width = Math.max(preferredSize.height, currentSize.height);
        }
        this.getContentPane().setPreferredSize(preferredSize);
        this.pack();
        if (this.isCentered()) {
            this.centerOnScreen();
        }
        return preferredSize;
    }

    protected abstract boolean isWindowResizable();

    protected abstract boolean isCentered();

    @Override
    public final void setVisible(boolean b) {
        if (!b) {
            throw new UnsupportedOperationException("Window does not support hiding, consider using dispose()");
        }
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        super.setVisible(true);
        this.onWindowVisible();
    }

    protected void onWindowVisible() {
    }

    protected void updateWindowTitle() {
        String windowTitle = this.getWindowTitle();
        if (windowTitle == null) {
            windowTitle = "DataCleaner";
        } else if (windowTitle.indexOf("DataCleaner") == -1) {
            windowTitle = windowTitle + " | DataCleaner";
        }
        this.setTitle(windowTitle);
    }

    protected abstract JComponent getWindowContent();

    public void centerOnScreen() {
        WidgetUtils.centerOnScreen(this);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public final void windowClosing(WindowEvent e) {
        boolean dispose = this.onWindowClosing();
        if (dispose) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this._windowContext.onDispose(this);
        super.dispose();
    }

    @Override
    public WindowContext getWindowContext() {
        return this._windowContext;
    }

    protected boolean onWindowClosing() {
        return true;
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public Component toComponent() {
        return this;
    }
}

