/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import javax.inject.Inject;
import javax.swing.filechooser.FileFilter;
import org.eobjects.analyzer.connection.AccessDatastore;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;

public final class AccessDatastoreDialog
extends AbstractFileBasedDatastoreDialog<AccessDatastore> {
    private static final long serialVersionUID = 1L;

    @Inject
    protected AccessDatastoreDialog(@Nullable AccessDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
    }

    @Override
    protected String getBannerTitle() {
        return "MS Access database";
    }

    @Override
    public String getWindowTitle() {
        return "MS Access database | Datastore";
    }

    @Override
    protected AccessDatastore createDatastore(String name, String filename) {
        return new AccessDatastore(name, filename);
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/access.png";
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        FileFilter combinedFilter = FileFilters.combined("Any Access database (.mdb, .accdb)", FileFilters.MDB, FileFilters.ACCDB);
        filenameField.addChoosableFileFilter(FileFilters.MDB);
        filenameField.addChoosableFileFilter(FileFilters.ACCDB);
        filenameField.addChoosableFileFilter(FileFilters.ALL);
        filenameField.setSelectedFileFilter(combinedFilter);
    }
}

