/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DatabaseDriversPanel;
import org.eobjects.datacleaner.user.UserDatabaseDriver;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ExtensionFilter;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.VerticalLayout;

public class AddDatabaseDriverDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final List<FilenameTextField> _filenameTextFields;
    private final DCPanel _filesPanel;
    private final DCComboBox<String> _driverClassNameComboBox;
    private final DatabaseDriverCatalog _databaseDriverCatalog;
    private final JButton _addDriverButton;
    private final DCLabel _statusLabel = DCLabel.bright("");
    private final DatabaseDriversPanel _databaseDriversPanel;
    private final UserPreferences _userPreferences;

    public AddDatabaseDriverDialog(DatabaseDriverCatalog databaseDriverCatalog, DatabaseDriversPanel databaseDriversPanel, WindowContext windowContext, UserPreferences userPreferences) {
        super(windowContext);
        this._databaseDriverCatalog = databaseDriverCatalog;
        this._databaseDriversPanel = databaseDriversPanel;
        this._userPreferences = userPreferences;
        this._filenameTextFields = new ArrayList<FilenameTextField>();
        this._filesPanel = new DCPanel();
        this._filesPanel.setLayout((LayoutManager)new VerticalLayout(4));
        TreeSet<String> classNames = new TreeSet<String>();
        classNames.add("");
        List<DatabaseDriverDescriptor> drivers = this._databaseDriverCatalog.getDatabaseDrivers();
        for (DatabaseDriverDescriptor dd : drivers) {
            classNames.add(dd.getDriverClassName());
        }
        this._driverClassNameComboBox = new DCComboBox(classNames);
        this._driverClassNameComboBox.setEditable(true);
        this._driverClassNameComboBox.addListener(new DCComboBox.Listener<String>(){

            @Override
            public void onItemSelected(String item) {
                AddDatabaseDriverDialog.this.updateStatus();
            }
        });
        this._addDriverButton = WidgetFactory.createButton("Add database driver", "images/filetypes/archive.png");
        this._addDriverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UserDatabaseDriver userDatabaseDriver = new UserDatabaseDriver(AddDatabaseDriverDialog.this.getDriverFiles(), AddDatabaseDriverDialog.this.getDriverClassName());
                AddDatabaseDriverDialog.this._userPreferences.getDatabaseDrivers().add(userDatabaseDriver);
                try {
                    userDatabaseDriver.loadDriver();
                    AddDatabaseDriverDialog.this._databaseDriversPanel.updateDriverList();
                    AddDatabaseDriverDialog.this.dispose();
                }
                catch (IllegalStateException e) {
                    WidgetUtils.showErrorMessage("Error while loading driver", "Error message: " + e.getMessage(), e);
                }
            }
        });
        this.addFilenameTextField();
        this.updateStatus();
    }

    private File[] getDriverFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (FilenameTextField filenameTextField : this._filenameTextFields) {
            String filename = filenameTextField.getFilename();
            if (StringUtils.isNullOrEmpty((String)filename)) continue;
            files.add(new File(filename));
        }
        return files.toArray(new File[files.size()]);
    }

    private String getDriverClassName() {
        String selectedItem = this._driverClassNameComboBox.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.toString();
    }

    private void addFilenameTextField() {
        FilenameTextField filenameTextField = new FilenameTextField(this._userPreferences.getConfiguredFileDirectory(), true);
        filenameTextField.setSelectedFileFilter(new ExtensionFilter("JDBC driver JAR file (.jar)", ".jar"));
        filenameTextField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                AddDatabaseDriverDialog.this.updateStatus();
            }
        });
        filenameTextField.getTextField().getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                AddDatabaseDriverDialog.this.updateStatus();
            }
        });
        this._filenameTextFields.add(filenameTextField);
        this._filesPanel.add(filenameTextField);
        this._filesPanel.updateUI();
    }

    private void removeFilenameTextField() {
        int index = this._filenameTextFields.size() - 1;
        if (index > 0) {
            this._filenameTextFields.remove(index);
            this._filesPanel.remove(index);
            this._filesPanel.updateUI();
        }
    }

    private void updateStatus() {
        String driverClassName = this.getDriverClassName();
        if (StringUtils.isNullOrEmpty((String)driverClassName)) {
            this._statusLabel.setText("Please enter or select a driver class name");
            this._statusLabel.setIcon(this.imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDriverButton.setEnabled(false);
            return;
        }
        File[] files = this.getDriverFiles();
        if (files == null || files.length == 0) {
            this._statusLabel.setText("Please enter or select one or more driver files");
            this._statusLabel.setIcon(this.imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDriverButton.setEnabled(false);
            return;
        }
        for (File file : files) {
            if (file.exists() && file.isFile()) continue;
            this._statusLabel.setText("The file " + file.getPath() + " does not exist or is not a valid file");
            this._statusLabel.setIcon(this.imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDriverButton.setEnabled(false);
            return;
        }
        this._statusLabel.setText("Database driver ready");
        this._statusLabel.setIcon(this.imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        this._addDriverButton.setEnabled(true);
    }

    @Override
    protected String getBannerTitle() {
        return "Add database driver\nLocal JAR file(s)";
    }

    @Override
    protected int getDialogWidth() {
        return 400;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel driverClassOuterPanel = new DCPanel().setTitledBorder("Driver class name");
        driverClassOuterPanel.add(this._driverClassNameComboBox);
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDatabaseDriverDialog.this.addFilenameTextField();
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDatabaseDriverDialog.this.removeFilenameTextField();
            }
        });
        DCPanel filesButtonPanel = new DCPanel();
        filesButtonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        filesButtonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        filesButtonPanel.add(addButton);
        filesButtonPanel.add(removeButton);
        DCPanel filesOuterPanel = new DCPanel().setTitledBorder("Driver JAR file(s)");
        filesOuterPanel.setLayout(new BorderLayout());
        filesOuterPanel.add((Component)this._filesPanel, "Center");
        filesOuterPanel.add((Component)filesButtonPanel, "East");
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        buttonPanel.add(this._addDriverButton);
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout((LayoutManager)new VerticalLayout(4));
        mainPanel.add(driverClassOuterPanel);
        mainPanel.add(filesOuterPanel);
        mainPanel.add(buttonPanel);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)mainPanel, "Center");
        outerPanel.add((Component)WidgetFactory.createStatusBar(this._statusLabel), "South");
        outerPanel.setPreferredSize(400, 350);
        return outerPanel;
    }

    @Override
    public String getWindowTitle() {
        return "Add database driver | Local JAR file(s)";
    }
}

