/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.vfs2.FileObject;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerChangeListener;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.ExplorerChangeListener;
import org.eobjects.analyzer.job.builder.ExplorerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterChangeListener;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.MergedOutcomeJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.job.builder.UnconfiguredConfiguredPropertyException;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.Main;
import org.eobjects.datacleaner.actions.AnalyzeButtonActionListener;
import org.eobjects.datacleaner.actions.HideTabTextActionListener;
import org.eobjects.datacleaner.actions.JobBuilderTabTextActionListener;
import org.eobjects.datacleaner.actions.RenameComponentActionListener;
import org.eobjects.datacleaner.actions.RunAnalysisActionListener;
import org.eobjects.datacleaner.actions.SaveAnalysisJobActionListener;
import org.eobjects.datacleaner.actions.TransformButtonActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.guice.JobFile;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.AbstractJobBuilderPanel;
import org.eobjects.datacleaner.panels.AnalyzerJobBuilderPresenter;
import org.eobjects.datacleaner.panels.ComponentJobBuilderPresenter;
import org.eobjects.datacleaner.panels.ComponentJobBuilderRenderingFormat;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DatastoreListPanel;
import org.eobjects.datacleaner.panels.FilterJobBuilderPresenter;
import org.eobjects.datacleaner.panels.MetadataPanel;
import org.eobjects.datacleaner.panels.SchemaTreePanel;
import org.eobjects.datacleaner.panels.SourceColumnsPanel;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPresenter;
import org.eobjects.datacleaner.panels.maxrows.MaxRowsFilterShortcutPanel;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CollapsibleTreePanel;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCPersistentSizedPanel;
import org.eobjects.datacleaner.widgets.DCPopupBubble;
import org.eobjects.datacleaner.widgets.DCWindowMenuBar;
import org.eobjects.datacleaner.widgets.LoginStatusLabel;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.widgets.tabs.TabCloseEvent;
import org.eobjects.datacleaner.widgets.tabs.TabCloseListener;
import org.eobjects.datacleaner.windows.AbstractWindow;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.VisualizeJobWindow;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class AnalysisJobBuilderWindowImpl
extends AbstractWindow
implements AnalysisJobBuilderWindow,
AnalyzerChangeListener,
ExplorerChangeListener,
TransformerChangeListener,
FilterChangeListener,
SourceColumnChangeListener,
TabCloseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AnalysisJobBuilderWindow.class);
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final int TAB_ICON_SIZE = IconUtils.ICON_SIZE_LARGE;
    private static final int DEFAULT_WINDOW_WIDTH = 900;
    private static final int DEFAULT_WINDOW_HEIGHT = 630;
    private static final int SOURCE_TAB = 0;
    private static final int METADATA_TAB = 1;
    private final Map<AnalyzerJobBuilder<?>, AnalyzerJobBuilderPresenter> _analyzerPresenters = new LinkedHashMap();
    private final Map<TransformerJobBuilder<?>, TransformerJobBuilderPresenter> _transformerPresenters = new LinkedHashMap();
    private final Map<FilterJobBuilder<?, ?>, FilterJobBuilderPresenter> _filterPresenters = new LinkedHashMap();
    private final Map<ComponentJobBuilderPresenter, JComponent> _jobBuilderTabs = new HashMap<ComponentJobBuilderPresenter, JComponent>();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final AnalyzerBeansConfiguration _configuration;
    private final RendererFactory _componentJobBuilderPresenterRendererFactory;
    private final CloseableTabbedPane _tabbedPane;
    private final DCLabel _statusLabel = DCLabel.bright("");
    private final CollapsibleTreePanel _leftPanel;
    private final SourceColumnsPanel _sourceColumnsPanel;
    private final SchemaTreePanel _schemaTreePanel;
    private final JButton _saveButton;
    private final JButton _saveAsButton;
    private final JButton _visualizeButton;
    private final JButton _transformButton;
    private final JButton _analyzeButton;
    private final JButton _runButton;
    private final Provider<RunAnalysisActionListener> _runAnalysisActionProvider;
    private final Provider<SaveAnalysisJobActionListener> _saveAnalysisJobActionListenerProvider;
    private final Provider<AnalyzeButtonActionListener> _addAnalyzerActionListenerProvider;
    private final Provider<TransformButtonActionListener> _addTransformerActionListenerProvider;
    private final DCGlassPane _glassPane;
    private final Ref<DatastoreListPanel> _datastoreListPanelRef;
    private final UserPreferences _userPreferences;
    private final Injector _injectorWithGlassPane;
    private final DCWindowMenuBar _windowMenuBar;
    private volatile AbstractJobBuilderPanel _latestPanel = null;
    private final DCPanel _sourceTabOuterPanel;
    private FileObject _jobFilename;
    private Datastore _datastore;
    private DatastoreConnection _datastoreConnection;
    private boolean _datastoreSelectionEnabled;
    private final MetadataPanel _metadataPanel;

    @Inject
    protected AnalysisJobBuilderWindowImpl(AnalyzerBeansConfiguration configuration, WindowContext windowContext, SchemaTreePanel schemaTreePanel, SourceColumnsPanel sourceColumnsPanel, Provider<RunAnalysisActionListener> runAnalysisActionProvider, MetadataPanel metadataPanel, AnalysisJobBuilder analysisJobBuilder, InjectorBuilder injectorBuilder, UserPreferences userPreferences, @Nullable @JobFile FileObject jobFilename, DCWindowMenuBar windowMenuBar, Provider<SaveAnalysisJobActionListener> saveAnalysisJobActionListenerProvider, Provider<AnalyzeButtonActionListener> addAnalyzerActionListenerProvider, Provider<TransformButtonActionListener> addTransformerActionListenerProvider, UsageLogger usageLogger) {
        super(windowContext);
        this._jobFilename = jobFilename;
        this._configuration = configuration;
        this._windowMenuBar = windowMenuBar;
        this._runAnalysisActionProvider = runAnalysisActionProvider;
        this._saveAnalysisJobActionListenerProvider = saveAnalysisJobActionListenerProvider;
        this._addAnalyzerActionListenerProvider = addAnalyzerActionListenerProvider;
        this._addTransformerActionListenerProvider = addTransformerActionListenerProvider;
        this._userPreferences = userPreferences;
        if (analysisJobBuilder == null) {
            this._analysisJobBuilder = new AnalysisJobBuilder(this._configuration);
        } else {
            this._analysisJobBuilder = analysisJobBuilder;
            DatastoreConnection con = this._analysisJobBuilder.getDatastoreConnection();
            if (con != null) {
                this._datastore = con.getDatastore();
            }
        }
        this._windowMenuBar.setAnalysisJobBuilder(this._analysisJobBuilder);
        this._datastoreSelectionEnabled = true;
        this._componentJobBuilderPresenterRendererFactory = new RendererFactory(configuration);
        this._glassPane = new DCGlassPane(this);
        this._injectorWithGlassPane = injectorBuilder.with(DCGlassPane.class, (Object)this._glassPane).createInjector();
        this._analysisJobBuilder.getAnalyzerChangeListeners().add(this);
        this._analysisJobBuilder.getTransformerChangeListeners().add(this);
        this._analysisJobBuilder.getFilterChangeListeners().add(this);
        this._analysisJobBuilder.getSourceColumnListeners().add(this);
        this._saveButton = new JButton("Save", imageManager.getImageIcon("images/actions/save.png", new ClassLoader[0]));
        this._saveAsButton = new JButton("Save As...", imageManager.getImageIcon("images/actions/save.png", new ClassLoader[0]));
        this._visualizeButton = this.createToolbarButton("Visualize", "images/actions/visualize.png", "<html><b>Visualize job</b><br/>Visualize the components of this job in a flow-chart.</html>");
        this._transformButton = this.createToolbarButton("Transform", "images/component-types/transformer.png", "<html><b>Transformers and filters</b><br/>Preprocess or filter your data in order to extract, limit, combine or generate separate values.</html>");
        this._analyzeButton = this.createToolbarButton("Analyze", "images/component-types/analyzer.png", "<html><b>Analyzers</b><br/>Analyzers provide Data Quality analysis and profiling operations.</html>");
        this._runButton = new JButton("Execute", imageManager.getImageIcon("images/actions/execute.png", new ClassLoader[0]));
        this._datastoreListPanelRef = new LazyRef<DatastoreListPanel>(){

            protected DatastoreListPanel fetch() {
                DatastoreListPanel datastoreListPanel = (DatastoreListPanel)AnalysisJobBuilderWindowImpl.this._injectorWithGlassPane.getInstance(DatastoreListPanel.class);
                datastoreListPanel.setBorder(new EmptyBorder(4, 4, 0, 150));
                return datastoreListPanel;
            }
        };
        this._sourceColumnsPanel = sourceColumnsPanel;
        this._tabbedPane = new CloseableTabbedPane(false);
        this._tabbedPane.addTabCloseListener(this);
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                Component selectedComponent;
                if (AnalysisJobBuilderWindowImpl.this._latestPanel != null) {
                    AnalysisJobBuilderWindowImpl.this._latestPanel.applyPropertyValues(false);
                }
                if ((selectedComponent = AnalysisJobBuilderWindowImpl.this._tabbedPane.getSelectedComponent()) instanceof AbstractJobBuilderPanel) {
                    AnalysisJobBuilderWindowImpl.this._latestPanel = (AbstractJobBuilderPanel)selectedComponent;
                } else {
                    AnalysisJobBuilderWindowImpl.this._latestPanel = null;
                }
                AnalysisJobBuilderWindowImpl.this.updateStatusLabel();
            }
        });
        this._sourceTabOuterPanel = new DCPanel(imageManager.getImage("images/window/source-tab-background.png", new ClassLoader[0]), 95, 95, WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._sourceTabOuterPanel.setLayout((LayoutManager)new VerticalLayout(0));
        this._schemaTreePanel = schemaTreePanel;
        this._metadataPanel = metadataPanel;
        this._leftPanel = new CollapsibleTreePanel(this._schemaTreePanel);
        this._leftPanel.setVisible(false);
        this._leftPanel.setCollapsed(true);
        this._schemaTreePanel.setUpdatePanel(this._leftPanel);
    }

    private JButton createToolbarButton(String text, String iconPath, String popupDescription) {
        JButton button = new JButton(text, imageManager.getImageIcon(iconPath, new ClassLoader[0]));
        button.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        button.setFocusPainted(false);
        if (popupDescription != null) {
            DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, popupDescription, 0, 0, iconPath);
            popupBubble.attachTo(button);
        }
        return button;
    }

    @Override
    public boolean isDatastoreSet() {
        return this._datastore != null;
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.setDatastore(datastore, false);
    }

    @Override
    public void setDatastore(Datastore datastore, boolean expandTree) {
        DatastoreConnection con = datastore == null ? null : datastore.openConnection();
        this._datastore = datastore;
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
        this._analysisJobBuilder.setDatastore(datastore);
        this._schemaTreePanel.setDatastore(datastore, expandTree);
        this._datastoreConnection = con;
        if (datastore == null) {
            this._analysisJobBuilder.reset();
            this.displayDatastoreSelection();
        } else {
            this.displaySourceColumnsList();
        }
        this.updateStatusLabel();
    }

    private void displaySourceColumnsList() {
        this._leftPanel.setVisible(true);
        if (this._leftPanel.isCollapsed()) {
            this._leftPanel.setCollapsed(false);
        }
        this._sourceColumnsPanel.setVisible(true);
        ((DatastoreListPanel)this._datastoreListPanelRef.get()).setVisible(false);
    }

    private void displayDatastoreSelection() {
        if (this.isShowing() && this._datastore == null) {
            if (!this._leftPanel.isCollapsed()) {
                this._leftPanel.setCollapsed(true);
            }
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalysisJobBuilderWindowImpl.this._leftPanel.setVisible(false);
                }
            });
            timer.setRepeats(false);
            timer.start();
            this._sourceColumnsPanel.setVisible(false);
            ((DatastoreListPanel)this._datastoreListPanelRef.get()).setVisible(true);
            ((DatastoreListPanel)this._datastoreListPanelRef.get()).requestSearchFieldFocus();
        }
    }

    @Override
    protected void onWindowVisible() {
        this.displayDatastoreSelection();
    }

    public void updateStatusLabel() {
        boolean success = false;
        if (this._datastore == null) {
            this.setStatusLabelText("Welcome to DataCleaner " + Main.VERSION);
            this._statusLabel.setIcon(imageManager.getImageIcon("images/window/app-icon.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        } else {
            try {
                if (this._analysisJobBuilder.isConfigured(true)) {
                    success = true;
                    this.setStatusLabelText("Job is correctly configured");
                    this.setStatusLabelValid();
                } else {
                    this.setStatusLabelText("Job is not correctly configured");
                    this.setStatusLabelWarning();
                }
            }
            catch (Exception ex) {
                String errorMessage;
                logger.debug("Job not correctly configured", (Throwable)ex);
                if (ex instanceof UnconfiguredConfiguredPropertyException) {
                    UnconfiguredConfiguredPropertyException unconfiguredConfiguredPropertyException = (UnconfiguredConfiguredPropertyException)ex;
                    ConfiguredPropertyDescriptor configuredProperty = unconfiguredConfiguredPropertyException.getConfiguredProperty();
                    AbstractBeanJobBuilder beanJobBuilder = unconfiguredConfiguredPropertyException.getBeanJobBuilder();
                    errorMessage = "Property '" + configuredProperty.getName() + "' in " + LabelUtils.getLabel((AbstractBeanJobBuilder)beanJobBuilder) + " is not set!";
                } else {
                    errorMessage = ex.getMessage();
                }
                this.setStatusLabelText("Job error status: " + errorMessage);
                this.setStatusLabelError();
            }
        }
        this._runButton.setEnabled(success);
    }

    @Override
    public void setStatusLabelError() {
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    @Override
    public void setStatusLabelNotice() {
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/info.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    @Override
    public void setStatusLabelValid() {
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    @Override
    public void setStatusLabelWarning() {
        this._statusLabel.setIcon(imageManager.getImageIcon("images/status/warning.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    }

    @Override
    public String getStatusLabelText() {
        return this._statusLabel.getText();
    }

    @Override
    public void setStatusLabelText(String statusLabelText) {
        this._statusLabel.setText(statusLabelText);
    }

    @Override
    protected boolean onWindowClosing() {
        boolean windowClosing;
        boolean exit;
        if (!super.onWindowClosing()) {
            return false;
        }
        int count = this.getWindowContext().getWindowCount(AnalysisJobBuilderWindow.class);
        if (count == 1) {
            if (this.isDatastoreSet() && this.isDatastoreSelectionEnabled()) {
                this.resetJob();
                exit = false;
                windowClosing = false;
            } else {
                windowClosing = exit = this.getWindowContext().showExitDialog();
            }
        } else {
            exit = false;
            windowClosing = true;
        }
        if (windowClosing) {
            this._analysisJobBuilder.getAnalyzerChangeListeners().remove(this);
            this._analysisJobBuilder.getTransformerChangeListeners().remove(this);
            this._analysisJobBuilder.getFilterChangeListeners().remove(this);
            this._analysisJobBuilder.getSourceColumnListeners().remove(this);
            this._analysisJobBuilder.close();
            if (this._datastoreConnection != null) {
                this._datastoreConnection.close();
            }
            this.getContentPane().removeAll();
        }
        if (exit) {
            this.getWindowContext().exit();
        }
        return windowClosing;
    }

    private void resetJob() {
        this.setDatastore(null);
        this.setJobFile(null);
    }

    @Override
    public void setJobFile(FileObject jobFile) {
        this._jobFilename = jobFile;
        this.updateWindowTitle();
    }

    @Override
    public FileObject getJobFile() {
        return this._jobFilename;
    }

    @Override
    public String getWindowTitle() {
        String datastoreName;
        String title = "Analysis job";
        if (this._datastore != null && !StringUtils.isNullOrEmpty((String)(datastoreName = this._datastore.getName()))) {
            title = datastoreName + " | " + title;
        }
        if (this._jobFilename != null) {
            title = this._jobFilename.getName().getBaseName() + " | " + title;
        }
        return title;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/filetypes/analysis_job.png", new ClassLoader[0]);
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getWindowContent() {
        if (this._datastore != null) {
            this.setDatastore(this._datastore);
        }
        this.setJMenuBar(this._windowMenuBar);
        this._sourceTabOuterPanel.add((Component)this._datastoreListPanelRef.get());
        this._sourceTabOuterPanel.add(this._sourceColumnsPanel);
        this._tabbedPane.addTab("Source", imageManager.getImageIcon("images/model/source.png", TAB_ICON_SIZE, new ClassLoader[0]), WidgetUtils.scrolleable(this._sourceTabOuterPanel));
        this._tabbedPane.setRightClickActionListener(0, new HideTabTextActionListener(this._tabbedPane, 0));
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.addTab("Metadata", imageManager.getImageIcon("images/model/metadata.png", TAB_ICON_SIZE, new ClassLoader[0]), this._metadataPanel);
        this._tabbedPane.setRightClickActionListener(1, new HideTabTextActionListener(this._tabbedPane, 1));
        this._tabbedPane.setUnclosableTab(1);
        this._tabbedPane.addSeparator();
        SaveAnalysisJobActionListener saveAnalysisJobActionListener = (SaveAnalysisJobActionListener)this._saveAnalysisJobActionListenerProvider.get();
        this._saveButton.addActionListener(saveAnalysisJobActionListener);
        this._saveAsButton.addActionListener(saveAnalysisJobActionListener);
        this._saveAsButton.setActionCommand("SAVE_AS");
        this._visualizeButton.setToolTipText("Visualize execution flow");
        this._visualizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizeJobWindow window = new VisualizeJobWindow(AnalysisJobBuilderWindowImpl.this._analysisJobBuilder, AnalysisJobBuilderWindowImpl.this.getWindowContext());
                window.setVisible(true);
            }
        });
        this._transformButton.addActionListener((ActionListener)this._addTransformerActionListenerProvider.get());
        this._analyzeButton.addActionListener((ActionListener)this._addAnalyzerActionListenerProvider.get());
        final RunAnalysisActionListener runAnalysisActionListener = (RunAnalysisActionListener)this._runAnalysisActionProvider.get();
        this._runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisJobBuilderWindowImpl.this.applyPropertyValues();
                runAnalysisActionListener.actionPerformed(e);
            }
        });
        this._saveButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._saveButton.setFocusPainted(false);
        this._saveAsButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._saveAsButton.setFocusPainted(false);
        this._visualizeButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._visualizeButton.setFocusPainted(false);
        this._analyzeButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._analyzeButton.setFocusPainted(false);
        this._runButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._runButton.setFocusPainted(false);
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(this._saveButton);
        toolBar.add(this._saveAsButton);
        toolBar.add(this._visualizeButton);
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(this._transformButton);
        toolBar.add(this._analyzeButton);
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(this._runButton);
        JXStatusBar statusBar = WidgetFactory.createStatusBar(this._statusLabel);
        LoginStatusLabel loggedInStatusLabel = (LoginStatusLabel)this._injectorWithGlassPane.getInstance(LoginStatusLabel.class);
        statusBar.add((Component)loggedInStatusLabel);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_LESS_DARK, WidgetUtils.BG_COLOR_DARK);
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "Center");
        DCPersistentSizedPanel panel = new DCPersistentSizedPanel(this._userPreferences, this.getClass().getName(), 900, 630);
        panel.setLayout(new BorderLayout());
        panel.add((Component)toolBarPanel, "North");
        panel.add((Component)this._leftPanel, "West");
        panel.add((Component)this._tabbedPane, "Center");
        panel.add((Component)statusBar, "South");
        WidgetUtils.centerOnScreen(this);
        this.initializeExistingComponents();
        return panel;
    }

    @Override
    public void applyPropertyValues() {
        for (FilterJobBuilderPresenter filterJobBuilderPresenter : this._filterPresenters.values()) {
            filterJobBuilderPresenter.applyPropertyValues();
        }
        for (TransformerJobBuilderPresenter transformerJobBuilderPresenter : this._transformerPresenters.values()) {
            transformerJobBuilderPresenter.applyPropertyValues();
        }
        for (AnalyzerJobBuilderPresenter analyzerJobBuilderPresenter : this._analyzerPresenters.values()) {
            analyzerJobBuilderPresenter.applyPropertyValues();
        }
    }

    private void initializeExistingComponents() {
        List filterJobBuilders = this._analysisJobBuilder.getFilterJobBuilders();
        for (FilterJobBuilder fjb : filterJobBuilders) {
            this.onAdd(fjb);
        }
        List transformerJobBuilders = this._analysisJobBuilder.getTransformerJobBuilders();
        for (TransformerJobBuilder tjb : transformerJobBuilders) {
            this.onAdd(tjb);
        }
        List mergedOutcomeJobBuilders = this._analysisJobBuilder.getMergedOutcomeJobBuilders();
        for (MergedOutcomeJobBuilder mojb : mergedOutcomeJobBuilders) {
            logger.warn("Job contains unsupported MergedOutcomeJobBuilders: {}", (Object)mojb);
        }
        List analyzerJobBuilders = this._analysisJobBuilder.getAnalyzerJobBuilders();
        for (AnalyzerJobBuilder ajb : analyzerJobBuilders) {
            this.onAdd(ajb);
        }
        this.onSourceColumnsChanged();
    }

    private void onSourceColumnsChanged() {
        boolean everythingEnabled = true;
        if (this._analysisJobBuilder.getSourceColumns().isEmpty()) {
            this._tabbedPane.setSelectedIndex(0);
            everythingEnabled = false;
        }
        int tabCount = this._tabbedPane.getTabCount();
        for (int i = 1; i < tabCount; ++i) {
            this._tabbedPane.setEnabledAt(i, everythingEnabled);
        }
        this._saveButton.setEnabled(everythingEnabled);
        this._saveAsButton.setEnabled(everythingEnabled);
        this._visualizeButton.setEnabled(everythingEnabled);
        this._transformButton.setEnabled(everythingEnabled);
        this._analyzeButton.setEnabled(everythingEnabled);
        this._windowMenuBar.getWriteDataMenu().setEnabled(everythingEnabled);
    }

    @Override
    public void setDatastoreSelectionEnabled(boolean datastoreSelectionEnabled) {
        this._datastoreSelectionEnabled = datastoreSelectionEnabled;
    }

    @Override
    public boolean isDatastoreSelectionEnabled() {
        return this._datastoreSelectionEnabled;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    public void tabClosed(TabCloseEvent ev) {
        Component panel = ev.getTabContents();
        if (panel != null) {
            for (AnalyzerJobBuilderPresenter analyzerPresenter : this._analyzerPresenters.values()) {
                if (this._jobBuilderTabs.get(analyzerPresenter) != panel) continue;
                this._analysisJobBuilder.removeAnalyzer(analyzerPresenter.getJobBuilder());
                return;
            }
            for (TransformerJobBuilderPresenter transformerPresenter : this._transformerPresenters.values()) {
                if (this._jobBuilderTabs.get(transformerPresenter) != panel) continue;
                this._analysisJobBuilder.removeTransformer(transformerPresenter.getJobBuilder());
                return;
            }
            for (FilterJobBuilderPresenter filterPresenter : this._filterPresenters.values()) {
                if (this._jobBuilderTabs.get(filterPresenter) != panel) continue;
                this._analysisJobBuilder.removeFilter(filterPresenter.getJobBuilder());
                return;
            }
        }
        logger.info("Could not handle removal of tab {}, containing {}", (Object)ev.getTabIndex(), (Object)panel);
    }

    public void onAdd(ExplorerJobBuilder<?> explorerJobBuilder) {
        this._tabbedPane.addTab(LabelUtils.getLabel(explorerJobBuilder), new JLabel("TODO: Exploring analyzer"));
        this._tabbedPane.setSelectedIndex(this._tabbedPane.getTabCount() - 1);
        this.updateStatusLabel();
    }

    public void onAdd(AnalyzerJobBuilder<?> analyzerJobBuilder) {
        Renderer renderer = this._componentJobBuilderPresenterRendererFactory.getRenderer(analyzerJobBuilder, ComponentJobBuilderRenderingFormat.class);
        AnalyzerJobBuilderPresenter presenter = (AnalyzerJobBuilderPresenter)renderer.render(analyzerJobBuilder);
        this._analyzerPresenters.put(analyzerJobBuilder, presenter);
        JComponent comp = presenter.createJComponent();
        this._tabbedPane.addTab(LabelUtils.getLabel(analyzerJobBuilder), IconUtils.getDescriptorIcon(analyzerJobBuilder.getDescriptor(), TAB_ICON_SIZE), comp);
        this._jobBuilderTabs.put(presenter, comp);
        final int tabIndex = this._tabbedPane.getTabCount() - 1;
        this._tabbedPane.setRightClickActionListener(tabIndex, new JobBuilderTabTextActionListener(this._analysisJobBuilder, (AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, tabIndex, this._tabbedPane));
        this._tabbedPane.setDoubleClickActionListener(tabIndex, new RenameComponentActionListener((AbstractBeanJobBuilder)analyzerJobBuilder, (AnalyzerJobBuilder)analyzerJobBuilder){
            final /* synthetic */ AnalyzerJobBuilder val$analyzerJobBuilder;
            {
                this.val$analyzerJobBuilder = analyzerJobBuilder;
                super(x0);
            }

            @Override
            protected void onNameChanged() {
                AnalysisJobBuilderWindowImpl.this._tabbedPane.setTitleAt(tabIndex, LabelUtils.getLabel((AbstractBeanJobBuilder)this.val$analyzerJobBuilder));
            }
        });
        this._tabbedPane.setSelectedIndex(tabIndex);
        this.updateStatusLabel();
    }

    public void onRemove(ExplorerJobBuilder<?> explorerJobBuilder) {
        this.updateStatusLabel();
    }

    public void onRemove(AnalyzerJobBuilder<?> analyzerJobBuilder) {
        AnalyzerJobBuilderPresenter presenter = this._analyzerPresenters.remove(analyzerJobBuilder);
        JComponent comp = this._jobBuilderTabs.remove(presenter);
        this._tabbedPane.remove(comp);
        this.updateStatusLabel();
    }

    public void onAdd(TransformerJobBuilder<?> transformerJobBuilder) {
        Renderer renderer = this._componentJobBuilderPresenterRendererFactory.getRenderer(transformerJobBuilder, ComponentJobBuilderRenderingFormat.class);
        TransformerJobBuilderPresenter presenter = (TransformerJobBuilderPresenter)renderer.render(transformerJobBuilder);
        this._transformerPresenters.put(transformerJobBuilder, presenter);
        JComponent comp = presenter.createJComponent();
        this._tabbedPane.addTab(LabelUtils.getLabel(transformerJobBuilder), IconUtils.getDescriptorIcon(transformerJobBuilder.getDescriptor(), TAB_ICON_SIZE), comp);
        this._jobBuilderTabs.put(presenter, comp);
        final int tabIndex = this._tabbedPane.getTabCount() - 1;
        this._tabbedPane.setSelectedIndex(tabIndex);
        this._tabbedPane.setRightClickActionListener(tabIndex, new JobBuilderTabTextActionListener(this._analysisJobBuilder, (AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, tabIndex, this._tabbedPane));
        this._tabbedPane.setDoubleClickActionListener(tabIndex, new RenameComponentActionListener((AbstractBeanJobBuilder)transformerJobBuilder, (TransformerJobBuilder)transformerJobBuilder){
            final /* synthetic */ TransformerJobBuilder val$transformerJobBuilder;
            {
                this.val$transformerJobBuilder = transformerJobBuilder;
                super(x0);
            }

            @Override
            protected void onNameChanged() {
                AnalysisJobBuilderWindowImpl.this._tabbedPane.setTitleAt(tabIndex, LabelUtils.getLabel((AbstractBeanJobBuilder)this.val$transformerJobBuilder));
            }
        });
        this.updateStatusLabel();
    }

    public void onRemove(TransformerJobBuilder<?> transformerJobBuilder) {
        TransformerJobBuilderPresenter presenter = this._transformerPresenters.remove(transformerJobBuilder);
        JComponent comp = this._jobBuilderTabs.remove(presenter);
        this._tabbedPane.remove(comp);
        this.updateStatusLabel();
    }

    public void onOutputChanged(TransformerJobBuilder<?> transformerJobBuilder, List<MutableInputColumn<?>> outputColumns) {
        TransformerJobBuilderPresenter presenter = this._transformerPresenters.get(transformerJobBuilder);
        if (presenter != null) {
            presenter.onOutputChanged(outputColumns);
        }
    }

    public void onAdd(FilterJobBuilder<?, ?> filterJobBuilder) {
        Renderer renderer = this._componentJobBuilderPresenterRendererFactory.getRenderer(filterJobBuilder, ComponentJobBuilderRenderingFormat.class);
        FilterJobBuilderPresenter presenter = (FilterJobBuilderPresenter)renderer.render(filterJobBuilder);
        this._filterPresenters.put(filterJobBuilder, presenter);
        JComponent comp = presenter.createJComponent();
        this._tabbedPane.addTab(LabelUtils.getLabel(filterJobBuilder), IconUtils.getDescriptorIcon(filterJobBuilder.getDescriptor(), TAB_ICON_SIZE), comp);
        this._jobBuilderTabs.put(presenter, comp);
        final int tabIndex = this._tabbedPane.getTabCount() - 1;
        if (MaxRowsFilterShortcutPanel.isFilter(filterJobBuilder)) {
            this._tabbedPane.setUnclosableTab(tabIndex);
        } else {
            this._tabbedPane.setSelectedIndex(tabIndex);
            this._tabbedPane.setRightClickActionListener(tabIndex, new JobBuilderTabTextActionListener(this._analysisJobBuilder, (AbstractBeanJobBuilder<?, ?, ?>)filterJobBuilder, tabIndex, this._tabbedPane));
            this._tabbedPane.setDoubleClickActionListener(tabIndex, new RenameComponentActionListener((AbstractBeanJobBuilder)filterJobBuilder, (FilterJobBuilder)filterJobBuilder){
                final /* synthetic */ FilterJobBuilder val$filterJobBuilder;
                {
                    this.val$filterJobBuilder = filterJobBuilder;
                    super(x0);
                }

                @Override
                protected void onNameChanged() {
                    AnalysisJobBuilderWindowImpl.this._tabbedPane.setTitleAt(tabIndex, LabelUtils.getLabel((AbstractBeanJobBuilder)this.val$filterJobBuilder));
                }
            });
        }
        this.updateStatusLabel();
    }

    public void onRemove(FilterJobBuilder<?, ?> filterJobBuilder) {
        FilterJobBuilderPresenter presenter = this._filterPresenters.remove(filterJobBuilder);
        JComponent comp = this._jobBuilderTabs.remove(presenter);
        this._tabbedPane.remove(comp);
        if (MaxRowsFilterShortcutPanel.isFilter(filterJobBuilder)) {
            this._sourceColumnsPanel.getMaxRowsFilterShortcutPanel().resetToDefault();
        }
        this.updateStatusLabel();
    }

    public void onConfigurationChanged(FilterJobBuilder<?, ?> filterJobBuilder) {
        FilterJobBuilderPresenter presenter = this._filterPresenters.get(filterJobBuilder);
        if (presenter != null) {
            presenter.onConfigurationChanged();
        }
        this.updateStatusLabel();
    }

    public void onRequirementChanged(FilterJobBuilder<?, ?> filterJobBuilder) {
    }

    public void onConfigurationChanged(TransformerJobBuilder<?> transformerJobBuilder) {
        TransformerJobBuilderPresenter presenter = this._transformerPresenters.get(transformerJobBuilder);
        if (presenter != null) {
            presenter.onConfigurationChanged();
        }
        this.updateStatusLabel();
    }

    public void onRequirementChanged(TransformerJobBuilder<?> transformerJobBuilder) {
        TransformerJobBuilderPresenter presenter = this._transformerPresenters.get(transformerJobBuilder);
        if (presenter != null) {
            presenter.onRequirementChanged();
        }
    }

    public void onConfigurationChanged(ExplorerJobBuilder<?> explorerJobBuilder) {
        this.updateStatusLabel();
    }

    public void onConfigurationChanged(AnalyzerJobBuilder<?> analyzerJobBuilder) {
        AnalyzerJobBuilderPresenter presenter = this._analyzerPresenters.get(analyzerJobBuilder);
        if (presenter != null) {
            presenter.onConfigurationChanged();
        }
        this.updateStatusLabel();
    }

    public void onRequirementChanged(AnalyzerJobBuilder<?> analyzerJobBuilder) {
        AnalyzerJobBuilderPresenter presenter = this._analyzerPresenters.get(analyzerJobBuilder);
        if (presenter != null) {
            presenter.onRequirementChanged();
        }
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        this.onSourceColumnsChanged();
        this.updateStatusLabel();
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        this.onSourceColumnsChanged();
        this.updateStatusLabel();
    }

    @Override
    public AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._analysisJobBuilder;
    }
}

