/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.connection.CompositeDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class CompositeDatastoreDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final MutableDatastoreCatalog _mutableDatastoreCatalog;
    private final List<JCheckBox> _checkBoxes;
    private final JXTextField _datastoreNameField;
    private final JLabel _statusLabel;
    private final DCPanel _outerPanel = new DCPanel();
    private final JButton _addDatastoreButton;
    private final CompositeDatastore _originalDatastore;

    @Override
    protected String getBannerTitle() {
        return "Composite datastore";
    }

    public CompositeDatastoreDialog(MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext) {
        this(null, mutableDatastoreCatalog, windowContext);
    }

    public CompositeDatastoreDialog(CompositeDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext) {
        super(windowContext, imageManager.getImage("images/window/banner-datastores.png", new ClassLoader[0]));
        this._mutableDatastoreCatalog = mutableDatastoreCatalog;
        this._originalDatastore = originalDatastore;
        this._statusLabel = DCLabel.bright("");
        this._datastoreNameField = WidgetFactory.createTextField("Datastore name");
        this._datastoreNameField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                CompositeDatastoreDialog.this.updateStatusLabel();
            }
        });
        this._addDatastoreButton = WidgetFactory.createButton("Save datastore", "images/datastore-types/composite.png");
        this._addDatastoreButton.setEnabled(false);
        String[] datastoreNames = this._mutableDatastoreCatalog.getDatastoreNames();
        this._checkBoxes = new ArrayList<JCheckBox>();
        for (int i = 0; i < datastoreNames.length; ++i) {
            String datastoreName = datastoreNames[i];
            if (this._originalDatastore != null && this._originalDatastore.getName().equals(datastoreName)) continue;
            JCheckBox checkBox = new JCheckBox(datastoreName);
            checkBox.setName(datastoreName);
            checkBox.setOpaque(false);
            checkBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompositeDatastoreDialog.this.updateStatusLabel();
                }
            });
            this._checkBoxes.add(checkBox);
        }
        if (this._originalDatastore != null) {
            this._datastoreNameField.setText(this._originalDatastore.getName());
            this._datastoreNameField.setEnabled(false);
            List containedDatastores = this._originalDatastore.getDatastores();
            HashSet<String> containedDatastoreNames = new HashSet<String>();
            for (Datastore datastore : containedDatastores) {
                containedDatastoreNames.add(datastore.getName());
            }
            for (JCheckBox checkBox : this._checkBoxes) {
                if (!containedDatastoreNames.contains(checkBox.getText())) continue;
                checkBox.setSelected(true);
            }
        }
        this.updateStatusLabel();
    }

    public void updateStatusLabel() {
        boolean nameFilledOut;
        int selected = 0;
        for (JCheckBox checkBox : this._checkBoxes) {
            if (!checkBox.isSelected()) continue;
            ++selected;
        }
        boolean bl = nameFilledOut = !StringUtils.isNullOrEmpty((String)this._datastoreNameField.getText());
        if (selected < 2) {
            this._statusLabel.setText("Please select at least 2 contained datastores");
            this._statusLabel.setIcon(imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDatastoreButton.setEnabled(false);
        } else if (nameFilledOut) {
            this._statusLabel.setText("Composite datastore ready");
            this._statusLabel.setIcon(imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDatastoreButton.setEnabled(true);
        } else {
            this._statusLabel.setText("Please fill out a datastore name");
            this._statusLabel.setIcon(imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._addDatastoreButton.setEnabled(false);
        }
    }

    @Override
    protected int getDialogWidth() {
        return 400;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        WidgetUtils.addToGridBag(DCLabel.bright("Datastore name:"), formPanel, 0, 0);
        WidgetUtils.addToGridBag((Component)this._datastoreNameField, formPanel, 1, 0);
        DCPanel checkBoxPanel = new DCPanel().setTitledBorder("Contained datastores");
        checkBoxPanel.setLayout((LayoutManager)new VerticalLayout(4));
        for (JCheckBox checkBox : this._checkBoxes) {
            checkBoxPanel.add(checkBox);
        }
        WidgetUtils.addToGridBag((Component)checkBoxPanel, (JPanel)formPanel, 0, 1, 2, 1);
        this._addDatastoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Datastore> datastores = new ArrayList<Datastore>();
                for (JCheckBox checkBox : CompositeDatastoreDialog.this._checkBoxes) {
                    if (!checkBox.isSelected()) continue;
                    String datastoreName = checkBox.getText();
                    Datastore datastore = CompositeDatastoreDialog.this._mutableDatastoreCatalog.getDatastore(datastoreName);
                    if (datastore == null) {
                        throw new IllegalStateException("No such datastore: " + datastoreName);
                    }
                    datastores.add(datastore);
                }
                CompositeDatastore datastore = new CompositeDatastore(CompositeDatastoreDialog.this._datastoreNameField.getText(), datastores);
                if (CompositeDatastoreDialog.this._originalDatastore != null) {
                    CompositeDatastoreDialog.this._mutableDatastoreCatalog.removeDatastore((Datastore)CompositeDatastoreDialog.this._originalDatastore);
                }
                CompositeDatastoreDialog.this._mutableDatastoreCatalog.addDatastore((Datastore)datastore);
                CompositeDatastoreDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.add(this._addDatastoreButton);
        DCPanel centerPanel = new DCPanel();
        centerPanel.setLayout((LayoutManager)new VerticalLayout(4));
        centerPanel.add(formPanel);
        centerPanel.add(buttonPanel);
        JXStatusBar statusBar = WidgetFactory.createStatusBar(this._statusLabel);
        this._outerPanel.setLayout(new BorderLayout());
        this._outerPanel.add((Component)centerPanel, "Center");
        this._outerPanel.add((Component)statusBar, "South");
        return this._outerPanel;
    }

    @Override
    public String getWindowTitle() {
        return "Composite datastore | Datastore";
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/datastore-types/composite.png", new ClassLoader[0]);
    }
}

