/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.Document;
import org.eobjects.analyzer.connection.CouchDbDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.UpdateableDatastoreConnection;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.SchemaFactory;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.TableDefinitionOptionSelectionPanel;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.util.SimpleTableDef;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class CouchDbDatastoreDialog
extends AbstractDialog
implements SchemaFactory {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final MutableDatastoreCatalog _catalog;
    private final CouchDbDatastore _originalDatastore;
    private final JXTextField _hostnameTextField;
    private final JXTextField _portTextField;
    private final JXTextField _usernameTextField;
    private final JPasswordField _passwordField;
    private final JXTextField _datastoreNameTextField;
    private final JCheckBox _sslCheckBox;
    private final TableDefinitionOptionSelectionPanel _tableDefinitionWidget;

    @Inject
    public CouchDbDatastoreDialog(WindowContext windowContext, MutableDatastoreCatalog catalog, @Nullable CouchDbDatastore datastore) {
        super(windowContext, imageManager.getImage("images/window/banner-datastores.png", new ClassLoader[0]));
        this._catalog = catalog;
        this._originalDatastore = datastore;
        this._datastoreNameTextField = WidgetFactory.createTextField();
        this._hostnameTextField = WidgetFactory.createTextField();
        this._portTextField = WidgetFactory.createTextField();
        this._portTextField.setDocument((Document)new NumberDocument(false));
        this._usernameTextField = WidgetFactory.createTextField();
        this._passwordField = WidgetFactory.createPasswordField();
        this._sslCheckBox = new JCheckBox("Connect via SSL", false);
        this._sslCheckBox.setOpaque(false);
        this._sslCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        if (this._originalDatastore == null) {
            this._hostnameTextField.setText("localhost");
            this._portTextField.setText("5984");
            this._tableDefinitionWidget = new TableDefinitionOptionSelectionPanel(windowContext, this, null);
        } else {
            this._datastoreNameTextField.setText(this._originalDatastore.getName());
            this._datastoreNameTextField.setEnabled(false);
            this._hostnameTextField.setText(this._originalDatastore.getHostname());
            this._portTextField.setText(this._originalDatastore.getPort() + "");
            this._sslCheckBox.setSelected(this._originalDatastore.isSslEnabled());
            this._usernameTextField.setText(this._originalDatastore.getUsername());
            this._passwordField.setText(new String(this._originalDatastore.getPassword()));
            this._tableDefinitionWidget = new TableDefinitionOptionSelectionPanel(windowContext, this, this._originalDatastore.getTableDefs());
        }
    }

    @Override
    public String getWindowTitle() {
        return "CouchDB database";
    }

    @Override
    protected String getBannerTitle() {
        return "CouchDB database";
    }

    @Override
    protected int getDialogWidth() {
        return 400;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        formPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Datastore name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._datastoreNameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Hostname:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._hostnameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Port:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._portTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(this._sslCheckBox, formPanel, 1, ++row);
        WidgetUtils.addToGridBag(DCLabel.bright("Username:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._usernameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Password:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._passwordField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Schema model:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._tableDefinitionWidget, formPanel, 1, row);
        ++row;
        JButton saveButton = WidgetFactory.createButton("Save datastore", "images/model/datastore.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CouchDbDatastore datastore = CouchDbDatastoreDialog.this.createDatastore();
                if (CouchDbDatastoreDialog.this._originalDatastore != null) {
                    CouchDbDatastoreDialog.this._catalog.removeDatastore((Datastore)CouchDbDatastoreDialog.this._originalDatastore);
                }
                CouchDbDatastoreDialog.this._catalog.addDatastore((Datastore)datastore);
                CouchDbDatastoreDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 0));
        buttonPanel.add(saveButton);
        DCPanel centerPanel = new DCPanel();
        centerPanel.setLayout((LayoutManager)new VerticalLayout(4));
        centerPanel.add(formPanel);
        centerPanel.add(buttonPanel);
        return centerPanel;
    }

    protected CouchDbDatastore createDatastore() {
        String name = this._datastoreNameTextField.getText();
        String hostname = this._hostnameTextField.getText();
        Integer port = Integer.parseInt(this._portTextField.getText());
        boolean sslEnabled = this._sslCheckBox.isSelected();
        String username = this._usernameTextField.getText();
        String password = new String(this._passwordField.getPassword());
        SimpleTableDef[] tableDefs = this._tableDefinitionWidget.getTableDefs();
        return new CouchDbDatastore(name, hostname, port, username, password, sslEnabled, tableDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema() {
        CouchDbDatastore datastore = this.createDatastore();
        UpdateableDatastoreConnection con = datastore.openConnection();
        try {
            Schema schema;
            Schema schema2 = schema = con.getDataContext().getDefaultSchema();
            return schema2;
        }
        finally {
            con.close();
        }
    }
}

