/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.eobjects.analyzer.connection.CsvDatastore;
import org.eobjects.analyzer.util.ImmutableEntry;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CharSetEncodingComboBox;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.widgets.HeaderLineComboBox;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;

public final class CsvDatastoreDialog
extends AbstractFileBasedDatastoreDialog<CsvDatastore> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR_TAB = "Tab (\\t)";
    private static final String SEPARATOR_COMMA = "Comma (,)";
    private static final String SEPARATOR_SEMICOLON = "Semicolon (;)";
    private static final String SEPARATOR_PIPE = "Pipe (|)";
    private static final String QUOTE_DOUBLE_QUOTE = "Double quote (\")";
    private static final String QUOTE_SINGLE_QUOTE = "Single quote (')";
    private static final String QUOTE_NONE = "(None)";
    private static final String ESCAPE_BACKSLASH = "Backslash (\\)";
    private static final String ESCAPE_NONE = "(None)";
    private final JComboBox _separatorCharField = new JComboBox<String>(new String[]{"Comma (,)", "Tab (\\t)", "Semicolon (;)", "Pipe (|)"});
    private final JComboBox _quoteCharField;
    private final JComboBox _escapeCharField;
    private final HeaderLineComboBox _headerLineComboBox;
    private final CharSetEncodingComboBox _encodingComboBox;
    private final JCheckBox _failOnInconsistenciesCheckBox;
    private volatile boolean showPreview = true;

    @Inject
    public CsvDatastoreDialog(@Nullable CsvDatastore datastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(datastore, mutableDatastoreCatalog, windowContext, userPreferences);
        this._separatorCharField.setEditable(true);
        this._quoteCharField = new JComboBox<String>(new String[]{"(None)", QUOTE_DOUBLE_QUOTE, QUOTE_SINGLE_QUOTE});
        this._quoteCharField.setEditable(true);
        this._escapeCharField = new JComboBox<String>(new String[]{"(None)", ESCAPE_BACKSLASH});
        this._escapeCharField.setSelectedItem(ESCAPE_BACKSLASH);
        this._escapeCharField.setEditable(true);
        this._encodingComboBox = new CharSetEncodingComboBox();
        this._headerLineComboBox = new HeaderLineComboBox();
        this._failOnInconsistenciesCheckBox = new JCheckBox("Fail on inconsistent column count", true);
        this._failOnInconsistenciesCheckBox.setOpaque(false);
        this._failOnInconsistenciesCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._addDatastoreButton.setEnabled(false);
        this.showPreview = true;
        if (this._originalDatastore != null) {
            this._failOnInconsistenciesCheckBox.setSelected(((CsvDatastore)this._originalDatastore).isFailOnInconsistencies());
            this._encodingComboBox.setSelectedItem(((CsvDatastore)this._originalDatastore).getEncoding());
            this._headerLineComboBox.setSelectedItem(((CsvDatastore)this._originalDatastore).getHeaderLineNumber());
            Character separatorChar = ((CsvDatastore)this._originalDatastore).getSeparatorChar();
            String separator = null;
            if (separatorChar != null) {
                separator = separatorChar.charValue() == ',' ? SEPARATOR_COMMA : (separatorChar.charValue() == ';' ? SEPARATOR_SEMICOLON : (separatorChar.charValue() == '|' ? SEPARATOR_PIPE : (separatorChar.charValue() == '\t' ? SEPARATOR_TAB : separatorChar.toString())));
            }
            this._separatorCharField.setSelectedItem(separator);
            Character quoteChar = ((CsvDatastore)this._originalDatastore).getQuoteChar();
            String quote = quoteChar == null ? "(None)" : (quoteChar.charValue() == '\uffff' ? "(None)" : (quoteChar.charValue() == '\"' ? QUOTE_DOUBLE_QUOTE : (quoteChar.charValue() == '\'' ? QUOTE_SINGLE_QUOTE : quoteChar.toString())));
            this._quoteCharField.setSelectedItem(quote);
            Character escapeChar = ((CsvDatastore)this._originalDatastore).getEscapeChar();
            String escape = escapeChar == null ? "(None)" : (escapeChar.charValue() == '\uffff' ? "(None)" : (escapeChar.charValue() == '\\' ? ESCAPE_BACKSLASH : escapeChar.toString()));
            this._escapeCharField.setSelectedItem(escape);
            this.onSettingsUpdated(false, false);
        }
        this._separatorCharField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvDatastoreDialog.this.onSettingsUpdated(false, false);
            }
        });
        this._quoteCharField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvDatastoreDialog.this.onSettingsUpdated(false, false);
            }
        });
        this._escapeCharField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvDatastoreDialog.this.onSettingsUpdated(false, false);
            }
        });
        this._encodingComboBox.addListener(new DCComboBox.Listener<String>(){

            @Override
            public void onItemSelected(String item) {
                CsvDatastoreDialog.this.onSettingsUpdated(true, false);
            }
        });
        this._headerLineComboBox.addListener(new DCComboBox.Listener<Integer>(){

            @Override
            public void onItemSelected(Integer item) {
                CsvDatastoreDialog.this.onSettingsUpdated(false, false);
            }
        });
    }

    @Override
    protected String getBannerTitle() {
        return "Comma-separated file";
    }

    @Override
    protected void onFileSelected(File file) {
        this.onSettingsUpdated(true, true);
    }

    private void onSettingsUpdated(boolean autoDetectSeparatorAndQuote, boolean autoDetectEncoding) {
        this.onSettingsUpdated(autoDetectSeparatorAndQuote, autoDetectEncoding, this.getSampleBuffer());
    }

    private void onSettingsUpdated(boolean autoDetectSeparatorAndQuote, boolean autoDetectEncoding, byte[] sampleBuffer) {
        if (!this.validateForm()) {
            return;
        }
        if (sampleBuffer == null || sampleBuffer.length == 0) {
            this.logger.debug("No bytes read to autodetect settings");
            return;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        this.showPreview = true;
        String charSet = autoDetectEncoding ? this._encodingComboBox.autoDetectEncoding(sampleBuffer) : ((String)this._encodingComboBox.getSelectedItem()).toString();
        char[] sampleChars = this.readSampleBuffer(sampleBuffer, charSet);
        if (StringUtils.indexOf((char)'\n', (char[])sampleChars) == -1 && StringUtils.indexOf((char)'\r', (char[])sampleChars) == -1) {
            warnings.add("No newline in first " + sampleChars.length + " chars");
            this.showPreview = false;
        }
        if (autoDetectSeparatorAndQuote) {
            int newlines = 0;
            int tabs = 0;
            int commas = 0;
            int semicolons = 0;
            int pipes = 0;
            int singleQuotes = 0;
            int doubleQuotes = 0;
            for (int i = 0; i < sampleChars.length; ++i) {
                char c = sampleChars[i];
                if (c == '\n') {
                    ++newlines;
                    continue;
                }
                if (c == '\t') {
                    ++tabs;
                    continue;
                }
                if (c == ',') {
                    ++commas;
                    continue;
                }
                if (c == ';') {
                    ++semicolons;
                    continue;
                }
                if (c == '\'') {
                    ++singleQuotes;
                    continue;
                }
                if (c == '|') {
                    ++pipes;
                    continue;
                }
                if (c != '\"') continue;
                ++doubleQuotes;
            }
            int detectedSeparator = Math.max(tabs, Math.max(commas, Math.max(semicolons, pipes)));
            if (detectedSeparator == 0 || detectedSeparator < newlines) {
                warnings.add("Could not autodetect separator char");
            } else if (detectedSeparator == commas) {
                this._separatorCharField.setSelectedItem(SEPARATOR_COMMA);
            } else if (detectedSeparator == semicolons) {
                this._separatorCharField.setSelectedItem(SEPARATOR_SEMICOLON);
            } else if (detectedSeparator == tabs) {
                this._separatorCharField.setSelectedItem(SEPARATOR_TAB);
            } else if (detectedSeparator == pipes) {
                this._separatorCharField.setSelectedItem(SEPARATOR_PIPE);
            }
            int detectedQuote = Math.max(singleQuotes, doubleQuotes);
            if (detectedQuote == 0 || detectedQuote < newlines) {
                this._quoteCharField.setSelectedItem("(None)");
            } else if (detectedQuote == singleQuotes) {
                this._quoteCharField.setSelectedItem(QUOTE_SINGLE_QUOTE);
            } else if (detectedQuote == doubleQuotes) {
                this._quoteCharField.setSelectedItem(QUOTE_DOUBLE_QUOTE);
            }
        }
        if (this.showPreview) {
            this.validateAndUpdate();
        }
        if (warnings.isEmpty()) {
            this.setStatusValid();
        } else {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning);
                sb.append(". ");
            }
            this.setStatusWarning(sb.toString());
        }
    }

    @Override
    protected boolean validateForm() {
        Object selectedEncoding = this._encodingComboBox.getSelectedItem();
        if (selectedEncoding == null || selectedEncoding.toString().length() == 0) {
            this.setStatusError("Please select a character encoding!");
            return false;
        }
        return super.validateForm();
    }

    @Override
    protected boolean isPreviewTableEnabled() {
        return true;
    }

    @Override
    protected boolean isPreviewDataAvailable() {
        return this.showPreview;
    }

    @Override
    protected List<Map.Entry<String, JComponent>> getFormElements() {
        List<Map.Entry<String, JComponent>> result = super.getFormElements();
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Character encoding", (Object)this._encodingComboBox));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Separator", (Object)this._separatorCharField));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Quote char", (Object)this._quoteCharField));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Escape char", (Object)this._escapeCharField));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Header line", (Object)this._headerLineComboBox));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"", (Object)this._failOnInconsistenciesCheckBox));
        return result;
    }

    public int getHeaderLine() {
        Number headerLineComboValue = (Number)this._headerLineComboBox.getSelectedItem();
        if (headerLineComboValue != null) {
            int intComboValue = headerLineComboValue.intValue();
            if (intComboValue < 0) {
                return 0;
            }
            return intComboValue;
        }
        return 1;
    }

    public String getEncoding() {
        String encoding = ((String)this._encodingComboBox.getSelectedItem()).toString();
        if (StringUtils.isNullOrEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public Character getSeparatorChar() {
        Object separatorItem = this._separatorCharField.getSelectedItem();
        if (SEPARATOR_COMMA.equals(separatorItem)) {
            return Character.valueOf(',');
        }
        if (SEPARATOR_SEMICOLON.equals(separatorItem)) {
            return Character.valueOf(';');
        }
        if (SEPARATOR_TAB.equals(separatorItem)) {
            return Character.valueOf('\t');
        }
        if (SEPARATOR_PIPE.equals(separatorItem)) {
            return Character.valueOf('|');
        }
        return Character.valueOf(separatorItem.toString().charAt(0));
    }

    public Character getQuoteChar() {
        Object quoteItem = this._quoteCharField.getSelectedItem();
        if ("(None)".equals(quoteItem)) {
            return Character.valueOf('\uffff');
        }
        if (QUOTE_DOUBLE_QUOTE.equals(quoteItem)) {
            return Character.valueOf('\"');
        }
        if (QUOTE_SINGLE_QUOTE.equals(quoteItem)) {
            return Character.valueOf('\'');
        }
        return Character.valueOf(quoteItem.toString().charAt(0));
    }

    public Character getEscapeChar() {
        Object escapeItem = this._escapeCharField.getSelectedItem();
        if ("(None)".equals(escapeItem)) {
            return Character.valueOf('\uffff');
        }
        if (ESCAPE_BACKSLASH.equals(escapeItem)) {
            return Character.valueOf('\\');
        }
        return Character.valueOf(escapeItem.toString().charAt(0));
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/datastore-types/csv.png", new ClassLoader[0]);
    }

    @Override
    public String getWindowTitle() {
        return "CSV file datastore";
    }

    @Override
    protected CsvDatastore getPreviewDatastore(String filename) {
        return this.createDatastore("Preview", filename, false);
    }

    @Override
    protected CsvDatastore createDatastore(String name, String filename) {
        boolean failOnInconsistentRecords = this._failOnInconsistenciesCheckBox.isSelected();
        return this.createDatastore(name, filename, failOnInconsistentRecords);
    }

    private CsvDatastore createDatastore(String name, String filename, boolean failOnInconsistentRecords) {
        return new CsvDatastore(name, filename, this.getQuoteChar(), this.getSeparatorChar(), this.getEscapeChar(), this.getEncoding(), failOnInconsistentRecords, this.getHeaderLine());
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/csv.png";
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        FileFilter combinedFilter = FileFilters.combined("Any raw data file (.csv, .tsv, .dat, .txt)", FileFilters.CSV, FileFilters.TSV, FileFilters.DAT, FileFilters.TXT);
        filenameField.addChoosableFileFilter(combinedFilter);
        filenameField.addChoosableFileFilter(FileFilters.CSV);
        filenameField.addChoosableFileFilter(FileFilters.TSV);
        filenameField.addChoosableFileFilter(FileFilters.DAT);
        filenameField.addChoosableFileFilter(FileFilters.TXT);
        filenameField.addChoosableFileFilter(FileFilters.ALL);
        filenameField.setSelectedFileFilter(combinedFilter);
        filenameField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                if (FileFilters.TSV.accept(file)) {
                    CsvDatastoreDialog.this._separatorCharField.setSelectedItem(CsvDatastoreDialog.SEPARATOR_TAB);
                }
            }
        });
        filenameField.getTextField().getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                CsvDatastoreDialog.this.onSettingsUpdated(true, true);
            }
        });
    }
}

