/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableModel;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.LoadingIcon;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.AbstractWindow;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetTableModel;
import org.eobjects.metamodel.query.Query;

public class DataSetWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private final Query _query;
    private final int _pageSize;
    private final String _title;
    private final Callable<TableModel> _tableModelCallable;
    private final DCTable _table;
    private final LoadingIcon _loadingIcon = new LoadingIcon();
    private JButton _previousPageButton;
    private JButton _nextPageButton;

    public DataSetWindow(Query query, DataContext dataContext, WindowContext windowContext) {
        this(query, dataContext, -1, windowContext);
    }

    public DataSetWindow(Query query, final DataContext dataContext, int pageSize, WindowContext windowContext) {
        super(windowContext);
        this._table = new DCTable();
        this._query = query;
        this._pageSize = pageSize;
        this._title = "DataSet: " + this._query.toSql();
        this._tableModelCallable = new Callable<TableModel>(){

            @Override
            public TableModel call() throws Exception {
                DataSet dataSet = dataContext.executeQuery(DataSetWindow.this._query);
                return new DataSetTableModel(dataSet);
            }
        };
        this._previousPageButton = WidgetFactory.createButton("Previous page", "images/actions/back.png");
        this._previousPageButton.setEnabled(false);
        this._nextPageButton = WidgetFactory.createButton("Next page", "images/actions/forward.png");
        this._nextPageButton.setEnabled(false);
    }

    public DataSetWindow(String title, Callable<TableModel> tableModelCallable, WindowContext windowContext) {
        super(windowContext);
        this._table = new DCTable();
        this._query = null;
        this._pageSize = -1;
        this._title = title;
        this._tableModelCallable = tableModelCallable;
        this._previousPageButton = null;
        this._nextPageButton = null;
    }

    @Override
    public String getWindowTitle() {
        return this._title;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public Image getWindowIcon() {
        return ImageManager.getInstance().getImage("images/actions/preview_data.png", new ClassLoader[0]);
    }

    @Override
    protected JComponent getWindowContent() {
        this.updateTable();
        DCPanel tablePanel = this._table.toPanel();
        DCPanel pagingButtonPanel = this.createPagingButtonPanel();
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        this._loadingIcon.setPreferredSize(300, 300);
        panel.add((Component)this._loadingIcon, "North");
        panel.add((Component)tablePanel, "Center");
        if (pagingButtonPanel != null) {
            panel.add((Component)pagingButtonPanel, "South");
        }
        return panel;
    }

    private void updateTable() {
        this._loadingIcon.setVisible(true);
        this._table.setVisible(false);
        if (this._query != null && this._pageSize > 0) {
            this._query.setMaxRows(Integer.valueOf(this._pageSize));
        }
        new SwingWorker<TableModel, Void>(){

            @Override
            protected TableModel doInBackground() throws Exception {
                return (TableModel)DataSetWindow.this._tableModelCallable.call();
            }

            @Override
            protected void done() {
                try {
                    TableModel tableModel = (TableModel)this.get();
                    DataSetWindow.this._table.setModel(tableModel);
                    if (DataSetWindow.this._table.getColumnCount() > 10) {
                        DataSetWindow.this._table.setHorizontalScrollEnabled(true);
                    }
                    DataSetWindow.this.updatePagingButtons();
                    DataSetWindow.this._loadingIcon.setVisible(false);
                    DataSetWindow.this._table.setVisible(true);
                    if (DataSetWindow.this.getExtendedState() != 6) {
                        Dimension dimensions = DataSetWindow.this.autoSetSize();
                        DataSetWindow.this.getContentPane().setSize(dimensions);
                        DataSetWindow.this.pack();
                        DataSetWindow.this.centerOnScreen();
                    }
                }
                catch (Exception e) {
                    DataSetWindow.this.dispose();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
        }.execute();
    }

    private DCPanel createPagingButtonPanel() {
        if (this._query == null) {
            return null;
        }
        final Integer maxRows = this._query.getMaxRows();
        if (maxRows == null) {
            return null;
        }
        this._previousPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newFirstRow = DataSetWindow.this.getFirstRow() - maxRows;
                if (newFirstRow <= 0) {
                    newFirstRow = 1;
                }
                DataSetWindow.this._query.setFirstRow(Integer.valueOf(newFirstRow));
                DataSetWindow.this.updateTable();
            }
        });
        this._nextPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newFirstRow = DataSetWindow.this.getFirstRow() + maxRows;
                DataSetWindow.this._query.setFirstRow(Integer.valueOf(newFirstRow));
                DataSetWindow.this.updateTable();
            }
        });
        DCPanel buttonPanel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        buttonPanel.setLayout(new FlowLayout(0, 4, 10));
        buttonPanel.setBorder(new MatteBorder(1, 0, 0, 0, WidgetUtils.BG_COLOR_MEDIUM));
        buttonPanel.add(this._previousPageButton);
        buttonPanel.add(this._nextPageButton);
        return buttonPanel;
    }

    private void updatePagingButtons() {
        if (this._nextPageButton != null) {
            if (this._table.getRowCount() < this._query.getMaxRows()) {
                this._nextPageButton.setEnabled(false);
            } else {
                this._nextPageButton.setEnabled(true);
            }
        }
        if (this._previousPageButton != null) {
            if (this.getFirstRow() <= 1) {
                this._previousPageButton.setEnabled(false);
            } else {
                this._previousPageButton.setEnabled(true);
            }
        }
    }

    private int getFirstRow() {
        return this._query.getFirstRow() == null ? 1 : this._query.getFirstRow();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (preferredSize.width < 300) {
            preferredSize.width = 300;
        }
        if (preferredSize.height < 200) {
            preferredSize.height = 200;
        }
        return preferredSize;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }
}

