/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.reference.DatastoreDictionary;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.CollectionUtils;
import org.jdesktop.swingx.JXTextField;

public final class DatastoreDictionaryDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final DatastoreDictionary _originalDictionary;
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private final DatastoreCatalog _datastoreCatalog;
    private final JXTextField _nameTextField;
    private final JXTextField _columnTextField;
    private final JComboBox _datastoreComboBox;
    private final DCPanel _treePanel;
    private final JSplitPane _splitPane;
    private final InjectorBuilder _injectorBuilder;
    private volatile boolean _nameAutomaticallySet = true;

    @Inject
    protected DatastoreDictionaryDialog(@Nullable DatastoreDictionary dictionary, MutableReferenceDataCatalog referenceDataCatalog, DatastoreCatalog datastoreCatalog, WindowContext windowContext, InjectorBuilder injectorBuilder) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-dictionaries.png", new ClassLoader[0]));
        this._originalDictionary = dictionary;
        this._referenceDataCatalog = referenceDataCatalog;
        this._datastoreCatalog = datastoreCatalog;
        this._injectorBuilder = injectorBuilder;
        this._nameTextField = WidgetFactory.createTextField("Dictionary name");
        this._nameTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                DatastoreDictionaryDialog.this._nameAutomaticallySet = false;
            }
        });
        this._columnTextField = WidgetFactory.createTextField("Column name");
        String[] comboBoxModel = (String[])CollectionUtils.array((Object[])new String[1], (Object[])this._datastoreCatalog.getDatastoreNames());
        this._datastoreComboBox = new JComboBox<String>(comboBoxModel);
        this._datastoreComboBox.setEditable(false);
        this._splitPane = new JSplitPane(1);
        this._splitPane.setBackground(WidgetUtils.BG_COLOR_DARK);
        this._splitPane.setBorder(null);
        this._splitPane.setDividerLocation(320);
        this._treePanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._treePanel.setLayout(new BorderLayout());
        this._datastoreComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Datastore datastore;
                String datastoreName = (String)DatastoreDictionaryDialog.this._datastoreComboBox.getSelectedItem();
                if (datastoreName != null && (datastore = DatastoreDictionaryDialog.this._datastoreCatalog.getDatastore(datastoreName)) != null) {
                    DatastoreDictionaryDialog.this._treePanel.removeAll();
                    Injector injectorWithDatastore = DatastoreDictionaryDialog.this._injectorBuilder.with(Datastore.class, (Object)datastore).with(AnalyzerJobBuilder.class, null).createInjector();
                    final SchemaTree schemaTree = (SchemaTree)injectorWithDatastore.getInstance(SchemaTree.class);
                    schemaTree.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            TreePath path = schemaTree.getSelectionPath();
                            if (path == null) {
                                return;
                            }
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                            if (node.getUserObject() instanceof Column) {
                                Column column = (Column)node.getUserObject();
                                if (DatastoreDictionaryDialog.this._nameAutomaticallySet || StringUtils.isNullOrEmpty((String)DatastoreDictionaryDialog.this._nameTextField.getText())) {
                                    DatastoreDictionaryDialog.this._nameTextField.setText(column.getName());
                                    DatastoreDictionaryDialog.this._nameAutomaticallySet = true;
                                }
                                DatastoreDictionaryDialog.this._columnTextField.setText(column.getQualifiedLabel());
                            }
                        }
                    });
                    DatastoreDictionaryDialog.this._treePanel.add((Component)WidgetUtils.scrolleable((JComponent)((Object)schemaTree)), "Center");
                    DatastoreDictionaryDialog.this._treePanel.updateUI();
                }
            }
        });
        if (dictionary != null) {
            this._nameTextField.setText(dictionary.getName());
            this._columnTextField.setText(dictionary.getQualifiedColumnName());
            this._datastoreComboBox.setSelectedItem(dictionary.getDatastoreName());
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Datastore dictionary";
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Dictionary name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Datastore:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._datastoreComboBox, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Lookup column:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._columnTextField, formPanel, 1, row);
        JButton createDictionaryButton = WidgetFactory.createButton("Save dictionary", "images/model/dictionary.png");
        createDictionaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = DatastoreDictionaryDialog.this._nameTextField.getText();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    JOptionPane.showMessageDialog(DatastoreDictionaryDialog.this, "Please fill out the name of the dictionary");
                    return;
                }
                String datastoreName = (String)DatastoreDictionaryDialog.this._datastoreComboBox.getSelectedItem();
                if (StringUtils.isNullOrEmpty((String)datastoreName)) {
                    JOptionPane.showMessageDialog(DatastoreDictionaryDialog.this, "Please select a datastore");
                    return;
                }
                String columnPath = DatastoreDictionaryDialog.this._columnTextField.getText();
                if (StringUtils.isNullOrEmpty((String)columnPath)) {
                    JOptionPane.showMessageDialog(DatastoreDictionaryDialog.this, "Please select a lookup column");
                    return;
                }
                DatastoreDictionary dictionary = new DatastoreDictionary(name, datastoreName, columnPath);
                if (DatastoreDictionaryDialog.this._originalDictionary != null) {
                    DatastoreDictionaryDialog.this._referenceDataCatalog.removeDictionary((Dictionary)DatastoreDictionaryDialog.this._originalDictionary);
                }
                DatastoreDictionaryDialog.this._referenceDataCatalog.addDictionary((Dictionary)dictionary);
                DatastoreDictionaryDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 4));
        buttonPanel.add(createDictionaryButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel("A datastore dictionary is a dictionary based on a column in one of your datastores. Please select a datastore in the form below and a tree of that datastore will appear. From here on you can select which column in the datastore to use for dictionary lookups.");
        this._splitPane.add(formPanel);
        this._splitPane.add(this._treePanel);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)descriptionLabel, "North");
        outerPanel.add((Component)this._splitPane, "Center");
        outerPanel.add((Component)buttonPanel, "South");
        outerPanel.setPreferredSize(this.getDialogWidth(), 400);
        return outerPanel;
    }

    @Override
    public String getWindowTitle() {
        return "Datastore dictionary";
    }
}

