/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.reference.DatastoreSynonymCatalog;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.SourceColumnComboBox;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.datacleaner.windows.MultiSourceColumnComboBoxPanel;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.CollectionUtils;
import org.jdesktop.swingx.JXTextField;

public final class DatastoreSynonymCatalogDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final DatastoreSynonymCatalog _originalsynonymCatalog;
    private final MutableReferenceDataCatalog _mutableReferenceCatalog;
    private final JComboBox _datastoreComboBox;
    private final SourceColumnComboBox _masterTermColumnComboBox;
    private final JXTextField _nameTextField;
    private final DatastoreCatalog _datastoreCatalog;
    private final MultiSourceColumnComboBoxPanel _synonymColumnsPanel;
    private final InjectorBuilder _injectorBuilder;
    private Datastore _datastore;
    private final DCPanel _treePanel;
    private volatile boolean _nameAutomaticallySet = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    protected DatastoreSynonymCatalogDialog(@Nullable DatastoreSynonymCatalog synonymCatalog, MutableReferenceDataCatalog mutableReferenceCatalog, DatastoreCatalog datastoreCatalog, WindowContext windowContext, InjectorBuilder injectorBuilder) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-synonym-catalog.png", new ClassLoader[0]));
        this._originalsynonymCatalog = synonymCatalog;
        this._datastoreCatalog = datastoreCatalog;
        this._mutableReferenceCatalog = mutableReferenceCatalog;
        this._injectorBuilder = injectorBuilder;
        this._nameTextField = WidgetFactory.createTextField("Synonym catalog name");
        String[] comboBoxModel = (String[])CollectionUtils.array((Object[])new String[1], (Object[])this._datastoreCatalog.getDatastoreNames());
        this._datastoreComboBox = new JComboBox<String>(comboBoxModel);
        this._masterTermColumnComboBox = new SourceColumnComboBox();
        this._synonymColumnsPanel = new MultiSourceColumnComboBoxPanel();
        this._datastoreComboBox.setEditable(false);
        this._treePanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._treePanel.setLayout(new BorderLayout());
        this._datastoreComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String datastoreName = (String)DatastoreSynonymCatalogDialog.this._datastoreComboBox.getSelectedItem();
                if (datastoreName != null) {
                    DatastoreSynonymCatalogDialog.this._datastore = DatastoreSynonymCatalogDialog.this._datastoreCatalog.getDatastore(datastoreName);
                    DatastoreSynonymCatalogDialog.this._masterTermColumnComboBox.setModel(DatastoreSynonymCatalogDialog.this._datastore);
                    DatastoreSynonymCatalogDialog.this._masterTermColumnComboBox.addListener(new DCComboBox.Listener<Column>(){

                        @Override
                        public void onItemSelected(Column column) {
                            Table table = column == null ? null : column.getTable();
                            DatastoreSynonymCatalogDialog.this._synonymColumnsPanel.updateSourceComboBoxes(DatastoreSynonymCatalogDialog.this._datastore, table);
                            DatastoreSynonymCatalogDialog.this._synonymColumnsPanel.updateUI();
                        }
                    });
                    DatastoreSynonymCatalogDialog.this._synonymColumnsPanel.setModel(DatastoreSynonymCatalogDialog.this._datastore);
                    if (DatastoreSynonymCatalogDialog.this._datastore != null) {
                        DatastoreSynonymCatalogDialog.this._treePanel.removeAll();
                        Injector injectorWithDatastore = DatastoreSynonymCatalogDialog.this._injectorBuilder.with(Datastore.class, (Object)DatastoreSynonymCatalogDialog.this._datastore).with(AnalysisJobBuilder.class, null).createInjector();
                        final SchemaTree schemaTree = (SchemaTree)injectorWithDatastore.getInstance(SchemaTree.class);
                        schemaTree.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                TreePath path = schemaTree.getSelectionPath();
                                if (path == null) {
                                    return;
                                }
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                                if (node.getUserObject() instanceof Column) {
                                    Column column = (Column)node.getUserObject();
                                    if (DatastoreSynonymCatalogDialog.this._nameAutomaticallySet || StringUtils.isNullOrEmpty((String)DatastoreSynonymCatalogDialog.this._nameTextField.getText())) {
                                        DatastoreSynonymCatalogDialog.this._nameTextField.setText(column.getName());
                                        DatastoreSynonymCatalogDialog.this._nameAutomaticallySet = true;
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
        if (synonymCatalog != null) {
            String datastoreName = synonymCatalog.getDatastoreName();
            this._nameTextField.setText(synonymCatalog.getName());
            this._datastoreComboBox.setSelectedItem(datastoreName);
            Datastore datastore = this._datastoreCatalog.getDatastore(datastoreName);
            if (datastore != null) {
                DatastoreConnection dataContextProvider = datastore.openConnection();
                try {
                    SchemaNavigator sn = dataContextProvider.getSchemaNavigator();
                    Column masterTermColumn = sn.convertToColumn(synonymCatalog.getMasterTermColumnPath());
                    this._masterTermColumnComboBox.setSelectedItem(masterTermColumn);
                    String[] synonymColumnPaths = synonymCatalog.getSynonymColumnPaths();
                    Column[] synonymColumns = sn.convertToColumns(synonymColumnPaths);
                    this._synonymColumnsPanel.setColumns(Arrays.asList(synonymColumns));
                }
                finally {
                    dataContextProvider.close();
                }
            }
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Datastore\nsynonym catalog";
    }

    @Override
    protected int getDialogWidth() {
        return 465;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Synonym catalog name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Datastore:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._datastoreComboBox, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Master term column:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._masterTermColumnComboBox, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Synonym columns:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._synonymColumnsPanel.createPanel(), formPanel, 1, row);
        ++row;
        JButton saveButton = WidgetFactory.createButton("Save Synonym Catalog", "images/model/synonym.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = DatastoreSynonymCatalogDialog.this._nameTextField.getText();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    JOptionPane.showMessageDialog(DatastoreSynonymCatalogDialog.this, "Please fill out the name of the synonym catalog");
                    return;
                }
                String nameOfDatastore = (String)DatastoreSynonymCatalogDialog.this._datastoreComboBox.getSelectedItem();
                if (StringUtils.isNullOrEmpty((String)nameOfDatastore)) {
                    JOptionPane.showMessageDialog(DatastoreSynonymCatalogDialog.this, "Please select a character encoding");
                    return;
                }
                Column selectedItem = DatastoreSynonymCatalogDialog.this._masterTermColumnComboBox.getSelectedItem();
                String[] synonymColumnNames = DatastoreSynonymCatalogDialog.this._synonymColumnsPanel.getColumnNames();
                DatastoreSynonymCatalog dataStoreBasedSynonymCatalog = new DatastoreSynonymCatalog(name, nameOfDatastore, selectedItem.getQualifiedLabel(), synonymColumnNames);
                if (DatastoreSynonymCatalogDialog.this._originalsynonymCatalog != null) {
                    DatastoreSynonymCatalogDialog.this._mutableReferenceCatalog.removeSynonymCatalog((SynonymCatalog)DatastoreSynonymCatalogDialog.this._originalsynonymCatalog);
                }
                DatastoreSynonymCatalogDialog.this._mutableReferenceCatalog.addSynonymCatalog((SynonymCatalog)dataStoreBasedSynonymCatalog);
                DatastoreSynonymCatalogDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 4));
        buttonPanel.add(saveButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel("A datastore synonym catalog is based on a datastore and columns within it. The layout of the datastore is flexible: There should be a master term column and either a single or multiple synonym columns.");
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)descriptionLabel, "North");
        mainPanel.add((Component)formPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.setPreferredSize(this.getDialogWidth(), 230);
        return mainPanel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Datastore synonym catalog";
    }
}

