/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.renderer.Renderable;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCTaskPaneContainer;
import org.eobjects.datacleaner.windows.AbstractWindow;
import org.jdesktop.swingx.JXTaskPane;

public final class DetailsResultWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final RendererFactory _rendererFactory;
    private final List<AnalyzerResult> _results;
    private final String _title;
    private final DCTaskPaneContainer _taskPaneContainer;

    public DetailsResultWindow(String title, List<AnalyzerResult> results, WindowContext windowContext, RendererFactory rendererFactory) {
        super(windowContext);
        this._title = title;
        this._results = results;
        this._taskPaneContainer = WidgetFactory.createTaskPaneContainer();
        this._taskPaneContainer.setBackground(WidgetUtils.BG_COLOR_BRIGHT);
        this._rendererFactory = rendererFactory;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return this._title;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/model/result.png", new ClassLoader[0]);
    }

    @Override
    protected JComponent getWindowContent() {
        if (!this._results.isEmpty()) {
            for (AnalyzerResult analyzerResult : this._results) {
                Renderer renderer = this._rendererFactory.getRenderer((Renderable)analyzerResult, SwingRenderingFormat.class);
                JComponent component = renderer == null ? new JTextArea(analyzerResult.toString()) : (JComponent)renderer.render((Renderable)analyzerResult);
                this.addRenderedResult(component);
            }
        }
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_LESS_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)WidgetUtils.scrolleable((JComponent)((Object)this._taskPaneContainer)), "Center");
        Dimension preferredSize = panel.getPreferredSize();
        int height = preferredSize.height < 400 ? preferredSize.height + 100 : preferredSize.height;
        int width = preferredSize.width < 500 ? 500 : preferredSize.width;
        panel.setPreferredSize(width, height);
        return panel;
    }

    public void addRenderedResult(JComponent component) {
        ImageIcon icon = imageManager.getImageIcon("images/actions/drill-to-detail.png", new ClassLoader[0]);
        JXTaskPane taskPane = WidgetFactory.createTaskPane("Detailed results", icon);
        DCPanel taskPanePanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        taskPanePanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        taskPanePanel.setLayout(new BorderLayout());
        taskPanePanel.add(component);
        taskPane.add((Component)taskPanePanel);
        this._taskPaneContainer.add(taskPane);
    }
}

