/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import javax.inject.Inject;
import javax.swing.filechooser.FileFilter;
import org.eobjects.analyzer.connection.ExcelDatastore;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;

public final class ExcelDatastoreDialog
extends AbstractFileBasedDatastoreDialog<ExcelDatastore> {
    private static final long serialVersionUID = 1L;

    @Inject
    protected ExcelDatastoreDialog(@Nullable ExcelDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        FileFilter combinedFilter = FileFilters.combined("Any Excel Spreadsheet (.xls, .xlsx)", FileFilters.XLS, FileFilters.XLSX);
        filenameField.addChoosableFileFilter(combinedFilter);
        filenameField.addChoosableFileFilter(FileFilters.XLS);
        filenameField.addChoosableFileFilter(FileFilters.XLSX);
        filenameField.addChoosableFileFilter(FileFilters.ALL);
        filenameField.setSelectedFileFilter(combinedFilter);
    }

    @Override
    protected String getBannerTitle() {
        return "MS Excel spreadsheet";
    }

    @Override
    public String getWindowTitle() {
        return "Excel spreadsheet | Datastore";
    }

    @Override
    protected ExcelDatastore createDatastore(String name, String filename) {
        return new ExcelDatastore(name, filename);
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/excel.png";
    }
}

