/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCProgressBar;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.util.Action;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferProgressWindow
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FileTransferProgressWindow.class);
    private final Action<Void> _cancelCallback;
    private final JLabel[] _currentBytesLabels;
    private final JLabel[] _expectedBytesLabels;
    private final DCProgressBar[] _progressBars;
    private final JLabel[] _infoLabels;
    private final String[] _filenames;

    public FileTransferProgressWindow(WindowContext windowContext, Action<Void> cancelCallback, String[] filenames) {
        super(windowContext);
        this.setTopBackgroundColor(WidgetUtils.BG_COLOR_DARK);
        this.setBottomBackgroundColor(WidgetUtils.BG_COLOR_LESS_DARK);
        this._filenames = filenames;
        this._progressBars = new DCProgressBar[this._filenames.length];
        this._infoLabels = new JLabel[this._filenames.length];
        this._currentBytesLabels = new JLabel[this._filenames.length];
        this._expectedBytesLabels = new JLabel[this._filenames.length];
        this._cancelCallback = cancelCallback;
        for (int i = 0; i < this._filenames.length; ++i) {
            String filename = this._filenames[i];
            this._currentBytesLabels[i] = new JLabel("0");
            this._currentBytesLabels[i].setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
            this._expectedBytesLabels[i] = new JLabel("??? bytes");
            this._expectedBytesLabels[i].setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
            this._progressBars[i] = new DCProgressBar(0, 100);
            this._infoLabels[i] = new JLabel("Transfering file '" + filename + "'", 0);
            this._infoLabels[i].setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        }
    }

    @Override
    protected boolean onWindowClosing() {
        boolean close = super.onWindowClosing();
        if (close && this._cancelCallback != null) {
            try {
                this._cancelCallback.run(null);
            }
            catch (Exception e) {
                logger.error("Cancelling file transfer threw exception", (Throwable)e);
            }
        }
        return close;
    }

    @Override
    protected String getBannerTitle() {
        return "Transfering...";
    }

    @Override
    protected int getDialogWidth() {
        return 460;
    }

    private int getIndex(String filename) {
        return ArrayUtils.indexOf((Object[])this._filenames, (Object)filename);
    }

    public void setProgress(String filename, Long bytes) {
        int index = this.getIndex(filename);
        DecimalFormat formatter = new DecimalFormat("###,###");
        this._currentBytesLabels[index].setText(formatter.format(bytes));
        DCProgressBar progressBar = this._progressBars[index];
        progressBar.setValueIfHigherAndSignificant((int)(bytes / 100L));
    }

    public void setExpectedSize(String filename, Long bytes) {
        int index = this.getIndex(filename);
        DecimalFormat formatter = new DecimalFormat("###,###");
        this._expectedBytesLabels[index].setText(formatter.format(bytes) + " bytes");
        this._progressBars[index].setMaximum((int)(bytes / 100L));
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel centerPanel = new DCPanel();
        centerPanel.setLayout((LayoutManager)new VerticalLayout(4));
        for (int i = 0; i < this._filenames.length; ++i) {
            JLabel ofLabel = new JLabel(" of ");
            ofLabel.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
            DCPanel textPanel = new DCPanel();
            textPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            textPanel.setLayout(new FlowLayout(1, 0, 0));
            textPanel.add(this._currentBytesLabels[i]);
            textPanel.add(ofLabel);
            textPanel.add(this._expectedBytesLabels[i]);
            centerPanel.add(this._infoLabels[i]);
            centerPanel.add(this._progressBars[i]);
            centerPanel.add(textPanel);
        }
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)centerPanel, "Center");
        return mainPanel;
    }

    @Override
    public String getWindowTitle() {
        return "Transfering...";
    }

    public void setFinished(String filename) {
        int index = this.getIndex(filename);
        String doneText = "Done!";
        this._infoLabels[index].setText("Done!");
        for (int i = 0; i < this._infoLabels.length; ++i) {
            if ("Done!".equals(this._infoLabels[i].getText())) continue;
            return;
        }
        final Timer timer = new Timer(1500, null);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferProgressWindow.this.dispose();
                timer.stop();
            }
        };
        timer.addActionListener(listener);
        timer.start();
    }
}

