/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eobjects.analyzer.connection.FixedWidthDatastore;
import org.eobjects.analyzer.util.ImmutableEntry;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CharSetEncodingComboBox;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.widgets.HeaderLineComboBox;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;
import org.jdesktop.swingx.JXTextField;

public final class FixedWidthDatastoreDialog
extends AbstractFileBasedDatastoreDialog<FixedWidthDatastore> {
    private static final long serialVersionUID = 1L;
    private final CharSetEncodingComboBox _encodingComboBox;
    private final JCheckBox _failOnInconsistenciesCheckBox;
    private final List<JXTextField> _valueWidthTextFields;
    private final DCPanel _valueWidthsPanel;
    private final DCLabel _lineWidthLabel;
    private final HeaderLineComboBox _headerLineComboBox;
    private final JButton _addValueWidthButton;
    private final JButton _removeValueWidthButton;
    private final DocumentListener _updatePreviewTableDocumentListener = new DCDocumentListener(){

        @Override
        protected void onChange(DocumentEvent event) {
            FixedWidthDatastoreDialog.this.onSettingsUpdated(false);
        }
    };
    private volatile boolean showPreview = true;

    @Inject
    protected FixedWidthDatastoreDialog(@Nullable FixedWidthDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
        this._lineWidthLabel = DCLabel.bright("");
        this._valueWidthsPanel = new DCPanel();
        this._valueWidthsPanel.setLayout(new FlowLayout(0, 2, 0));
        this._valueWidthTextFields = new ArrayList<JXTextField>();
        this._encodingComboBox = new CharSetEncodingComboBox();
        this._addValueWidthButton = WidgetFactory.createSmallButton("images/actions/add.png");
        this._removeValueWidthButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        this._headerLineComboBox = new HeaderLineComboBox();
        this._failOnInconsistenciesCheckBox = new JCheckBox("Fail on inconsistent line length", true);
        this._failOnInconsistenciesCheckBox.setOpaque(false);
        this._failOnInconsistenciesCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        if (originalDatastore != null) {
            int[] valueWidths;
            this._encodingComboBox.setSelectedItem(originalDatastore.getEncoding());
            this._failOnInconsistenciesCheckBox.setSelected(originalDatastore.isFailOnInconsistencies());
            for (int valueWidth : valueWidths = originalDatastore.getValueWidths()) {
                this.addValueWidthTextField(valueWidth);
            }
            this._headerLineComboBox.setSelectedIndex(originalDatastore.getHeaderLineNumber());
            this.onSettingsUpdated(false);
        } else {
            this.addValueWidthTextField();
            this.addValueWidthTextField();
            this.addValueWidthTextField();
        }
        this._addValueWidthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FixedWidthDatastoreDialog.this.addValueWidthTextField();
            }
        });
        this._removeValueWidthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FixedWidthDatastoreDialog.this.removeValueWidthTextField();
            }
        });
        this._encodingComboBox.addListener(new DCComboBox.Listener<String>(){

            @Override
            public void onItemSelected(String item) {
                FixedWidthDatastoreDialog.this.onSettingsUpdated(false);
            }
        });
        this._headerLineComboBox.addListener(new DCComboBox.Listener<Integer>(){

            @Override
            public void onItemSelected(Integer item) {
                FixedWidthDatastoreDialog.this.onSettingsUpdated(false);
            }
        });
    }

    @Override
    protected boolean validateForm() {
        Object selectedEncoding = this._encodingComboBox.getSelectedItem();
        if (selectedEncoding == null || selectedEncoding.toString().length() == 0) {
            this.setStatusError("Please select a character encoding!");
            return false;
        }
        return super.validateForm();
    }

    @Override
    protected void onFileSelected(File file) {
        this.onSettingsUpdated(true);
    }

    private void onSettingsUpdated(boolean autoDetectEncoding) {
        if (!this.validateForm()) {
            return;
        }
        byte[] sampleBuffer = this.getSampleBuffer();
        if (sampleBuffer == null || sampleBuffer.length == 0) {
            this.logger.debug("No bytes read to autodetect settings");
            return;
        }
        String charSet = autoDetectEncoding ? this._encodingComboBox.autoDetectEncoding(sampleBuffer) : ((String)this._encodingComboBox.getSelectedItem()).toString();
        char[] sampleChars = this.readSampleBuffer(sampleBuffer, charSet);
        int lineLength = StringUtils.indexOf((char)'\n', (char[])sampleChars);
        if (lineLength == -1) {
            this.setStatusWarning("No newline in first " + sampleChars.length + " chars");
            this.showPreview = false;
        } else {
            int[] valueWidths = this.getValueWidths(false);
            int totalMappedWidth = 0;
            for (int valueWidth : valueWidths) {
                totalMappedWidth += valueWidth;
            }
            this._lineWidthLabel.setText(lineLength + " chars in first line. " + totalMappedWidth + " mapped.");
            this._lineWidthLabel.updateUI();
            this.showPreview = true;
            this.validateAndUpdate();
        }
    }

    @Override
    protected FixedWidthDatastore getPreviewDatastore(String filename) {
        return this.createDatastore("Preview", filename, false);
    }

    @Override
    protected boolean isPreviewDataAvailable() {
        return this.showPreview;
    }

    @Override
    protected boolean isPreviewTableEnabled() {
        return true;
    }

    private JXTextField addValueWidthTextField() {
        return this.addValueWidthTextField(8);
    }

    private JXTextField addValueWidthTextField(int valueWidth) {
        JXTextField textField = WidgetFactory.createTextField();
        textField.setColumns(2);
        NumberDocument document = new NumberDocument();
        document.addDocumentListener(this._updatePreviewTableDocumentListener);
        textField.setDocument((Document)document);
        textField.setText(valueWidth + "");
        this._valueWidthTextFields.add(textField);
        this._valueWidthsPanel.add((Component)textField);
        if (this._valueWidthTextFields.size() > 1) {
            this._removeValueWidthButton.setEnabled(true);
        }
        this._valueWidthsPanel.updateUI();
        this.onSettingsUpdated(false);
        return textField;
    }

    private JXTextField removeValueWidthTextField() {
        if (this._valueWidthTextFields.isEmpty()) {
            return null;
        }
        JXTextField textField = this._valueWidthTextFields.get(this._valueWidthTextFields.size() - 1);
        this._valueWidthTextFields.remove(textField);
        this._valueWidthsPanel.remove((Component)textField);
        if (this._valueWidthTextFields.size() == 1) {
            this._removeValueWidthButton.setEnabled(false);
        } else {
            this._removeValueWidthButton.setEnabled(true);
        }
        this._valueWidthsPanel.updateUI();
        this.onSettingsUpdated(false);
        return textField;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected List<Map.Entry<String, JComponent>> getFormElements() {
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(0, 2, 0));
        buttonPanel.add(this._addValueWidthButton);
        buttonPanel.add(this._removeValueWidthButton);
        DCPanel valueWidthConfigurationPanel = new DCPanel();
        valueWidthConfigurationPanel.setLayout(new BorderLayout());
        valueWidthConfigurationPanel.add((Component)this._valueWidthsPanel, "Center");
        valueWidthConfigurationPanel.add((Component)buttonPanel, "East");
        valueWidthConfigurationPanel.add((Component)this._lineWidthLabel, "South");
        List<Map.Entry<String, JComponent>> result = super.getFormElements();
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Character encoding", (Object)this._encodingComboBox));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Column widths", (Object)valueWidthConfigurationPanel));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Header line", (Object)this._headerLineComboBox));
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"", (Object)this._failOnInconsistenciesCheckBox));
        return result;
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        FileFilter combinedFilter = FileFilters.combined("Any text or data file (.txt, .dat)", FileFilters.TXT, FileFilters.DAT);
        filenameField.addChoosableFileFilter(combinedFilter);
        filenameField.addChoosableFileFilter(FileFilters.TXT);
        filenameField.addChoosableFileFilter(FileFilters.DAT);
        filenameField.setSelectedFileFilter(combinedFilter);
    }

    @Override
    protected String getBannerTitle() {
        return "Fixed width file";
    }

    @Override
    public String getWindowTitle() {
        return "Fixed width file | Datastore";
    }

    @Override
    protected FixedWidthDatastore createDatastore(String name, String filename) {
        boolean failOnInconsistencies = this._failOnInconsistenciesCheckBox.isSelected();
        return this.createDatastore(name, filename, failOnInconsistencies);
    }

    private FixedWidthDatastore createDatastore(String name, String filename, boolean failOnInconsistencies) {
        int[] valueWidths = this.getValueWidths(true);
        try {
            return new FixedWidthDatastore(name, filename, ((String)this._encodingComboBox.getSelectedItem()).toString(), valueWidths, failOnInconsistencies, this.getHeaderLine());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Value width must be a valid number.");
        }
    }

    private int[] getValueWidths(boolean failOnMissingValue) {
        int[] valueWidths = new int[this._valueWidthTextFields.size()];
        for (int i = 0; i < valueWidths.length; ++i) {
            String text = this._valueWidthTextFields.get(i).getText();
            if (StringUtils.isNullOrEmpty((String)text)) {
                if (failOnMissingValue) {
                    throw new IllegalStateException("Please fill out all column widths");
                }
                text = "0";
            }
            valueWidths[i] = Integer.parseInt(text);
        }
        return valueWidths;
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/fixedwidth.png";
    }

    public int getHeaderLine() {
        Number headerLineComboValue = (Number)this._headerLineComboBox.getSelectedItem();
        if (headerLineComboValue != null) {
            int intComboValue = headerLineComboValue.intValue();
            if (intComboValue < 0) {
                return 0;
            }
            return intComboValue;
        }
        return 1;
    }
}

