/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCListCellRenderer;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.HumanInferenceToolbarButton;
import org.eobjects.datacleaner.widgets.database.CubridDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.DatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.DefaultDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.H2DatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.MysqlDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.OracleDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.PostgresqlDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.SQLServerDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.database.UrlTemplateDatabaseConnectionPresenter;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.datacleaner.windows.OptionsDialog;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.JXTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatastoreDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JdbcDatastoreDialog.class);
    public static final int TEXT_FIELD_WIDTH = 30;
    private static final int TEST_CONNECTION_COUNT = 20;
    private static final String MANAGE_DATABASE_DRIVERS = "Manage database drivers...";
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final JdbcDatastore _originalDatastore;
    private final DatabaseDriverCatalog _databaseDriverCatalog;
    private final MutableDatastoreCatalog _catalog;
    private final JXTextField _datastoreNameTextField;
    private final JXTextField _driverClassNameTextField;
    private final DCCheckBox<Object> _multipleConnectionsCheckBox;
    private final DCComboBox<Object> _databaseDriverComboBox;
    private final Provider<OptionsDialog> _optionsDialogProvider;
    private final CloseableTabbedPane _tabbedPane;
    private final DatabaseConnectionPresenter[] _connectionPresenters;

    @Inject
    protected JdbcDatastoreDialog(@Nullable JdbcDatastore datastore, MutableDatastoreCatalog catalog, WindowContext windowContext, Provider<OptionsDialog> optionsDialogProvider, DatabaseDriverCatalog databaseDriverCatalog) {
        super(windowContext, imageManager.getImage("images/window/banner-datastores.png", new ClassLoader[0]));
        this._originalDatastore = datastore;
        this._catalog = catalog;
        this._optionsDialogProvider = optionsDialogProvider;
        this._databaseDriverCatalog = databaseDriverCatalog;
        this._connectionPresenters = new DatabaseConnectionPresenter[2];
        this._connectionPresenters[0] = new DefaultDatabaseConnectionPresenter();
        this._tabbedPane = new CloseableTabbedPane(true);
        this._tabbedPane.addTab("Generic connection parameters", imageManager.getImageIcon("images/model/datastore.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]), this._connectionPresenters[0].getWidget());
        this._tabbedPane.setUnclosableTab(0);
        this._multipleConnectionsCheckBox = new DCCheckBox("Allow multiple concurrent connections", true);
        this._multipleConnectionsCheckBox.setToolTipText("Indicates whether multiple connections (aka. connection pooling) may be created or not. Connection pooling is preferred for performance reasons, but can safely be disabled if not desired. The max number of connections cannot be configured, but no more connections than the number of threads in the task runner should be expected.");
        this._multipleConnectionsCheckBox.setOpaque(false);
        this._multipleConnectionsCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._datastoreNameTextField = WidgetFactory.createTextField("Name", 30);
        this._driverClassNameTextField = WidgetFactory.createTextField("Driver class name", 30);
        List<DatabaseDriverDescriptor> databaseDrivers = this._databaseDriverCatalog.getInstalledWorkingDatabaseDrivers();
        Object[] comboBoxModel = new Object[databaseDrivers.size() + 3];
        comboBoxModel[0] = "";
        for (int i = 0; i < databaseDrivers.size(); ++i) {
            comboBoxModel[i + 1] = databaseDrivers.get(i);
        }
        comboBoxModel[comboBoxModel.length - 2] = new JSeparator(0);
        comboBoxModel[comboBoxModel.length - 1] = MANAGE_DATABASE_DRIVERS;
        this._databaseDriverComboBox = new DCComboBox<Object>(comboBoxModel);
        this._databaseDriverComboBox.setRenderer(new DCListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if ("".equals(value)) {
                    value = "- select -";
                }
                JLabel result = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DatabaseDriverDescriptor) {
                    DatabaseDriverDescriptor databaseDriver = (DatabaseDriverDescriptor)value;
                    String iconImagePath = DatabaseDriverCatalog.getIconImagePath(databaseDriver);
                    ImageIcon driverIcon = imageManager.getImageIcon(iconImagePath, IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                    result.setText(databaseDriver.getDisplayName());
                    result.setIcon(driverIcon);
                } else if (JdbcDatastoreDialog.MANAGE_DATABASE_DRIVERS.equals(value)) {
                    result.setIcon(imageManager.getImageIcon("images/menu/options.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
                } else if (value instanceof Component) {
                    return (Component)value;
                }
                return result;
            }
        });
        this._databaseDriverComboBox.addListener(new DCComboBox.Listener<Object>(){

            @Override
            public void onItemSelected(Object value) {
                if ("".equals(value)) {
                    JdbcDatastoreDialog.this.setSelectedDatabase((DatabaseDriverDescriptor)null);
                    JdbcDatastoreDialog.this._driverClassNameTextField.setText("");
                    JdbcDatastoreDialog.this._driverClassNameTextField.setEnabled(true);
                } else if (value instanceof DatabaseDriverDescriptor) {
                    DatabaseDriverDescriptor driver = (DatabaseDriverDescriptor)value;
                    JdbcDatastoreDialog.this.setSelectedDatabase(driver);
                    JdbcDatastoreDialog.this._driverClassNameTextField.setText(driver.getDriverClassName());
                    JdbcDatastoreDialog.this._driverClassNameTextField.setEnabled(false);
                } else if (JdbcDatastoreDialog.MANAGE_DATABASE_DRIVERS.equals(value)) {
                    OptionsDialog optionsDialog = (OptionsDialog)JdbcDatastoreDialog.this._optionsDialogProvider.get();
                    optionsDialog.selectDatabaseDriversTab();
                    JdbcDatastoreDialog.this.dispose();
                    optionsDialog.setVisible(true);
                    optionsDialog.toFront();
                }
            }
        });
        if (this._originalDatastore == null) {
            this.setSelectedDatabase((DatabaseDriverDescriptor)null);
        } else {
            this._multipleConnectionsCheckBox.setSelected(this._originalDatastore.isMultipleConnections());
            DatabaseDriverDescriptor databaseDriver = DatabaseDriverCatalog.getDatabaseDriverByDriverClassName(this._originalDatastore.getDriverClass());
            this._databaseDriverComboBox.setSelectedItem(databaseDriver);
            this._datastoreNameTextField.setText(this._originalDatastore.getName());
            this._datastoreNameTextField.setEnabled(false);
            this._connectionPresenters[0].initialize(this._originalDatastore);
            this._driverClassNameTextField.setText(this._originalDatastore.getDriverClass());
        }
    }

    public void setSelectedDatabase(String databaseName) {
        DatabaseDriverDescriptor databaseDriverDescriptor = DatabaseDriverCatalog.getDatabaseDriverByDriverDatabaseName(databaseName);
        this.setSelectedDatabase(databaseDriverDescriptor);
    }

    public void setSelectedDatabase(DatabaseDriverDescriptor databaseDriverDescriptor) {
        DatabaseConnectionPresenter customPresenter;
        this._databaseDriverComboBox.setSelectedItem(databaseDriverDescriptor);
        if (this._tabbedPane.getTabCount() > 1) {
            this._tabbedPane.removeTabAt(1);
        }
        this._connectionPresenters[1] = customPresenter = this.createDatabaseConnectionPresenter(databaseDriverDescriptor);
        if (customPresenter != null) {
            boolean accepted = true;
            if (this._originalDatastore != null) {
                accepted = customPresenter.initialize(this._originalDatastore);
            }
            if (accepted) {
                this._tabbedPane.setUnclosableTab(1);
                this._tabbedPane.addTab(databaseDriverDescriptor.getDisplayName() + " connection", imageManager.getImageIcon(databaseDriverDescriptor.getIconImagePath(), IconUtils.ICON_SIZE_MEDIUM, customPresenter.getClass().getClassLoader()), customPresenter.getWidget());
                this._tabbedPane.setSelectedIndex(1);
            } else {
                this._connectionPresenters[1] = null;
            }
        }
        for (DatabaseConnectionPresenter connectionPresenter : this._connectionPresenters) {
            if (connectionPresenter == null) continue;
            connectionPresenter.setSelectedDatabaseDriver(databaseDriverDescriptor);
        }
    }

    public DatabaseConnectionPresenter createDatabaseConnectionPresenter(DatabaseDriverDescriptor databaseDriverDescriptor) {
        if (databaseDriverDescriptor == null) {
            return null;
        }
        String databaseName = databaseDriverDescriptor.getDisplayName();
        UrlTemplateDatabaseConnectionPresenter result = "MySQL".equals(databaseName) ? new MysqlDatabaseConnectionPresenter() : ("PostgreSQL".equals(databaseName) ? new PostgresqlDatabaseConnectionPresenter() : ("Oracle".equals(databaseName) ? new OracleDatabaseConnectionPresenter() : ("Microsoft SQL Server (JTDS)".equals(databaseName) ? new SQLServerDatabaseConnectionPresenter() : ("Cubrid".equals(databaseName) ? new CubridDatabaseConnectionPresenter() : ("H2".equals(databaseName) ? new H2DatabaseConnectionPresenter() : null)))));
        return result;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected String getBannerTitle() {
        return "Database connection";
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Datastore name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._datastoreNameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Database driver:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._databaseDriverComboBox, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Driver class name:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._driverClassNameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(this._multipleConnectionsCheckBox, formPanel, 1, ++row);
        final JButton testButton = WidgetFactory.createButton(this.getTestButtonText(), "images/actions/refresh.png");
        testButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                JdbcDatastore datastore = JdbcDatastoreDialog.this.createDatastore();
                ArrayList<Connection> connections = new ArrayList<Connection>();
                try {
                    if (datastore.isMultipleConnections()) {
                        DataSource ds = datastore.createDataSource();
                        for (int i = 0; i < 20; ++i) {
                            Connection connection = ds.getConnection();
                            connections.add(connection);
                        }
                    } else {
                        Connection connnection = datastore.createConnection();
                        connections.add(connnection);
                    }
                }
                catch (Throwable e) {
                    try {
                        WidgetUtils.showErrorMessage("Could not establish connection", e);
                    }
                    catch (Throwable throwable) {
                        for (Connection connection : connections) {
                            FileHelper.safeClose((Object[])new Object[]{connection});
                        }
                        throw throwable;
                    }
                    for (Connection connection : connections) {
                        FileHelper.safeClose((Object[])new Object[]{connection});
                    }
                    return;
                }
                for (Connection connection : connections) {
                    FileHelper.safeClose((Object[])new Object[]{connection});
                }
                JOptionPane.showMessageDialog(JdbcDatastoreDialog.this, "Connection successful!");
            }
        });
        JButton saveButton = WidgetFactory.createButton("Save datastore", "images/model/datastore.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdbcDatastore datastore = JdbcDatastoreDialog.this.createDatastore();
                if (JdbcDatastoreDialog.this._originalDatastore != null) {
                    JdbcDatastoreDialog.this._catalog.removeDatastore((Datastore)JdbcDatastoreDialog.this._originalDatastore);
                }
                JdbcDatastoreDialog.this._catalog.addDatastore((Datastore)datastore);
                JdbcDatastoreDialog.this.dispose();
            }
        });
        this._multipleConnectionsCheckBox.addListener(new DCCheckBox.Listener<Object>(){

            @Override
            public void onItemSelected(Object item, boolean selected) {
                testButton.setText(JdbcDatastoreDialog.this.getTestButtonText());
            }
        });
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(new HumanInferenceToolbarButton());
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(testButton);
        toolBar.add(Box.createHorizontalStrut(4));
        toolBar.add(saveButton);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARKEST, WidgetUtils.BG_COLOR_DARKEST);
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "Center");
        DCPanel formContainerPanel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        formContainerPanel.setLayout(new BorderLayout());
        formContainerPanel.setBorder(WidgetUtils.BORDER_TOP_PADDING);
        formContainerPanel.add((Component)formPanel, "North");
        formContainerPanel.add((Component)this._tabbedPane, "Center");
        formContainerPanel.add((Component)toolBarPanel, "South");
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)new DescriptionLabel("Use this dialog to connect to your relational database. Connections are made using a Connection string (aka. a JDBC URL) and a set of credentials. These can be entered directly in the 'Generic connection parameters' panel. If you see an additional panel, this provides an alternative means of connecting without having to know the URL format for your specific database type."), "North");
        outerPanel.add((Component)formContainerPanel, "Center");
        outerPanel.setPreferredSize(this.getDialogWidth(), 500);
        return outerPanel;
    }

    private String getTestButtonText() {
        if (this._multipleConnectionsCheckBox.isSelected()) {
            return "Test connections";
        }
        return "Test connection";
    }

    private JdbcDatastore createDatastore() {
        String datastoreName = this._datastoreNameTextField.getText();
        if (StringUtils.isNullOrEmpty((String)datastoreName)) {
            throw new IllegalStateException("No datastore name");
        }
        int connectionPresenterIndex = this._tabbedPane.getSelectedIndex();
        DatabaseConnectionPresenter connectionPresenter = this._connectionPresenters[connectionPresenterIndex];
        logger.info("Creating datastore using connection presenter ({}): {}", (Object)connectionPresenterIndex, (Object)connectionPresenter);
        String driverClass = this._driverClassNameTextField.getText();
        String connectionString = connectionPresenter.getJdbcUrl();
        String username = connectionPresenter.getUsername();
        String password = connectionPresenter.getPassword();
        boolean multipleConnections = this._multipleConnectionsCheckBox.isSelected();
        JdbcDatastore datastore = new JdbcDatastore(datastoreName, connectionString, driverClass, username, password, multipleConnections);
        return datastore;
    }

    @Override
    public String getWindowTitle() {
        return "Database connection | Datastore";
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/model/datastore.png", new ClassLoader[0]);
    }
}

