/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jackson.map.ObjectMapper;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.DCWindowContext;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.user.UserPreferencesImpl;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.SecurityUtils;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.JXTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorConnectionDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MonitorConnectionDialog.class);
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final UserPreferences _userPreferences;
    private final DCCheckBox<Void> _httpsCheckBox;
    private final JXTextField _hostnameTextField;
    private final JXTextField _portTextField;
    private final JXTextField _contextPathTextField;
    private final JXTextField _tenantTextField;
    private final DCCheckBox<Void> _authenticationCheckBox;
    private final JXTextField _usernameTextField;
    private final JPasswordField _passwordTextField;
    private final DCLabel _urlLabel;
    private final HttpClient _httpClient;

    @Inject
    public MonitorConnectionDialog(WindowContext windowContext, UserPreferences userPreferences, HttpClient httpClient) {
        super(windowContext, imageManager.getImage("images/window/banner-dq-monitor.png", new ClassLoader[0]));
        this._userPreferences = userPreferences;
        this._httpClient = httpClient;
        MonitorConnection monitorConnection = this._userPreferences.getMonitorConnection();
        this._urlLabel = DCLabel.bright("");
        this._urlLabel.setForeground(WidgetUtils.BG_COLOR_LESS_BRIGHT);
        this._urlLabel.setBorder(new EmptyBorder(0, 0, 25, 0));
        this._httpsCheckBox = new DCCheckBox("Use HTTPS?", false);
        if (monitorConnection != null && monitorConnection.isHttps()) {
            this._httpsCheckBox.setSelected(true);
        }
        this._httpsCheckBox.setBorderPainted(false);
        this._httpsCheckBox.setOpaque(false);
        this._httpsCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._httpsCheckBox.addListener(new DCCheckBox.Listener<Void>(){

            @Override
            public void onItemSelected(Void item, boolean selected) {
                MonitorConnectionDialog.this.updateUrlLabel();
            }
        });
        this._hostnameTextField = WidgetFactory.createTextField("Hostname");
        if (monitorConnection != null && monitorConnection.getHostname() != null) {
            this._hostnameTextField.setText(monitorConnection.getHostname());
        } else {
            this._hostnameTextField.setText("localhost");
        }
        this._hostnameTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                MonitorConnectionDialog.this.updateUrlLabel();
            }
        });
        this._portTextField = WidgetFactory.createTextField("Port");
        this._portTextField.setDocument((Document)new NumberDocument(false));
        if (monitorConnection != null) {
            this._portTextField.setText(monitorConnection.getPort() + "");
        } else {
            this._portTextField.setText("8080");
        }
        this._portTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                MonitorConnectionDialog.this.updateUrlLabel();
            }
        });
        this._contextPathTextField = WidgetFactory.createTextField("Context path");
        if (monitorConnection != null) {
            this._contextPathTextField.setText(monitorConnection.getContextPath());
        } else {
            this._contextPathTextField.setText("DataCleaner-monitor");
        }
        this._contextPathTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                MonitorConnectionDialog.this.updateUrlLabel();
            }
        });
        this._tenantTextField = WidgetFactory.createTextField("Tenant ID");
        if (monitorConnection != null) {
            this._tenantTextField.setText(monitorConnection.getTenantId());
        } else {
            this._tenantTextField.setText("DC");
        }
        this._tenantTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                MonitorConnectionDialog.this.updateUrlLabel();
            }
        });
        this._usernameTextField = WidgetFactory.createTextField("Username");
        this._passwordTextField = WidgetFactory.createPasswordField();
        this._authenticationCheckBox = new DCCheckBox("Use authentication?", true);
        this._authenticationCheckBox.setBorderPainted(false);
        this._authenticationCheckBox.setOpaque(false);
        this._authenticationCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._authenticationCheckBox.addListener(new DCCheckBox.Listener<Void>(){

            @Override
            public void onItemSelected(Void item, boolean selected) {
                MonitorConnectionDialog.this._usernameTextField.setEnabled(selected);
                MonitorConnectionDialog.this._passwordTextField.setEnabled(selected);
            }
        });
        if (monitorConnection != null && monitorConnection.isAuthenticationEnabled()) {
            this._authenticationCheckBox.setSelected(true);
            String username = monitorConnection.getUsername();
            this._usernameTextField.setText(username);
            String decodedPassword = SecurityUtils.decodePassword(monitorConnection.getEncodedPassword());
            this._passwordTextField.setText(decodedPassword);
        } else {
            this._authenticationCheckBox.setSelected(false);
        }
        this.updateUrlLabel();
    }

    public MonitorConnection createMonitorConnection() {
        char[] password;
        String username;
        int port = 8080;
        try {
            port = Integer.parseInt(this._portTextField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this._authenticationCheckBox.isSelected()) {
            username = this._usernameTextField.getText();
            password = this._passwordTextField.getPassword();
        } else {
            username = null;
            password = null;
        }
        return new MonitorConnection(this._hostnameTextField.getText(), port, this._contextPathTextField.getText(), this._httpsCheckBox.isSelected(), this._tenantTextField.getText(), username, password);
    }

    private void updateUrlLabel() {
        MonitorConnection monitorConnection = this.createMonitorConnection();
        this._urlLabel.setText("Repository url: " + monitorConnection.getRepositoryUrl());
    }

    @Override
    public String getWindowTitle() {
        return "DataCleaner dq monitor connection";
    }

    @Override
    protected String getBannerTitle() {
        return "DataCleaner dq monitor\nSet up connection";
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Hostname:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._hostnameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Port:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._portTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Context path:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._contextPathTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(this._httpsCheckBox, formPanel, 1, ++row);
        WidgetUtils.addToGridBag(DCLabel.bright("Tenant ID:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._tenantTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag((Component)this._urlLabel, (JPanel)formPanel, 0, ++row, 2, 1);
        WidgetUtils.addToGridBag(this._authenticationCheckBox, formPanel, 1, ++row);
        WidgetUtils.addToGridBag(DCLabel.bright("Username:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._usernameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Password:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._passwordTextField, formPanel, 1, row);
        formPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        JButton testButton = WidgetFactory.createButton("Test connection", "images/actions/refresh.png");
        testButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent event) {
                block4: {
                    MonitorConnection connection = MonitorConnectionDialog.this.createMonitorConnection();
                    connection.prepareClient(MonitorConnectionDialog.this._httpClient);
                    String pingUrl = connection.getRepositoryUrl() + "/ping";
                    try {
                        StatusLine statusLine;
                        block5: {
                            Map map;
                            HttpResponse response = MonitorConnectionDialog.this._httpClient.execute((HttpUriRequest)new HttpGet(pingUrl));
                            statusLine = response.getStatusLine();
                            if (statusLine.getStatusCode() != 200) break block5;
                            InputStream content = response.getEntity().getContent();
                            try {
                                map = (Map)new ObjectMapper().readValue(content, Map.class);
                            }
                            catch (Throwable throwable) {
                                FileHelper.safeClose((Object[])new Object[]{content});
                                throw throwable;
                            }
                            FileHelper.safeClose((Object[])new Object[]{content});
                            logger.info("Ping request responded: {}", (Object)map);
                            JOptionPane.showMessageDialog(MonitorConnectionDialog.this, "Connection successful!");
                            break block4;
                        }
                        String reasonPhrase = statusLine.getReasonPhrase();
                        WidgetUtils.showErrorMessage("Server reported error", "Server replied with status " + statusLine.getStatusCode() + ":\n" + reasonPhrase, null);
                    }
                    catch (Exception e) {
                        WidgetUtils.showErrorMessage("Connection failed", "Connecting to DataCleaner dq monitor failed. Did you remember to fill in all the nescesary fields?", e);
                    }
                }
            }
        });
        JButton saveButton = WidgetFactory.createButton("Save connection", "images/actions/save.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorConnection monitorConnection = MonitorConnectionDialog.this.createMonitorConnection();
                MonitorConnectionDialog.this._userPreferences.setMonitorConnection(monitorConnection);
                MonitorConnectionDialog.this.close();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        buttonPanel.setLayout(new FlowLayout(2, 4, 0));
        buttonPanel.add(testButton);
        buttonPanel.add(saveButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel();
        descriptionLabel.setText("The DataCleaner dq monitor is a separate web application that is part of the DataCleaner eco-system. In this dialog you can configure your connection to it. With the dq monitor you can create, share, monitor and govern current and historic data quality metrics. You can also set up alerts to react when certain metrics are out of their expected ranges.");
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)descriptionLabel, "North");
        panel.add((Component)formPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        panel.setPreferredSize(this.getDialogWidth(), 400);
        return panel;
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (!StringUtils.isNullOrEmpty((String)this._usernameTextField.getText())) {
            this._passwordTextField.setBorder(WidgetUtils.BORDER_EMPHASIZE_FIELD);
            boolean focused = this._passwordTextField.requestFocusInWindow();
            assert (focused);
        }
    }

    public static void main(String[] args) {
        LookAndFeelManager.getInstance().init();
        UserPreferencesImpl userPreferences = new UserPreferencesImpl(null);
        DCWindowContext windowContext = new DCWindowContext(null, userPreferences, null);
        MonitorConnectionDialog dialog = new MonitorConnectionDialog(windowContext, userPreferences, (HttpClient)new DefaultHttpClient());
        dialog.open();
    }

    public void openBlocking() {
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.open();
    }
}

