/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.SourceColumnComboBox;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.VerticalLayout;

public class MultiSourceColumnComboBoxPanel
extends DCPanel {
    private static final long serialVersionUID = 6598553122965748098L;
    private Datastore _datastore;
    private Table _table;
    private final DCPanel _sourceComboBoxPanel = new DCPanel();
    private final DCPanel _buttonPanel = new DCPanel();
    private final List<SourceColumnComboBox> _sourceColumnComboBoxes;

    public MultiSourceColumnComboBoxPanel() {
        this._sourceComboBoxPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        this._sourceComboBoxPanel.setLayout((LayoutManager)new VerticalLayout(2));
        this._sourceColumnComboBoxes = new ArrayList<SourceColumnComboBox>();
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        this._buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        this._buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        this._buttonPanel.add(addButton);
        this._buttonPanel.add(removeButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSourceColumnComboBoxPanel.this.createSourceColumnComboBox(null);
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int componentCount = MultiSourceColumnComboBoxPanel.this._sourceComboBoxPanel.getComponentCount();
                if (componentCount > 0) {
                    MultiSourceColumnComboBoxPanel.this._sourceComboBoxPanel.remove(componentCount - 1);
                    MultiSourceColumnComboBoxPanel.this._sourceComboBoxPanel.updateUI();
                }
            }
        });
        this.createSourceColumnComboBox(null);
    }

    private void createSourceColumnComboBox(Column column) {
        SourceColumnComboBox sourceColumnComboBox = this._table == null ? new SourceColumnComboBox(this._datastore) : new SourceColumnComboBox(this._datastore, this._table);
        sourceColumnComboBox.setSelectedItem(column);
        this._sourceColumnComboBoxes.add(sourceColumnComboBox);
        this._sourceComboBoxPanel.add(sourceColumnComboBox);
        this._sourceComboBoxPanel.updateUI();
    }

    public DCPanel createPanel() {
        DCPanel parentPanel = new DCPanel();
        parentPanel.setLayout(new BorderLayout());
        parentPanel.add((Component)this._sourceComboBoxPanel, "Center");
        parentPanel.add((Component)this._buttonPanel, "East");
        return parentPanel;
    }

    public void setModel(Datastore datastore) {
        this._datastore = datastore;
        for (SourceColumnComboBox comboBox : this._sourceColumnComboBoxes) {
            comboBox.setModel(datastore);
        }
    }

    public String[] getColumnNames() {
        List<Column> columns = this.getColumns();
        return this.convertToStringArry(columns);
    }

    private String[] convertToStringArry(List<Column> columns) {
        ArrayList<String> columnNamesAsString = new ArrayList<String>();
        for (Column column : columns) {
            columnNamesAsString.add(column.getQualifiedLabel());
        }
        return columnNamesAsString.toArray(new String[0]);
    }

    public List<Column> getColumns() {
        Component[] components;
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Component component : components = this._sourceComboBoxPanel.getComponents()) {
            if (!(component instanceof SourceColumnComboBox)) continue;
            SourceColumnComboBox sourceColumnComboBox = (SourceColumnComboBox)component;
            columns.add(sourceColumnComboBox.getSelectedItem());
        }
        return columns;
    }

    public void setColumns(Collection<Column> columns) {
        Component[] components;
        Iterator<Column> it = columns.iterator();
        for (Component component : components = this._sourceComboBoxPanel.getComponents()) {
            if (!(component instanceof SourceColumnComboBox)) continue;
            if (!it.hasNext()) {
                return;
            }
            Column column = it.next();
            SourceColumnComboBox sourceColumnComboBox = (SourceColumnComboBox)component;
            sourceColumnComboBox.setSelectedItem(column);
        }
        while (it.hasNext()) {
            this.createSourceColumnComboBox(it.next());
        }
    }

    public void updateSourceComboBoxes(Datastore datastore, Table table) {
        this._datastore = datastore;
        this._table = table;
        for (SourceColumnComboBox sourceColComboBox : this._sourceColumnComboBoxes) {
            sourceColComboBox.setModel(datastore, table);
        }
    }
}

