/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import javax.inject.Inject;
import org.eobjects.analyzer.connection.OdbDatastore;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;

public final class OdbDatastoreDialog
extends AbstractFileBasedDatastoreDialog<OdbDatastore> {
    private static final long serialVersionUID = 1L;

    @Inject
    protected OdbDatastoreDialog(@Nullable OdbDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
    }

    @Override
    protected String getBannerTitle() {
        return "OpenOffice.org database";
    }

    @Override
    public String getWindowTitle() {
        return "OpenOffice.org database | Datastore";
    }

    @Override
    protected OdbDatastore createDatastore(String name, String filename) {
        return new OdbDatastore(name, filename);
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/odb.png";
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        filenameField.addChoosableFileFilter(FileFilters.ODB);
        filenameField.addChoosableFileFilter(FileFilters.ALL);
        filenameField.setSelectedFileFilter(FileFilters.ODB);
    }
}

