/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileObject;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.SourceColumnMapping;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.job.AnalysisJobMetadata;
import org.eobjects.analyzer.job.JaxbJobReader;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.actions.OpenAnalysisJobActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.SourceColumnComboBox;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXTextField;

public class OpenAnalysisJobAsTemplateDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final AnalyzerBeansConfiguration _configuration;
    private final FileObject _file;
    private final AnalysisJobMetadata _metadata;
    private final SourceColumnMapping _sourceColumnMapping;
    private final DatastoreCatalog _datastoreCatalog;
    private final JComboBox _datastoreCombobox;
    private final Map<String, List<SourceColumnComboBox>> _sourceColumnComboBoxes;
    private final Map<String, JXTextField> _variableTextFields;
    private final JButton _openButton;
    private final JButton _autoMapButton;
    private final Provider<OpenAnalysisJobActionListener> _openAnalysisJobActionListenerProvider;
    private volatile Datastore _datastore;

    public OpenAnalysisJobAsTemplateDialog(WindowContext windowContext, AnalyzerBeansConfiguration configuration, FileObject file, AnalysisJobMetadata metadata, Provider<OpenAnalysisJobActionListener> openAnalysisJobActionListenerProvider) {
        super(windowContext, imageManager.getImage("images/window/banner-logo.png", new ClassLoader[0]));
        this._configuration = configuration;
        this._file = file;
        this._metadata = metadata;
        this._openAnalysisJobActionListenerProvider = openAnalysisJobActionListenerProvider;
        this._sourceColumnMapping = new SourceColumnMapping(metadata);
        this._variableTextFields = new HashMap<String, JXTextField>();
        this._openButton = new JButton("Open job");
        this._openButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JaxbJobReader reader = new JaxbJobReader(OpenAnalysisJobAsTemplateDialog.this._configuration);
                try {
                    AnalysisJobBuilder ajb;
                    SourceColumnMapping sourceColumnMapping = OpenAnalysisJobAsTemplateDialog.this.getSourceColumnMapping();
                    HashMap variableOverrides = new HashMap();
                    for (Map.Entry entry : OpenAnalysisJobAsTemplateDialog.this._variableTextFields.entrySet()) {
                        variableOverrides.put(entry.getKey(), ((JXTextField)entry.getValue()).getText());
                    }
                    InputStream inputStream = OpenAnalysisJobAsTemplateDialog.this._file.getContent().getInputStream();
                    try {
                        ajb = reader.create(inputStream, sourceColumnMapping, variableOverrides);
                    }
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{inputStream});
                        throw throwable;
                    }
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    OpenAnalysisJobActionListener openAnalysisJobActionListener = (OpenAnalysisJobActionListener)OpenAnalysisJobAsTemplateDialog.this._openAnalysisJobActionListenerProvider.get();
                    Injector injector = openAnalysisJobActionListener.openAnalysisJob(OpenAnalysisJobAsTemplateDialog.this._file, ajb);
                    OpenAnalysisJobAsTemplateDialog.this.dispose();
                    AnalysisJobBuilderWindow window = (AnalysisJobBuilderWindow)injector.getInstance(AnalysisJobBuilderWindow.class);
                    window.open();
                }
                catch (Exception e1) {
                    throw new IllegalStateException(e1);
                }
            }
        });
        List columnPaths = this._metadata.getSourceColumnPaths();
        this._sourceColumnComboBoxes = new HashMap<String, List<SourceColumnComboBox>>();
        for (String string : columnPaths) {
            int columnDelim = string.lastIndexOf(46);
            assert (columnDelim != -1);
            final String tablePath = string.substring(0, columnDelim);
            SourceColumnComboBox comboBox = new SourceColumnComboBox();
            comboBox.setEnabled(false);
            comboBox.setName(string);
            comboBox.addListener(new DCComboBox.Listener<Column>(){

                @Override
                public void onItemSelected(Column col) {
                    if (col != null) {
                        List comboBoxes = (List)OpenAnalysisJobAsTemplateDialog.this._sourceColumnComboBoxes.get(tablePath);
                        for (SourceColumnComboBox sameTableComboBox : comboBoxes) {
                            sameTableComboBox.setModel(OpenAnalysisJobAsTemplateDialog.this._datastore, col.getTable());
                        }
                    }
                    OpenAnalysisJobAsTemplateDialog.this.refreshOpenButtonVisibility();
                }
            });
            if (!this._sourceColumnComboBoxes.containsKey(tablePath)) {
                this._sourceColumnComboBoxes.put(tablePath, new ArrayList());
            }
            this._sourceColumnComboBoxes.get(tablePath).add(comboBox);
        }
        for (Map.Entry entry : metadata.getVariables().entrySet()) {
            String id = (String)entry.getKey();
            String value = (String)entry.getValue();
            JXTextField textField = WidgetFactory.createTextField("Original: " + value);
            textField.setText(value);
            this._variableTextFields.put(id, textField);
        }
        this._openButton.setEnabled(false);
        this._datastoreCatalog = configuration.getDatastoreCatalog();
        Object[] datastoreNames = this._datastoreCatalog.getDatastoreNames();
        String[] stringArray = (String[])CollectionUtils.array((Object[])new String[1], (Object[])datastoreNames);
        this._datastoreCombobox = new JComboBox<String>(stringArray);
        this._datastoreCombobox.setEditable(false);
        this._datastoreCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String datastoreName = (String)OpenAnalysisJobAsTemplateDialog.this._datastoreCombobox.getSelectedItem();
                OpenAnalysisJobAsTemplateDialog.this._datastore = OpenAnalysisJobAsTemplateDialog.this._datastoreCatalog.getDatastore(datastoreName);
                OpenAnalysisJobAsTemplateDialog.this._sourceColumnMapping.setDatastore(OpenAnalysisJobAsTemplateDialog.this._datastore);
                OpenAnalysisJobAsTemplateDialog.this.refreshOpenButtonVisibility();
                for (List comboBoxes : OpenAnalysisJobAsTemplateDialog.this._sourceColumnComboBoxes.values()) {
                    for (SourceColumnComboBox comboBox : comboBoxes) {
                        comboBox.setModel(OpenAnalysisJobAsTemplateDialog.this._datastore);
                        if (OpenAnalysisJobAsTemplateDialog.this._datastore == null) {
                            comboBox.setEnabled(false);
                            continue;
                        }
                        comboBox.setEnabled(true);
                    }
                }
                if (OpenAnalysisJobAsTemplateDialog.this._datastore == null) {
                    OpenAnalysisJobAsTemplateDialog.this._autoMapButton.setVisible(false);
                } else {
                    OpenAnalysisJobAsTemplateDialog.this._autoMapButton.setVisible(true);
                }
            }
        });
        this._autoMapButton = new JButton("Map automatically");
        this._autoMapButton.setVisible(false);
        this._autoMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAnalysisJobAsTemplateDialog.this._sourceColumnMapping.autoMap(OpenAnalysisJobAsTemplateDialog.this._datastore);
                Set paths = OpenAnalysisJobAsTemplateDialog.this._sourceColumnMapping.getPaths();
                for (String path : paths) {
                    for (List comboBoxes : OpenAnalysisJobAsTemplateDialog.this._sourceColumnComboBoxes.values()) {
                        for (SourceColumnComboBox comboBox : comboBoxes) {
                            if (!path.equals(comboBox.getName())) continue;
                            comboBox.setSelectedItem(OpenAnalysisJobAsTemplateDialog.this._sourceColumnMapping.getColumn(path));
                        }
                    }
                }
            }
        });
    }

    public void refreshOpenButtonVisibility() {
        if (this._datastore == null) {
            this._openButton.setEnabled(false);
            return;
        }
        for (List<SourceColumnComboBox> comboBoxes : this._sourceColumnComboBoxes.values()) {
            for (SourceColumnComboBox comboBox : comboBoxes) {
                if (comboBox.getSelectedItem() != null) continue;
                this._openButton.setEnabled(false);
                return;
            }
        }
        this._openButton.setEnabled(true);
    }

    public SourceColumnMapping getSourceColumnMapping() {
        for (List<SourceColumnComboBox> comboBoxes : this._sourceColumnComboBoxes.values()) {
            for (SourceColumnComboBox comboBox : comboBoxes) {
                this._sourceColumnMapping.setColumn(comboBox.getName(), comboBox.getSelectedItem());
            }
        }
        return this._sourceColumnMapping;
    }

    @Override
    protected String getBannerTitle() {
        return "Open as template";
    }

    @Override
    protected int getDialogWidth() {
        return 600;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel panel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("<html><b>Original value:</b></html>"), panel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("<html><b>New/mapped value:</b></html>"), panel, 2, row);
        WidgetUtils.addToGridBag(new JLabel(imageManager.getImageIcon("images/model/datastore.png", new ClassLoader[0])), panel, 0, ++row);
        WidgetUtils.addToGridBag(DCLabel.bright(this._metadata.getDatastoreName()), panel, 1, row, 17);
        DCPanel datastoreButtonPanel = new DCPanel();
        datastoreButtonPanel.setLayout((LayoutManager)new HorizontalLayout(0));
        datastoreButtonPanel.add(this._datastoreCombobox);
        datastoreButtonPanel.add(Box.createHorizontalStrut(4));
        datastoreButtonPanel.add(this._autoMapButton);
        WidgetUtils.addToGridBag(datastoreButtonPanel, panel, 2, row, 17);
        Set<String> tableNames = this._sourceColumnComboBoxes.keySet();
        for (final String tableName : tableNames) {
            DCLabel tableLabel = DCLabel.bright("<html><b>" + tableName + "</b></html>");
            tableLabel.setIcon(imageManager.getImageIcon("images/model/table.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            WidgetUtils.addToGridBag((Component)tableLabel, (JPanel)panel, 0, ++row, 2, 1, 17);
            JButton clearButton = new JButton("Clear");
            clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List comboBoxes = (List)OpenAnalysisJobAsTemplateDialog.this._sourceColumnComboBoxes.get(tableName);
                    for (SourceColumnComboBox comboBox : comboBoxes) {
                        comboBox.setModel(OpenAnalysisJobAsTemplateDialog.this._datastore, false);
                    }
                }
            });
            DCPanel clearButtonPanel = new DCPanel();
            clearButtonPanel.add(clearButton);
            WidgetUtils.addToGridBag(clearButtonPanel, panel, 2, row, 10);
            List<SourceColumnComboBox> comboBoxes = this._sourceColumnComboBoxes.get(tableName);
            for (SourceColumnComboBox comboBox : comboBoxes) {
                WidgetUtils.addToGridBag(new JLabel(imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0])), panel, 0, ++row);
                WidgetUtils.addToGridBag(DCLabel.bright(comboBox.getName()), panel, 1, row, 17);
                WidgetUtils.addToGridBag(comboBox, panel, 2, row, 17);
            }
        }
        ++row;
        if (!this._variableTextFields.isEmpty()) {
            DCLabel tableLabel = DCLabel.bright("<html><b>Job-level variables</b></html>");
            tableLabel.setIcon(imageManager.getImageIcon("images/filetypes/analysis_job.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            WidgetUtils.addToGridBag((Component)tableLabel, (JPanel)panel, 0, row, 2, 1, 17);
            for (Map.Entry<String, JXTextField> entry : this._variableTextFields.entrySet()) {
                String variableId = entry.getKey();
                JXTextField textField = entry.getValue();
                WidgetUtils.addToGridBag(new JLabel(imageManager.getImageIcon("images/model/variable.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0])), panel, 0, ++row);
                WidgetUtils.addToGridBag(DCLabel.bright(variableId), panel, 1, row, 17);
                WidgetUtils.addToGridBag((Component)textField, panel, 2, row, 17);
            }
            ++row;
        }
        DCPanel openButtonPanel = new DCPanel();
        openButtonPanel.add(this._openButton);
        WidgetUtils.addToGridBag(openButtonPanel, panel, 2, row, 13);
        return WidgetUtils.scrolleable(panel);
    }

    @Override
    public String getWindowTitle() {
        return "Open analysis job as template";
    }
}

