/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.job.concurrent.MultiThreadedTaskRunner;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.storage.StorageProvider;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCBannerPanel;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DatabaseDriversPanel;
import org.eobjects.datacleaner.panels.ExtensionPackagesPanel;
import org.eobjects.datacleaner.user.QuickAnalysisStrategy;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.widgets.HelpIcon;
import org.eobjects.datacleaner.widgets.HumanInferenceToolbarButton;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractWindow;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class OptionsDialog
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final UserPreferences _userPreferences;
    private final CloseableTabbedPane _tabbedPane;
    private final AnalyzerBeansConfiguration _configuration;
    private Timer _updateMemoryTimer;

    @Inject
    protected OptionsDialog(WindowContext windowContext, AnalyzerBeansConfiguration configuration, UserPreferences userPreferences, DatabaseDriversPanel databaseDriversPanel, ExtensionPackagesPanel extensionPackagesPanel) {
        super(windowContext);
        this._userPreferences = userPreferences;
        this._configuration = configuration;
        this._tabbedPane = new CloseableTabbedPane(true);
        this._tabbedPane.addTab("General", this.imageManager.getImageIcon("images/menu/options.png", new ClassLoader[0]), this.getGeneralTab());
        this._tabbedPane.addTab("Database drivers", this.imageManager.getImageIcon("images/model/datastore.png", new ClassLoader[0]), databaseDriversPanel);
        this._tabbedPane.addTab("Network", this.imageManager.getImageIcon("images/menu/network.png", new ClassLoader[0]), this.getNetworkTab());
        this._tabbedPane.addTab("Performance", this.imageManager.getImageIcon("images/menu/performance.png", new ClassLoader[0]), this.getPerformanceTab());
        this._tabbedPane.addTab("Memory", this.imageManager.getImageIcon("images/menu/memory.png", new ClassLoader[0]), this.getMemoryTab());
        this._tabbedPane.addTab("Extensions", this.imageManager.getImageIcon("images/component-types/plugin.png", new ClassLoader[0]), extensionPackagesPanel);
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.setUnclosableTab(1);
        this._tabbedPane.setUnclosableTab(2);
        this._tabbedPane.setUnclosableTab(3);
        this._tabbedPane.setUnclosableTab(4);
        this._tabbedPane.setUnclosableTab(5);
    }

    public void selectDatabaseDriversTab() {
        this._tabbedPane.setSelectedIndex(1);
    }

    private DCPanel getGeneralTab() {
        String username = this._userPreferences.getUsername();
        final JXTextField usernameTextField = WidgetFactory.createTextField();
        usernameTextField.setText(username);
        usernameTextField.setEnabled(false);
        final JButton logoutButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this._userPreferences.setUsername(null);
                usernameTextField.setText("");
                logoutButton.setEnabled(false);
            }
        });
        logoutButton.setEnabled(this._userPreferences.isLoggedIn());
        DCPanel userRegistrationPanel = new DCPanel().setTitledBorder("User registration");
        userRegistrationPanel.add(DCLabel.dark("Logged in as:"));
        userRegistrationPanel.add((Component)usernameTextField);
        userRegistrationPanel.add(logoutButton);
        FilenameTextField saveDatastoreDirectoryField = new FilenameTextField(this._userPreferences.getSaveDatastoreDirectory(), true);
        saveDatastoreDirectoryField.setFile(this._userPreferences.getSaveDatastoreDirectory());
        saveDatastoreDirectoryField.setFileSelectionMode(1);
        saveDatastoreDirectoryField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                OptionsDialog.this._userPreferences.setSaveDatastoreDirectory(file);
            }
        });
        DCPanel directoriesPanel = new DCPanel().setTitledBorder("Files & directories");
        directoriesPanel.add(DCLabel.dark("Written datastores:"));
        directoriesPanel.add(saveDatastoreDirectoryField);
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        panel.setLayout((LayoutManager)new VerticalLayout(4));
        panel.add(userRegistrationPanel);
        panel.add(this.getQuickAnalysisPanel());
        panel.add(directoriesPanel);
        return panel;
    }

    private DCPanel getQuickAnalysisPanel() {
        QuickAnalysisStrategy quickAnalysisStrategy = this._userPreferences.getQuickAnalysisStrategy();
        final JXTextField columnsTextField = WidgetFactory.createTextField("Columns");
        columnsTextField.setColumns(2);
        columnsTextField.setDocument((Document)new NumberDocument());
        columnsTextField.setText("" + quickAnalysisStrategy.getColumnsPerAnalyzer());
        final JCheckBox valueDistributionCheckBox = new JCheckBox("Include Value distribution in Quick analysis?");
        valueDistributionCheckBox.setOpaque(false);
        valueDistributionCheckBox.setSelected(quickAnalysisStrategy.isIncludeValueDistribution());
        final JCheckBox patternFinderCheckBox = new JCheckBox("Include Pattern finder in Quick analysis?");
        patternFinderCheckBox.setOpaque(false);
        patternFinderCheckBox.setSelected(quickAnalysisStrategy.isIncludePatternFinder());
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int columns = Integer.parseInt(columnsTextField.getText());
                    QuickAnalysisStrategy newStrategy = new QuickAnalysisStrategy(columns, valueDistributionCheckBox.isSelected(), patternFinderCheckBox.isSelected());
                    OptionsDialog.this._userPreferences.setQuickAnalysisStrategy(newStrategy);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        valueDistributionCheckBox.addActionListener(actionListener);
        patternFinderCheckBox.addActionListener(actionListener);
        columnsTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                actionListener.actionPerformed(null);
            }
        });
        DCPanel quickAnalysisPanel = new DCPanel().setTitledBorder("Quick analysis");
        WidgetUtils.addToGridBag(DCLabel.dark("Max columns per analyzer:"), quickAnalysisPanel, 0, 0);
        WidgetUtils.addToGridBag((Component)columnsTextField, quickAnalysisPanel, 1, 0);
        WidgetUtils.addToGridBag((Component)valueDistributionCheckBox, (JPanel)quickAnalysisPanel, 0, 1, 2, 1);
        WidgetUtils.addToGridBag((Component)patternFinderCheckBox, (JPanel)quickAnalysisPanel, 0, 2, 2, 1);
        return quickAnalysisPanel;
    }

    private DCPanel getNetworkTab() {
        final JCheckBox proxyCheckBox = new JCheckBox("Enable HTTP proxy?", this._userPreferences.isProxyEnabled());
        proxyCheckBox.setOpaque(false);
        proxyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this._userPreferences.setProxyEnabled(proxyCheckBox.isSelected());
            }
        });
        DCPanel proxyPanel = new DCPanel().setTitledBorder("Proxy settings");
        JXTextField proxyHostField = WidgetFactory.createTextField("Proxy host");
        proxyHostField.setText(this._userPreferences.getProxyHostname());
        proxyHostField.getDocument().addDocumentListener(new DCDocumentListener((JTextField)proxyHostField){
            final /* synthetic */ JTextField val$proxyHostField;
            {
                this.val$proxyHostField = jTextField;
            }

            @Override
            protected void onChange(DocumentEvent e) {
                OptionsDialog.this._userPreferences.setProxyHostname(this.val$proxyHostField.getText());
            }
        });
        WidgetUtils.addToGridBag(new JLabel("Proxy host"), proxyPanel, 0, 0);
        WidgetUtils.addToGridBag((Component)proxyHostField, proxyPanel, 1, 0);
        JXTextField proxyPortField = WidgetFactory.createTextField("Proxy port");
        proxyPortField.setDocument(new NumberDocument());
        proxyPortField.getDocument().addDocumentListener(new DCDocumentListener((JTextField)proxyPortField){
            final /* synthetic */ JTextField val$proxyPortField;
            {
                this.val$proxyPortField = jTextField;
            }

            @Override
            protected void onChange(DocumentEvent event) {
                int port;
                try {
                    port = Integer.parseInt(this.val$proxyPortField.getText());
                }
                catch (Exception e) {
                    port = 8080;
                }
                OptionsDialog.this._userPreferences.setProxyPort(port);
            }
        });
        proxyPortField.setText("" + this._userPreferences.getProxyPort());
        WidgetUtils.addToGridBag(new JLabel("Proxy port"), proxyPanel, 0, 1);
        WidgetUtils.addToGridBag((Component)proxyPortField, proxyPanel, 1, 1);
        final JCheckBox proxyAuthCheckBox = new JCheckBox("Enable authentication?", this._userPreferences.isProxyAuthenticationEnabled());
        proxyAuthCheckBox.setOpaque(false);
        proxyAuthCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this._userPreferences.setProxyAuthenticationEnabled(proxyAuthCheckBox.isSelected());
            }
        });
        DCPanel proxyAuthPanel = new DCPanel().setTitledBorder("Proxy authentication");
        JXTextField proxyUsernameField = WidgetFactory.createTextField("Username");
        proxyUsernameField.setText(this._userPreferences.getProxyUsername());
        proxyUsernameField.getDocument().addDocumentListener(new DCDocumentListener((JTextField)proxyUsernameField){
            final /* synthetic */ JTextField val$proxyUsernameField;
            {
                this.val$proxyUsernameField = jTextField;
            }

            @Override
            protected void onChange(DocumentEvent event) {
                OptionsDialog.this._userPreferences.setProxyUsername(this.val$proxyUsernameField.getText());
            }
        });
        WidgetUtils.addToGridBag(new JLabel("Username"), proxyAuthPanel, 0, 0);
        WidgetUtils.addToGridBag((Component)proxyUsernameField, proxyAuthPanel, 1, 0);
        final JPasswordField proxyPasswordField = WidgetFactory.createPasswordField();
        proxyPasswordField.setText(this._userPreferences.getProxyPassword());
        proxyPasswordField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                OptionsDialog.this._userPreferences.setProxyPassword(String.valueOf(proxyPasswordField.getPassword()));
            }
        });
        WidgetUtils.addToGridBag(new JLabel("Password"), proxyAuthPanel, 0, 1);
        WidgetUtils.addToGridBag(proxyPasswordField, proxyAuthPanel, 1, 1);
        WidgetUtils.addToGridBag((Component)proxyAuthCheckBox, (JPanel)proxyPanel, 0, 2, 2, 1);
        WidgetUtils.addToGridBag((Component)proxyAuthPanel, (JPanel)proxyPanel, 0, 3, 2, 1);
        ActionListener actionListener = new ActionListener((JTextField)proxyHostField, proxyCheckBox, (JTextField)proxyPortField, proxyAuthCheckBox, (JTextField)proxyUsernameField, proxyPasswordField){
            final /* synthetic */ JTextField val$proxyHostField;
            final /* synthetic */ JCheckBox val$proxyCheckBox;
            final /* synthetic */ JTextField val$proxyPortField;
            final /* synthetic */ JCheckBox val$proxyAuthCheckBox;
            final /* synthetic */ JTextField val$proxyUsernameField;
            final /* synthetic */ JPasswordField val$proxyPasswordField;
            {
                this.val$proxyHostField = jTextField;
                this.val$proxyCheckBox = jCheckBox;
                this.val$proxyPortField = jTextField2;
                this.val$proxyAuthCheckBox = jCheckBox2;
                this.val$proxyUsernameField = jTextField3;
                this.val$proxyPasswordField = jPasswordField;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$proxyHostField.setEnabled(this.val$proxyCheckBox.isSelected());
                this.val$proxyPortField.setEnabled(this.val$proxyCheckBox.isSelected());
                this.val$proxyAuthCheckBox.setEnabled(this.val$proxyCheckBox.isSelected());
                this.val$proxyUsernameField.setEnabled(this.val$proxyAuthCheckBox.isSelected() && this.val$proxyCheckBox.isSelected());
                this.val$proxyPasswordField.setEnabled(this.val$proxyAuthCheckBox.isSelected() && this.val$proxyCheckBox.isSelected());
            }
        };
        proxyCheckBox.addActionListener(actionListener);
        proxyAuthCheckBox.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        DCPanel networkTabPanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        networkTabPanel.setLayout(new BorderLayout());
        networkTabPanel.add((Component)proxyCheckBox, "North");
        networkTabPanel.add((Component)proxyPanel, "Center");
        return networkTabPanel;
    }

    private DCPanel getPerformanceTab() {
        int numThreads;
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        int row = 0;
        TaskRunner taskRunner = this._configuration.getTaskRunner();
        WidgetUtils.addToGridBag(new JLabel("Task runner type:"), panel, 0, row);
        WidgetUtils.addToGridBag(new JLabel(taskRunner.getClass().getSimpleName()), panel, 1, row);
        WidgetUtils.addToGridBag(new HelpIcon("The task runner is used to determine the execution strategy of Analysis jobs. The most common strategy for this is to use a multithreaded task runner which will spawn several threads to enable concurrent execution of jobs."), panel, 2, row);
        if (taskRunner instanceof MultiThreadedTaskRunner && (numThreads = ((MultiThreadedTaskRunner)taskRunner).getNumThreads()) > 0) {
            WidgetUtils.addToGridBag(new JLabel("Thread pool size:"), panel, 0, ++row);
            WidgetUtils.addToGridBag(new JLabel("" + numThreads), panel, 1, row);
        }
        StorageProvider storageProvider = this._configuration.getStorageProvider();
        WidgetUtils.addToGridBag(new JLabel("Storage provider type:"), panel, 0, ++row);
        WidgetUtils.addToGridBag(new JLabel(storageProvider.getClass().getSimpleName()), panel, 1, row);
        WidgetUtils.addToGridBag(new HelpIcon("The storage provider is used for staging data during and after analysis, typically to store the results on disk in stead of holding everything in memory."), panel, 2, row);
        DCLabel descriptionLabel = DCLabel.darkMultiLine("Performance options are currently not configurable while you're running the application. You need to edit the applications configuration file for this. The configuration file is named <b>conf.xml</b> and is located in the root of the folder where you've installed DataCleaner.");
        descriptionLabel.setBorder(new EmptyBorder(10, 10, 0, 10));
        WidgetUtils.addToGridBag((Component)descriptionLabel, (JPanel)panel, 0, ++row, 2, 1);
        return panel;
    }

    private DCPanel getMemoryTab() {
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        final JLabel maxMemoryLabel = new JLabel("? kb", 4);
        final JLabel totalMemoryLabel = new JLabel("? kb", 4);
        final JLabel usedMemoryLabel = new JLabel("? kb", 4);
        final JLabel freeMemoryLabel = new JLabel("? kb", 4);
        WidgetUtils.addToGridBag(new JLabel("Max available memory:"), panel, 0, 0);
        WidgetUtils.addToGridBag(maxMemoryLabel, panel, 1, 0);
        WidgetUtils.addToGridBag(new JLabel("Allocated memory:"), panel, 0, 1);
        WidgetUtils.addToGridBag(totalMemoryLabel, panel, 1, 1);
        WidgetUtils.addToGridBag(new JLabel("Used memory:"), panel, 0, 2);
        WidgetUtils.addToGridBag(usedMemoryLabel, panel, 1, 2);
        WidgetUtils.addToGridBag(new JLabel("Free memory:"), panel, 0, 3);
        WidgetUtils.addToGridBag(freeMemoryLabel, panel, 1, 3);
        this._updateMemoryTimer = new Timer(1000, new ActionListener(){
            private final Runtime runtime = Runtime.getRuntime();
            private final NumberFormat nf = NumberFormat.getIntegerInstance();

            @Override
            public void actionPerformed(ActionEvent e) {
                long totalMemory = this.runtime.totalMemory();
                long freeMemory = this.runtime.freeMemory();
                long maxMemory = this.runtime.maxMemory();
                long usedMemory = totalMemory - freeMemory;
                if (maxMemory == Long.MAX_VALUE) {
                    maxMemoryLabel.setText("(no limit)");
                } else {
                    maxMemoryLabel.setText(this.nf.format(maxMemory / 1024L) + " kb");
                }
                totalMemoryLabel.setText(this.nf.format(totalMemory / 1024L) + " kb");
                usedMemoryLabel.setText(this.nf.format(usedMemory / 1024L) + " kb");
                freeMemoryLabel.setText(this.nf.format(freeMemory / 1024L) + " kb");
            }
        });
        this._updateMemoryTimer.setInitialDelay(0);
        this._updateMemoryTimer.start();
        JButton button = new JButton("Perform garbage collection");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                System.runFinalization();
            }
        });
        WidgetUtils.addToGridBag(button, panel, 1, 4);
        return panel;
    }

    @Override
    protected boolean onWindowClosing() {
        boolean closing = super.onWindowClosing();
        if (closing && this._updateMemoryTimer != null) {
            this._updateMemoryTimer.stop();
        }
        return closing;
    }

    @Override
    protected JComponent getWindowContent() {
        JButton closeButton = WidgetFactory.createButton("Close", "images/actions/save.png");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.dispose();
            }
        });
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(new HumanInferenceToolbarButton());
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(closeButton);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARKEST, WidgetUtils.BG_COLOR_DARKEST);
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "Center");
        DCBannerPanel banner = new DCBannerPanel("Options");
        this._tabbedPane.bindTabTitleToBanner(banner);
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)banner, "North");
        panel.add((Component)this._tabbedPane, "Center");
        panel.add((Component)toolBarPanel, "South");
        panel.setPreferredSize(500, 500);
        return panel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Options";
    }

    @Override
    public Image getWindowIcon() {
        return this.imageManager.getImage("images/menu/options.png", new ClassLoader[0]);
    }
}

