/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DictionaryListPanel;
import org.eobjects.datacleaner.panels.StringPatternListPanel;
import org.eobjects.datacleaner.panels.SynonymCatalogListPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.HumanInferenceToolbarButton;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractDialog;

public final class ReferenceDataDialog
extends AbstractDialog {
    public static final int REFERENCE_DATA_ITEM_MAX_WIDTH = 280;
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final CloseableTabbedPane _tabbedPane;
    private final DCGlassPane _glassPane = new DCGlassPane(this);
    private final InjectorBuilder _injectorBuilder;
    private volatile int _selectedTab;

    @Inject
    protected ReferenceDataDialog(WindowContext windowContext, InjectorBuilder injectorBuilder) {
        super(windowContext, imageManager.getImage("images/window/banner-reference-data.png", new ClassLoader[0]));
        this._tabbedPane = new CloseableTabbedPane(true);
        this._tabbedPane.bindTabTitleToBanner(this.getBanner());
        this._injectorBuilder = injectorBuilder;
    }

    private JComponent scrolleable(JComponent comp) {
        JScrollPane scroll = WidgetUtils.scrolleable(comp);
        scroll.setHorizontalScrollBarPolicy(31);
        return scroll;
    }

    public void selectDictionariesTab() {
        this._selectedTab = 0;
        this.updateSelectedTab();
    }

    public void selectSynonymsTab() {
        this._selectedTab = 1;
        this.updateSelectedTab();
    }

    public void selectStringPatternsTab() {
        this._selectedTab = 2;
        this.updateSelectedTab();
    }

    private void updateSelectedTab() {
        if (this._tabbedPane.getTabCount() > this._selectedTab) {
            this._tabbedPane.setSelectedIndex(this._selectedTab);
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Reference data";
    }

    @Override
    protected int getDialogWidth() {
        return 400;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        Injector injectorWithGlassPane = this._injectorBuilder.with(DCGlassPane.class, (Object)this._glassPane).createInjector();
        DictionaryListPanel dictionaryListPanel = (DictionaryListPanel)injectorWithGlassPane.getInstance(DictionaryListPanel.class);
        SynonymCatalogListPanel synonymCatalogListPanel = (SynonymCatalogListPanel)injectorWithGlassPane.getInstance(SynonymCatalogListPanel.class);
        StringPatternListPanel stringPatternListPanel = (StringPatternListPanel)injectorWithGlassPane.getInstance(StringPatternListPanel.class);
        this._tabbedPane.addTab("Dictionaries", new ImageIcon(imageManager.getImage("images/model/dictionary.png", new ClassLoader[0])), this.scrolleable(dictionaryListPanel));
        this._tabbedPane.addTab("Synonyms", new ImageIcon(imageManager.getImage("images/model/synonym.png", new ClassLoader[0])), this.scrolleable(synonymCatalogListPanel));
        this._tabbedPane.addTab("String patterns", new ImageIcon(imageManager.getImage("images/model/stringpattern.png", new ClassLoader[0])), this.scrolleable(stringPatternListPanel));
        this._tabbedPane.setUnclosableTab(0);
        this._tabbedPane.setUnclosableTab(1);
        this._tabbedPane.setUnclosableTab(2);
        this.updateSelectedTab();
        this._tabbedPane.setPreferredSize(new Dimension(this.getDialogWidth(), 550));
        JButton closeButton = WidgetFactory.createButton("Close", "images/actions/save.png");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog.this.dispose();
            }
        });
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(new HumanInferenceToolbarButton());
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(closeButton);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARKEST, WidgetUtils.BG_COLOR_DARKEST);
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "Center");
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new DescriptionLabel("Reference data is used throughout DataCleaner. In this dialog you can set up your own reference data items for identifying items in dictionaries (whitelists and blacklists), synonym catalogs (usually used for replacement) and in string patterns (used for pattern matching)."), "North");
        panel.add((Component)this._tabbedPane, "Center");
        panel.add((Component)toolBarPanel, "South");
        panel.setPreferredSize(this.getDialogWidth(), 500);
        return panel;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/model/reference-data.png", new ClassLoader[0]);
    }

    @Override
    public String getWindowTitle() {
        return this.getBannerTitle();
    }
}

