/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.eobjects.analyzer.beans.api.Renderer;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.renderer.Renderable;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.ProgressInformationPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCTaskPaneContainer;
import org.eobjects.datacleaner.widgets.LoadingIcon;
import org.jdesktop.swingx.JXTaskPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultListPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResultListPanel.class);
    private final RendererFactory _rendererFactory;
    private final DCTaskPaneContainer _taskPaneContainer;
    private final ProgressInformationPanel _progressInformationPanel;

    public ResultListPanel(RendererFactory rendererFactory, ProgressInformationPanel progressInformationPanel) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._rendererFactory = rendererFactory;
        this.setLayout(new BorderLayout());
        this._taskPaneContainer = WidgetFactory.createTaskPaneContainer();
        this._progressInformationPanel = progressInformationPanel;
        this.add((Component)WidgetUtils.scrolleable((JComponent)((Object)this._taskPaneContainer)), "Center");
    }

    public void addResult(ComponentJob componentJob, final AnalyzerResult result) {
        ComponentDescriptor descriptor = componentJob.getDescriptor();
        Icon icon = IconUtils.getDescriptorIcon(descriptor, IconUtils.ICON_SIZE_LARGE);
        final String resultLabel = LabelUtils.getLabel((ComponentJob)componentJob);
        final JXTaskPane taskPane = WidgetFactory.createTaskPane(resultLabel, icon);
        final DCPanel taskPanePanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        taskPanePanel.setLayout(new BorderLayout());
        taskPane.add((Component)taskPanePanel);
        taskPanePanel.add(new LoadingIcon());
        this._progressInformationPanel.addUserLog("Rendering result for " + resultLabel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = taskPane.getTitle();
                JXTaskPane[] taskPanes = ResultListPanel.this._taskPaneContainer.getTaskPanes();
                boolean added = false;
                for (int i = 0; i < taskPanes.length; ++i) {
                    JXTaskPane existingTaskPane = taskPanes[i];
                    if (existingTaskPane.getTitle().compareTo(title) <= 0) continue;
                    ResultListPanel.this._taskPaneContainer.add(taskPane, i);
                    added = true;
                    break;
                }
                if (!added) {
                    ResultListPanel.this._taskPaneContainer.add(taskPane);
                }
            }
        });
        new SwingWorker<JComponent, Void>(){

            @Override
            protected JComponent doInBackground() throws Exception {
                Renderer renderer = ResultListPanel.this._rendererFactory.getRenderer((Renderable)result, SwingRenderingFormat.class);
                if (renderer == null) {
                    String message = "No renderer found for result type " + result.getClass().getName();
                    logger.error(message);
                    throw new IllegalStateException(message);
                }
                logger.debug("renderer.render({})", (Object)result);
                JComponent component = (JComponent)renderer.render((Renderable)result);
                if (logger.isInfoEnabled()) {
                    String resultAsString = result.toString();
                    if (resultAsString.length() > 150) {
                        resultAsString = resultAsString.substring(0, 147) + "...";
                    }
                    resultAsString = resultAsString.replaceAll("\n", " | ");
                    logger.info("renderer.render({}) returned: {}", (Object)resultAsString, (Object)component);
                }
                return component;
            }

            @Override
            protected void done() {
                taskPanePanel.removeAll();
                try {
                    JComponent component = (JComponent)this.get();
                    taskPanePanel.add(component);
                    ResultListPanel.this._progressInformationPanel.addUserLog("Result rendered for " + resultLabel);
                }
                catch (Exception e) {
                    logger.error("Error occurred while rendering result", (Throwable)e);
                    ResultListPanel.this._progressInformationPanel.addUserLog("Error occurred while rendering result", e, false);
                    taskPanePanel.add(new JLabel("An error occurred while rendering result, check the status tab"));
                }
                taskPanePanel.updateUI();
            }
        }.execute();
    }
}

