/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs2.FileObject;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.actions.ExportResultToHtmlActionListener;
import org.eobjects.datacleaner.actions.PublishResultToMonitorActionListener;
import org.eobjects.datacleaner.actions.SaveAnalysisResultActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.JobFile;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCBannerPanel;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.ProgressInformationPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.AnalysisRunnerSwingWorker;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractWindow;
import org.eobjects.datacleaner.windows.ResultListPanel;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.Ref;

public final class ResultWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final CloseableTabbedPane _tabbedPane = new CloseableTabbedPane(true);
    private final Map<Object, ResultListPanel> _resultPanels = new HashMap<Object, ResultListPanel>();
    private final AnalysisJob _job;
    private final AnalyzerBeansConfiguration _configuration;
    private final ProgressInformationPanel _progressInformationPanel;
    private final RendererFactory _rendererFactory;
    private final FileObject _jobFilename;
    private final AnalysisRunnerSwingWorker _worker;
    private final UserPreferences _userPreferences;
    private final HttpClient _httpClient;
    private AnalysisResult _result;

    @Inject
    protected ResultWindow(AnalyzerBeansConfiguration configuration, @Nullable AnalysisJob job, @Nullable AnalysisResult result, @Nullable @JobFile FileObject jobFilename, WindowContext windowContext, UserPreferences userPreferences, RendererFactory rendererFactory, HttpClient httpClient) {
        super(windowContext);
        this._configuration = configuration;
        this._job = job;
        this._jobFilename = jobFilename;
        this._userPreferences = userPreferences;
        this._rendererFactory = rendererFactory;
        this._httpClient = httpClient;
        this._progressInformationPanel = new ProgressInformationPanel();
        this._tabbedPane.addTab("Progress information", imageManager.getImageIcon("images/model/progress_information.png", new ClassLoader[0]), this._progressInformationPanel);
        this._tabbedPane.setUnclosableTab(0);
        if (result == null) {
            this._result = null;
            this._worker = new AnalysisRunnerSwingWorker(this._configuration, this._job, this, this._progressInformationPanel);
            this._progressInformationPanel.addStopActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResultWindow.this._worker.cancelIfRunning();
                }
            });
        } else {
            this._result = result;
            this._worker = null;
            Map map = result.getResultMap();
            for (Map.Entry entry : map.entrySet()) {
                ComponentJob componentJob = (ComponentJob)entry.getKey();
                AnalyzerResult analyzerResult = (AnalyzerResult)entry.getValue();
                this.addResult(componentJob, analyzerResult);
            }
            this._progressInformationPanel.onSuccess();
        }
    }

    public void setResult(AnalysisResult result) {
        this._result = result;
    }

    public void startAnalysis() {
        this._worker.execute();
    }

    private void addTableResultPanel(Table table) {
        final String name = table.getName();
        final ResultListPanel panel = new ResultListPanel(this._rendererFactory, this._progressInformationPanel);
        final ImageIcon icon = imageManager.getImageIcon("images/model/table.png", new ClassLoader[0]);
        this._resultPanels.put(table, panel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultWindow.this._tabbedPane.addTab(name, icon, panel);
                if (ResultWindow.this._tabbedPane.getTabCount() == 2) {
                    ResultWindow.this._tabbedPane.setSelectedIndex(1);
                }
            }
        });
    }

    private void addDescriptorResultPanel(ComponentDescriptor<?> descriptor) {
        final ResultListPanel panel = new ResultListPanel(this._rendererFactory, this._progressInformationPanel);
        final String name = descriptor.getDisplayName();
        final Icon icon = IconUtils.getDescriptorIcon(descriptor);
        this._resultPanels.put(descriptor, panel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultWindow.this._tabbedPane.addTab(name, icon, panel);
                if (ResultWindow.this._tabbedPane.getTabCount() == 2) {
                    ResultWindow.this._tabbedPane.setSelectedIndex(1);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultListPanel getDescriptorResultPanel(ComponentDescriptor<?> descriptor) {
        Map<Object, ResultListPanel> map = this._resultPanels;
        synchronized (map) {
            if (!this._resultPanels.containsKey(descriptor)) {
                this.addDescriptorResultPanel(descriptor);
            }
            return this._resultPanels.get(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultListPanel getTableResultPanel(Table table) {
        Map<Object, ResultListPanel> map = this._resultPanels;
        synchronized (map) {
            if (!this._resultPanels.containsKey(table)) {
                this.addTableResultPanel(table);
            }
            return this._resultPanels.get(table);
        }
    }

    public void addResult(ComponentJob componentJob, AnalyzerResult result) {
        ComponentDescriptor descriptor = componentJob.getDescriptor();
        ResultListPanel resultListPanel = this.getDescriptorResultPanel(descriptor);
        resultListPanel.addResult(componentJob, result);
    }

    public void addResult(Table table, ComponentJob componentJob, AnalyzerResult result) {
        ResultListPanel resultListPanel = this.getTableResultPanel(table);
        resultListPanel.addResult(componentJob, result);
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        String title = "Analysis results";
        String datastoreName = this.getDatastoreName();
        if (!StringUtils.isNullOrEmpty((String)datastoreName)) {
            title = datastoreName + " | " + title;
        }
        if (this._jobFilename != null) {
            title = this._jobFilename.getName().getBaseName() + " | " + title;
        }
        return title;
    }

    private String getDatastoreName() {
        String datastoreName;
        Datastore datastore;
        if (this._job != null && (datastore = this._job.getDatastore()) != null && !StringUtils.isNullOrEmpty((String)(datastoreName = datastore.getName()))) {
            return datastoreName;
        }
        return null;
    }

    @Override
    public Image getWindowIcon() {
        return imageManager.getImage("images/model/result.png", new ClassLoader[0]);
    }

    @Override
    protected boolean onWindowClosing() {
        boolean closing = super.onWindowClosing();
        if (closing && this._worker != null) {
            this._worker.cancelIfRunning();
        }
        return closing;
    }

    @Override
    protected JComponent getWindowContent() {
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        String bannerTitle = "Analysis results";
        String datastoreName = this.getDatastoreName();
        if (!StringUtils.isNullOrEmpty((String)datastoreName)) {
            bannerTitle = bannerTitle + " | " + datastoreName;
            if (this._jobFilename != null) {
                bannerTitle = bannerTitle + " | " + this._jobFilename.getName().getBaseName();
            }
        }
        DCBannerPanel banner = new DCBannerPanel(imageManager.getImage("images/window/banner-results.png", new ClassLoader[0]), bannerTitle);
        banner.setLayout(null);
        this._tabbedPane.bindTabTitleToBanner(banner);
        Ref<AnalysisResult> resultRef = new Ref<AnalysisResult>(){

            public AnalysisResult get() {
                return ResultWindow.this._result;
            }
        };
        JButton saveButton = new JButton("Save result", imageManager.getImageIcon("images/actions/save.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
        saveButton.setOpaque(false);
        saveButton.addActionListener(new SaveAnalysisResultActionListener(resultRef, this._userPreferences));
        JButton exportButton = new JButton("Export to HTML", imageManager.getImageIcon("images/actions/website.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
        exportButton.setOpaque(false);
        exportButton.addActionListener(new ExportResultToHtmlActionListener(resultRef, this._configuration, this._userPreferences));
        JButton publishButton = new JButton("Publish to dq monitor", imageManager.getImageIcon("images/menu/dq_monitor.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
        if (this._jobFilename == null) {
            publishButton.setEnabled(false);
        } else {
            publishButton.setOpaque(false);
            publishButton.addActionListener(new PublishResultToMonitorActionListener(this.getWindowContext(), this._userPreferences, resultRef, this._httpClient, this._jobFilename));
        }
        FlowLayout layout = new FlowLayout(Alignment.RIGHT.getFlowLayoutAlignment(), 4, 36);
        layout.setAlignOnBaseline(true);
        banner.setLayout(layout);
        banner.add(publishButton);
        banner.add(exportButton);
        banner.add(saveButton);
        banner.add(Box.createHorizontalStrut(10));
        panel.add((Component)banner, "North");
        panel.add((Component)this._tabbedPane, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        int height = 550;
        if (screenHeight > 1000) {
            height = 900;
        } else if (screenHeight > 750) {
            height = 700;
        }
        int width = 750;
        if (screenWidth > 1200) {
            width = 1100;
        } else if (screenWidth > 1000) {
            width = 900;
        }
        panel.setPreferredSize(width, height);
        return panel;
    }
}

