/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JComponent;
import org.eobjects.analyzer.connection.SasDatastore;
import org.eobjects.analyzer.util.ImmutableEntry;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;
import org.eobjects.sassy.SasFilenameFilter;

public final class SasDatastoreDialog
extends AbstractFileBasedDatastoreDialog<SasDatastore> {
    private static final long serialVersionUID = 1L;
    private final DCLabel _tableCountLabel = DCLabel.bright("");

    @Inject
    protected SasDatastoreDialog(@Nullable SasDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
        if (originalDatastore != null) {
            this.onFileSelected(new File(originalDatastore.getFilename()));
        }
    }

    @Override
    protected void onFileSelected(File file) {
        if (file.exists() && file.isDirectory()) {
            String[] files = file.list((FilenameFilter)new SasFilenameFilter());
            this._tableCountLabel.setText("Directory contains " + files.length + " SAS table(s).");
            if (files.length == 0) {
                this.setStatusWarning("No SAS tables in directory");
            } else {
                this.setStatusValid();
            }
        } else {
            this.setStatusWarning("Please select a valid directory");
        }
    }

    @Override
    protected List<Map.Entry<String, JComponent>> getFormElements() {
        List<Map.Entry<String, JComponent>> result = super.getFormElements();
        result.add((Map.Entry<String, JComponent>)new ImmutableEntry((Object)"Tables", (Object)this._tableCountLabel));
        return result;
    }

    @Override
    protected String getBannerTitle() {
        return "SAS library";
    }

    @Override
    public String getWindowTitle() {
        return "SAS library | Datastore";
    }

    @Override
    protected SasDatastore createDatastore(String name, String filename) {
        return new SasDatastore(name, new File(filename));
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/sas.png";
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
    }

    @Override
    protected boolean isDirectoryBased() {
        return true;
    }
}

