/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.SimpleDictionary;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXTextArea;
import org.jdesktop.swingx.JXTextField;

public final class SimpleDictionaryDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final SimpleDictionary _originalDictionary;
    private final MutableReferenceDataCatalog _catalog;
    private final JXTextField _nameTextField;
    private final JXTextArea _valuesTextArea;

    @Inject
    protected SimpleDictionaryDialog(@Nullable SimpleDictionary dictionary, MutableReferenceDataCatalog catalog, WindowContext windowContext) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-dictionaries.png", new ClassLoader[0]));
        this._originalDictionary = dictionary;
        this._catalog = catalog;
        this._nameTextField = WidgetFactory.createTextField("Dictionary name");
        this._valuesTextArea = WidgetFactory.createTextArea("Values");
        this._valuesTextArea.setRows(14);
        if (dictionary != null) {
            this._nameTextField.setText(dictionary.getName());
            Collection values = dictionary.getValues().getValues();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    sb.append('\n');
                }
                sb.append(value);
            }
            this._valuesTextArea.setText(sb.toString());
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Simple dictionary";
    }

    @Override
    protected int getDialogWidth() {
        return 400;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Dictionary name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Values:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(WidgetUtils.scrolleable((JComponent)this._valuesTextArea), formPanel, 1, row);
        JButton createDictionaryButton = WidgetFactory.createButton("Save dictionary", "images/model/dictionary.png");
        createDictionaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = SimpleDictionaryDialog.this._nameTextField.getText();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    JOptionPane.showMessageDialog(SimpleDictionaryDialog.this, "Please fill out the name of the dictionary");
                    return;
                }
                String values = SimpleDictionaryDialog.this._valuesTextArea.getText();
                if (StringUtils.isNullOrEmpty((String)values)) {
                    JOptionPane.showMessageDialog(SimpleDictionaryDialog.this, "Please fill out the values");
                    return;
                }
                SimpleDictionary dict = new SimpleDictionary(name, values.split("\n"));
                if (SimpleDictionaryDialog.this._originalDictionary != null) {
                    SimpleDictionaryDialog.this._catalog.removeDictionary((Dictionary)SimpleDictionaryDialog.this._originalDictionary);
                }
                SimpleDictionaryDialog.this._catalog.addDictionary((Dictionary)dict);
                SimpleDictionaryDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 4));
        buttonPanel.add(createDictionaryButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel("A simple dictionary is a dictionary that you enter directly in DataCleaner. In the 'Values' field you can enter each value of the dictionary on a separate line.");
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)descriptionLabel, "North");
        mainPanel.add((Component)formPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.setPreferredSize(this.getDialogWidth(), 400);
        return mainPanel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Simple dictionary";
    }
}

