/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eobjects.analyzer.reference.SimpleStringPattern;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXTextField;

public final class SimpleStringPatternDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final MutableReferenceDataCatalog _catalog;
    private final JXTextField _expressionField;
    private final JXTextField _expressionNameField;
    private List<JTextField> _inputFields;
    private String _expressionString;
    private String _expressionNameString;
    private List<JLabel> _statusLabels;
    private JLabel _errorLabel;
    private static final int NUM_TEST_FIELDS = 6;
    private JButton _resetButton;
    final JButton _saveButton;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private StringPattern _simpleStringPattern;
    private static final Icon ICON_ERROR = imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
    private static final Icon ICON_SUCCESS = imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);

    public SimpleStringPatternDialog(MutableReferenceDataCatalog catalog, WindowContext windowContext) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-string-patterns.png", new ClassLoader[0]));
        this._catalog = catalog;
        this._expressionNameField = WidgetFactory.createTextField("String pattern name");
        this._expressionField = WidgetFactory.createTextField("Expression");
        this._resetButton = WidgetFactory.createButton("Reset");
        this._saveButton = WidgetFactory.createButton("Save Pattern", "images/model/stringpattern_simple.png");
    }

    public SimpleStringPatternDialog(SimpleStringPattern stringPattern, MutableReferenceDataCatalog catalog, WindowContext windowContext) {
        this(stringPattern.getName(), stringPattern.getExpression(), catalog, windowContext);
    }

    public SimpleStringPatternDialog(String expressionName, String expression, MutableReferenceDataCatalog catalog, WindowContext windowContext) {
        this(catalog, windowContext);
        this._expressionString = expression;
        this._expressionNameString = expressionName;
        this._expressionNameField.setText(expressionName);
        this._expressionField.setText(expression);
        if (!this._catalog.isStringPatternMutable(this._expressionNameString)) {
            this._expressionField.setEnabled(false);
            this._expressionNameField.setEnabled(false);
            this._resetButton.setEnabled(false);
            this._saveButton.setEnabled(false);
        }
        this._simpleStringPattern = this._catalog.getStringPattern(this._expressionNameString);
    }

    @Override
    protected String getBannerTitle() {
        return "Simple string pattern";
    }

    @Override
    protected int getDialogWidth() {
        return 465;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("String pattern name"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._expressionNameField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Expression"), formPanel, 0, ++row);
        this._expressionField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SimpleStringPatternDialog.this.checkInputFields();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SimpleStringPatternDialog.this.checkInputFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SimpleStringPatternDialog.this.checkInputFields();
            }
        });
        WidgetUtils.addToGridBag((Component)this._expressionField, formPanel, 1, row);
        this._resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleStringPatternDialog.this._expressionField.setText(SimpleStringPatternDialog.this._expressionString);
            }
        });
        WidgetUtils.addToGridBag(this._resetButton, formPanel, 2, row);
        ++row;
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String expressionName = SimpleStringPatternDialog.this._expressionNameField.getText();
                if (StringUtils.isNullOrEmpty((String)expressionName)) {
                    JOptionPane.showMessageDialog(SimpleStringPatternDialog.this, "Please fill out the name of the string expression");
                    return;
                }
                String expression = SimpleStringPatternDialog.this._expressionField.getText();
                if (StringUtils.isNullOrEmpty((String)expression)) {
                    JOptionPane.showMessageDialog(SimpleStringPatternDialog.this, "Please fill out the string expression");
                    return;
                }
                if (SimpleStringPatternDialog.this._simpleStringPattern != null && SimpleStringPatternDialog.this._catalog.containsStringPattern(SimpleStringPatternDialog.this._simpleStringPattern.getName())) {
                    SimpleStringPatternDialog.this._catalog.removeStringPattern(SimpleStringPatternDialog.this._catalog.getStringPattern(SimpleStringPatternDialog.this._simpleStringPattern.getName()));
                }
                SimpleStringPattern simpleStringPattern = new SimpleStringPattern(expressionName, expression);
                SimpleStringPatternDialog.this._simpleStringPattern = (StringPattern)simpleStringPattern;
                SimpleStringPatternDialog.this._catalog.addStringPattern((StringPattern)simpleStringPattern);
                SimpleStringPatternDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.add(this._saveButton);
        WidgetUtils.addToGridBag((Component)buttonPanel, (JPanel)formPanel, 0, row, 2, 1);
        DCPanel testitPanel = new DCPanel();
        testitPanel.setLayout(new FlowLayout(2, 0, 0));
        this._errorLabel = DCLabel.bright("");
        WidgetUtils.addToGridBag(this._errorLabel, testitPanel, 0, row);
        DCLabel testInputLabel = DCLabel.bright("Test input");
        testInputLabel.setIcon(imageManager.getImageIcon("images/actions/test-pattern.png", new ClassLoader[0]));
        testInputLabel.setFont(WidgetUtils.FONT_HEADER1);
        WidgetUtils.addToGridBag(testInputLabel, testitPanel, 0, ++row);
        this._inputFields = new ArrayList<JTextField>(6);
        this._statusLabels = new ArrayList<JLabel>(6);
        for (int i = 0; i < 6; ++i) {
            final int index = i;
            JXTextField inputField = WidgetFactory.createTextField("Test Input");
            inputField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SimpleStringPatternDialog.this.checkInputField(index);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SimpleStringPatternDialog.this.checkInputField(index);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SimpleStringPatternDialog.this.checkInputField(index);
                }
            });
            WidgetUtils.addToGridBag((Component)inputField, testitPanel, 0, 4 + i);
            JLabel statusLabel = new JLabel();
            WidgetUtils.addToGridBag(statusLabel, testitPanel, 1, 4 + i);
            this._inputFields.add((JTextField)inputField);
            this._statusLabels.add(statusLabel);
        }
        DescriptionLabel descriptionLabel = new DescriptionLabel("<p>Simple string patterns are tokenized patterns made up of these elements.</p><p>* A = upper case letters<br>* a = lower case letters<br>* 9 = digits</p>");
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)descriptionLabel, "North");
        mainPanel.add((Component)formPanel, "Center");
        mainPanel.add((Component)testitPanel, "South");
        mainPanel.setPreferredSize(this.getDialogWidth(), 400);
        return mainPanel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Simple string pattern";
    }

    private void checkInputFields() {
        this._errorLabel.setText("");
        for (int i = 0; i < 6; ++i) {
            this.checkInputField(i);
        }
    }

    private void checkInputField(int index) {
        String text = this._inputFields.get(index).getText();
        JLabel label = this._statusLabels.get(index);
        if ("".equals(text)) {
            label.setIcon(null);
        } else {
            this._simpleStringPattern = new SimpleStringPattern(this._expressionNameField.getText(), this._expressionField.getText());
            if (this._simpleStringPattern.matches(text)) {
                label.setIcon(ICON_SUCCESS);
            } else {
                label.setIcon(ICON_ERROR);
            }
        }
    }
}

