/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.SimpleTableDefsPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.SchemaFactory;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.SimpleTableDef;

public class TableDefinitionDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final SimpleTableDefsPanel _tableDefsPanel;
    private final Action<SimpleTableDef[]> _saveAction;

    public TableDefinitionDialog(WindowContext windowContext, SchemaFactory schemaFactory, SimpleTableDef[] tableDefs, Action<SimpleTableDef[]> saveAction) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-tabledef.png", new ClassLoader[0]));
        this._tableDefsPanel = new SimpleTableDefsPanel(schemaFactory, tableDefs);
        this._saveAction = saveAction;
    }

    @Override
    public String getWindowTitle() {
        return "Define tables";
    }

    @Override
    protected String getBannerTitle() {
        return "Define tables";
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._tableDefsPanel, "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        panel.setPreferredSize(this.getDialogWidth(), 400);
        return panel;
    }

    private DCPanel createButtonPanel() {
        JButton saveButton = WidgetFactory.createButton("Save table definitions", "images/actions/save.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleTableDef[] tableDefs = TableDefinitionDialog.this._tableDefsPanel.getTableDefs();
                try {
                    TableDefinitionDialog.this._saveAction.run((Object)tableDefs);
                }
                catch (Exception e) {
                    WidgetUtils.showErrorMessage("Could not save table definitions", e);
                }
                TableDefinitionDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 0));
        buttonPanel.add(saveButton);
        return buttonPanel;
    }
}

