/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.TextFileDictionary;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CharSetEncodingComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXTextField;

public final class TextFileDictionaryDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final UserPreferences _userPreferences;
    private final TextFileDictionary _originalDictionary;
    private final MutableReferenceDataCatalog _catalog;
    private final JXTextField _nameTextField;
    private final FilenameTextField _filenameTextField;
    private final JComboBox _encodingComboBox;
    private volatile boolean _nameAutomaticallySet = true;

    @Inject
    protected TextFileDictionaryDialog(@Nullable TextFileDictionary dictionary, MutableReferenceDataCatalog catalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-dictionaries.png", new ClassLoader[0]));
        this._originalDictionary = dictionary;
        this._catalog = catalog;
        this._userPreferences = userPreferences;
        this._nameTextField = WidgetFactory.createTextField("Dictionary name");
        this._nameTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                TextFileDictionaryDialog.this._nameAutomaticallySet = false;
            }
        });
        this._filenameTextField = new FilenameTextField(this._userPreferences.getOpenDatastoreDirectory(), true);
        this._filenameTextField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                if (TextFileDictionaryDialog.this._nameAutomaticallySet || StringUtils.isNullOrEmpty((String)TextFileDictionaryDialog.this._nameTextField.getText())) {
                    TextFileDictionaryDialog.this._nameTextField.setText(file.getName());
                    TextFileDictionaryDialog.this._nameAutomaticallySet = true;
                }
                File dir = file.getParentFile();
                TextFileDictionaryDialog.this._userPreferences.setOpenDatastoreDirectory(dir);
            }
        });
        this._encodingComboBox = new CharSetEncodingComboBox();
        if (dictionary != null) {
            this._nameTextField.setText(dictionary.getName());
            this._filenameTextField.setFilename(dictionary.getFilename());
            this._encodingComboBox.setSelectedItem(dictionary.getEncoding());
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Text file dictionary";
    }

    @Override
    protected int getDialogWidth() {
        return 450;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Dictionary name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Filename:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._filenameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Character encoding:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._encodingComboBox, formPanel, 1, row);
        ++row;
        JButton saveButton = WidgetFactory.createButton("Save dictionary", "images/model/dictionary.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = TextFileDictionaryDialog.this._nameTextField.getText();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    JOptionPane.showMessageDialog(TextFileDictionaryDialog.this, "Please fill out the name of the dictionary");
                    return;
                }
                String filename = TextFileDictionaryDialog.this._filenameTextField.getFilename();
                if (StringUtils.isNullOrEmpty((String)filename)) {
                    JOptionPane.showMessageDialog(TextFileDictionaryDialog.this, "Please fill out the filename or select a file using the 'Browse' button");
                    return;
                }
                String encoding = (String)TextFileDictionaryDialog.this._encodingComboBox.getSelectedItem();
                if (StringUtils.isNullOrEmpty((String)filename)) {
                    JOptionPane.showMessageDialog(TextFileDictionaryDialog.this, "Please select a character encoding");
                    return;
                }
                TextFileDictionary dict = new TextFileDictionary(name, filename, encoding);
                if (TextFileDictionaryDialog.this._originalDictionary != null) {
                    TextFileDictionaryDialog.this._catalog.removeDictionary((Dictionary)TextFileDictionaryDialog.this._originalDictionary);
                }
                TextFileDictionaryDialog.this._catalog.addDictionary((Dictionary)dict);
                TextFileDictionaryDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 4));
        buttonPanel.add(saveButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel("A text file dictionary is a dictionary based on a text file containing values separated by linebreaks.");
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)descriptionLabel, "North");
        mainPanel.add((Component)formPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.setPreferredSize(this.getDialogWidth(), 230);
        return mainPanel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Text file dictionary";
    }
}

