/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.reference.TextFileSynonymCatalog;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CharSetEncodingComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DescriptionLabel;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXTextField;

public final class TextFileSynonymCatalogDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private final UserPreferences _userPreferences;
    private final TextFileSynonymCatalog _originalsynonymCatalog;
    private final MutableReferenceDataCatalog _catalog;
    private final JXTextField _nameTextField;
    private final JCheckBox _caseSensitiveCheckBox;
    private final FilenameTextField _filenameTextField;
    private final JComboBox _encodingComboBox;
    private volatile boolean _nameAutomaticallySet = true;

    @Inject
    protected TextFileSynonymCatalogDialog(@Nullable TextFileSynonymCatalog synonymCatalog, MutableReferenceDataCatalog catalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(windowContext, ImageManager.getInstance().getImage("images/window/banner-synonym-catalog.png", new ClassLoader[0]));
        this._userPreferences = userPreferences;
        this._originalsynonymCatalog = synonymCatalog;
        this._catalog = catalog;
        this._nameTextField = WidgetFactory.createTextField("Synonym catalog name");
        this._nameTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                TextFileSynonymCatalogDialog.this._nameAutomaticallySet = false;
            }
        });
        this._filenameTextField = new FilenameTextField(this._userPreferences.getOpenDatastoreDirectory(), true);
        this._filenameTextField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                if (TextFileSynonymCatalogDialog.this._nameAutomaticallySet || StringUtils.isNullOrEmpty((String)TextFileSynonymCatalogDialog.this._nameTextField.getText())) {
                    TextFileSynonymCatalogDialog.this._nameTextField.setText(file.getName());
                    TextFileSynonymCatalogDialog.this._nameAutomaticallySet = true;
                }
                File dir = file.getParentFile();
                TextFileSynonymCatalogDialog.this._userPreferences.setOpenDatastoreDirectory(dir);
            }
        });
        this._caseSensitiveCheckBox = new JCheckBox();
        this._caseSensitiveCheckBox.setOpaque(false);
        this._caseSensitiveCheckBox.setSelected(false);
        this._encodingComboBox = new CharSetEncodingComboBox();
        if (synonymCatalog != null) {
            this._nameTextField.setText(synonymCatalog.getName());
            this._filenameTextField.setFilename(synonymCatalog.getFilename());
            this._encodingComboBox.setSelectedItem(synonymCatalog.getEncoding());
            this._caseSensitiveCheckBox.setSelected(synonymCatalog.isCaseSensitive());
        }
    }

    @Override
    protected String getBannerTitle() {
        return "Text file\nsynonym catalog";
    }

    @Override
    protected int getDialogWidth() {
        return 465;
    }

    @Override
    protected JComponent getDialogContent() {
        DCPanel formPanel = new DCPanel();
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.bright("Synonym catalog name:"), formPanel, 0, row);
        WidgetUtils.addToGridBag((Component)this._nameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Filename:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._filenameTextField, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Case sensitive matches:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._caseSensitiveCheckBox, formPanel, 1, row);
        WidgetUtils.addToGridBag(DCLabel.bright("Character encoding:"), formPanel, 0, ++row);
        WidgetUtils.addToGridBag(this._encodingComboBox, formPanel, 1, row);
        ++row;
        JButton saveButton = WidgetFactory.createButton("Save synonym catalog", "images/model/synonym.png");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = TextFileSynonymCatalogDialog.this._nameTextField.getText();
                if (StringUtils.isNullOrEmpty((String)name)) {
                    JOptionPane.showMessageDialog(TextFileSynonymCatalogDialog.this, "Please fill out the name of the synonym catalog");
                    return;
                }
                String filename = TextFileSynonymCatalogDialog.this._filenameTextField.getFilename();
                if (StringUtils.isNullOrEmpty((String)filename)) {
                    JOptionPane.showMessageDialog(TextFileSynonymCatalogDialog.this, "Please fill out the filename or select a file using the 'Browse' button");
                    return;
                }
                String encoding = (String)TextFileSynonymCatalogDialog.this._encodingComboBox.getSelectedItem();
                if (StringUtils.isNullOrEmpty((String)filename)) {
                    JOptionPane.showMessageDialog(TextFileSynonymCatalogDialog.this, "Please select a character encoding");
                    return;
                }
                TextFileSynonymCatalog sc = new TextFileSynonymCatalog(name, filename, TextFileSynonymCatalogDialog.this._caseSensitiveCheckBox.isSelected(), encoding);
                if (TextFileSynonymCatalogDialog.this._originalsynonymCatalog != null) {
                    TextFileSynonymCatalogDialog.this._catalog.removeSynonymCatalog((SynonymCatalog)TextFileSynonymCatalogDialog.this._originalsynonymCatalog);
                }
                TextFileSynonymCatalogDialog.this._catalog.addSynonymCatalog((SynonymCatalog)sc);
                TextFileSynonymCatalogDialog.this.dispose();
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 4));
        buttonPanel.add(saveButton);
        DescriptionLabel descriptionLabel = new DescriptionLabel("A text file synonym catalog is a synonym catalog based on a text file containing comma separated values where the first column represents the master term.");
        DCPanel mainPanel = new DCPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)descriptionLabel, "North");
        mainPanel.add((Component)formPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        mainPanel.setPreferredSize(this.getDialogWidth(), 230);
        return mainPanel;
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Text file synonym catalog";
    }
}

