/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.visualization.VisualizeJobGraph;
import org.eobjects.datacleaner.windows.AbstractWindow;

public class VisualizeJobWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final JScrollPane _scroll;
    private volatile boolean _displayColumns;
    private volatile boolean _displayOutcomes;

    public VisualizeJobWindow(AnalysisJobBuilder analysisJobBuilder, WindowContext windowContext) {
        super(windowContext);
        this._analysisJobBuilder = analysisJobBuilder;
        this._displayColumns = this.isDefaultDisplayColumns(analysisJobBuilder);
        this._displayOutcomes = true;
        this._scroll = WidgetUtils.scrolleable(null);
        this._scroll.setHorizontalScrollBarPolicy(30);
        this._scroll.setVerticalScrollBarPolicy(20);
        this.refreshGraph();
    }

    private boolean isDefaultDisplayColumns(AnalysisJobBuilder analysisJobBuilder) {
        int columnsTotal = analysisJobBuilder.getAvailableInputColumns(Object.class).size();
        return columnsTotal <= 10;
    }

    public void refreshGraph() {
        JComponent visualization = VisualizeJobGraph.create(this._analysisJobBuilder, this._displayColumns, this._displayOutcomes);
        this._scroll.setViewportView(visualization);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected void onWindowVisible() {
        super.onWindowVisible();
        boolean horizontalShowing = this._scroll.getHorizontalScrollBar().isShowing();
        boolean verticalShowing = this._scroll.getVerticalScrollBar().isShowing();
        if (horizontalShowing || verticalShowing) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }

    @Override
    protected boolean isCentered() {
        return true;
    }

    @Override
    public String getWindowTitle() {
        return "Visualize job";
    }

    @Override
    public Image getWindowIcon() {
        return this.imageManager.getImage("images/actions/visualize.png", new ClassLoader[0]);
    }

    @Override
    protected JComponent getWindowContent() {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._scroll, "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JComponent createButtonPanel() {
        final JCheckBox displayColumnsCheckBox = new JCheckBox("Display columns?");
        displayColumnsCheckBox.setOpaque(false);
        displayColumnsCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        displayColumnsCheckBox.setSelected(this._displayColumns);
        displayColumnsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizeJobWindow.this._displayColumns = displayColumnsCheckBox.isSelected();
                VisualizeJobWindow.this.refreshGraph();
            }
        });
        final JCheckBox displayFilterOutcomesCheckBox = new JCheckBox("Display filter outcomes?");
        displayFilterOutcomesCheckBox.setOpaque(false);
        displayFilterOutcomesCheckBox.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        displayFilterOutcomesCheckBox.setSelected(this._displayOutcomes);
        displayFilterOutcomesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizeJobWindow.this._displayOutcomes = displayFilterOutcomesCheckBox.isSelected();
                VisualizeJobWindow.this.refreshGraph();
            }
        });
        DCPanel buttonPanel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        buttonPanel.setLayout(new FlowLayout(0, 4, 10));
        buttonPanel.setBorder(new MatteBorder(1, 0, 0, 0, WidgetUtils.BG_COLOR_MEDIUM));
        buttonPanel.add(new JLabel(this.imageManager.getImageIcon("images/model/column.png", new ClassLoader[0])));
        buttonPanel.add(displayColumnsCheckBox);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(new JLabel(this.imageManager.getImageIcon("images/component-types/filter-outcome.png", new ClassLoader[0])));
        buttonPanel.add(displayFilterOutcomesCheckBox);
        return buttonPanel;
    }
}

