/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.jdesktop.swingx.action.OpenBrowserAction;

public class WelcomeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public WelcomeDialog(AnalysisJobBuilderWindow window, Image welcomeImage) {
        super((Window)((Object)window), "Welcome to DataCleaner");
        JLabel banner = new JLabel(new ImageIcon(welcomeImage));
        banner.setPreferredSize(new Dimension(welcomeImage.getWidth(this), welcomeImage.getHeight(this)));
        DCPanel shadowedBanner = WidgetUtils.decorateWithShadow(banner, true, 5);
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_LESS_BRIGHT, WidgetUtils.BG_COLOR_BRIGHT);
        panel.setLayout(new BorderLayout());
        panel.add((Component)shadowedBanner, "Center");
        ImageManager imageManager = ImageManager.getInstance();
        JButton closeButton = new JButton("Continue", imageManager.getImageIcon("images/actions/execute.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WelcomeDialog.this.setVisible(false);
            }
        });
        JButton websiteButton = new JButton("Visit the DataCleaner website", imageManager.getImageIcon("images/actions/website.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
        websiteButton.addActionListener((ActionListener)new OpenBrowserAction("http://datacleaner.org"));
        panel.add((Component)DCPanel.flow(Alignment.RIGHT, 10, 10, websiteButton, closeButton), "South");
        this.getContentPane().add(panel);
        this.pack();
        this.setResizable(false);
        WidgetUtils.centerOnScreen(this);
        this.setModal(true);
    }
}

