/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.windows;

import javax.inject.Inject;
import org.eobjects.analyzer.connection.XmlDatastore;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.windows.AbstractFileBasedDatastoreDialog;

public final class XmlDatastoreDialog
extends AbstractFileBasedDatastoreDialog<XmlDatastore> {
    private static final long serialVersionUID = 1L;

    @Inject
    protected XmlDatastoreDialog(@Nullable XmlDatastore originalDatastore, MutableDatastoreCatalog mutableDatastoreCatalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(originalDatastore, mutableDatastoreCatalog, windowContext, userPreferences);
    }

    @Override
    protected void setFileFilters(FilenameTextField filenameField) {
        filenameField.addChoosableFileFilter(FileFilters.XML);
        filenameField.addChoosableFileFilter(FileFilters.ALL);
        filenameField.setSelectedFileFilter(FileFilters.XML);
    }

    @Override
    protected String getBannerTitle() {
        return "XML file";
    }

    @Override
    public String getWindowTitle() {
        return "XML file | Datastore";
    }

    @Override
    protected XmlDatastore createDatastore(String name, String filename) {
        return new XmlDatastore(name, filename);
    }

    @Override
    protected String getDatastoreIconPath() {
        return "images/datastore-types/xml.png";
    }
}

