/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.datastructures;

import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.metamodel.util.CollectionUtils;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DataStructuresCategory;

@Named(value="Select values from key/value map")
@Description(value="Given a specified list of keys, this transformer will select the values from a key/value map and place them as columns within the record")
@Categorized(value={DataStructuresCategory.class})
public class SelectFromMapTransformer
implements Transformer {
    private static final String PROPERTY_KEYS = "Keys";
    @Inject
    @Configured
    InputColumn<Map<String, ?>> mapColumn;
    @Inject
    @Configured(value="Keys")
    String[] keys;
    @Inject
    @Configured
    @MappedProperty(value="Keys")
    Class<?>[] types;
    @Inject
    @Configured
    @Description(value="Verify that expected type and actual type are the same")
    boolean verifyTypes = false;

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setTypes(Class<?>[] types) {
        this.types = types;
    }

    public void setMapColumn(InputColumn<Map<String, ?>> mapColumn) {
        this.mapColumn = mapColumn;
    }

    public void setVerifyTypes(boolean verifyTypes) {
        this.verifyTypes = verifyTypes;
    }

    public OutputColumns getOutputColumns() {
        String[] keys = this.keys;
        Class[] types = this.types;
        if (keys.length != types.length) {
            int length = Math.min(keys.length, types.length);
            keys = Arrays.copyOf(keys, length);
            types = Arrays.copyOf(types, length);
        }
        return new OutputColumns(keys, types);
    }

    public Object[] transform(InputRow row) {
        Map map = (Map)row.getValue(this.mapColumn);
        Object[] result = new Object[this.keys.length];
        if (map == null) {
            return result;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object value = SelectFromMapTransformer.find(map, this.keys[i]);
            if (this.verifyTypes) {
                value = this.types[i].cast(value);
            }
            result[i] = value;
        }
        return result;
    }

    public static Object find(Map<String, ?> map, String key) {
        return CollectionUtils.find(map, (String)key);
    }
}

