/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.datastructures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DataStructuresCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="Build list")
@Description(value="Build a list containing a variable amount of elements. Adds the capability to save multiple values in a single field.")
@Categorized(value={DataStructuresCategory.class})
public class BuildListTransformer
implements Transformer {
    private static final Logger logger = LoggerFactory.getLogger(BuildListTransformer.class);
    @Inject
    @Configured
    InputColumn<?>[] values;
    @Inject
    @Configured
    boolean includeNullValues;
    @Inject
    @Configured(required=false)
    @Description(value="Add elements to this (optional) existing list")
    InputColumn<List<Object>> addToExistingList;

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public void setValues(InputColumn<?>[] values) {
        this.values = values;
    }

    public OutputColumns getOutputColumns() {
        StringBuilder sb = new StringBuilder("List: ");
        for (int i = 0; i < this.values.length; ++i) {
            String key = this.values[i].getName();
            sb.append(key);
            if (sb.length() > 30) {
                sb.append("...");
                break;
            }
            if (i + 1 >= this.values.length) continue;
            sb.append(",");
        }
        return new OutputColumns(new String[]{sb.toString()}, new Class[]{List.class});
    }

    public List<?>[] transform(InputRow row) {
        List existingList = this.addToExistingList != null ? (List)row.getValue(this.addToExistingList) : Collections.emptyList();
        ArrayList<Object> list = new ArrayList<Object>(existingList);
        for (InputColumn<?> column : this.values) {
            Object value = row.getValue(column);
            if (!this.includeNullValues && value == null) {
                logger.debug("Ignoring null value for {} in row: {}", (Object)column.getName(), (Object)row);
                continue;
            }
            list.add(value);
        }
        return new List[]{list};
    }
}

