/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DataStructuresCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="Build key/value map")
@Alias(value={"Build map"})
@Description(value="Build a map with a variable amount of keys and values. Adds the capability to store complex structures with named entries within it.")
@Categorized(value={DataStructuresCategory.class})
public class BuildMapTransformer
implements Transformer {
    private static final Logger logger = LoggerFactory.getLogger(BuildMapTransformer.class);
    private static final String PROPERTY_VALUES = "Values";
    @Inject
    @Configured(value="Values")
    InputColumn<?>[] values;
    @Inject
    @Configured
    @MappedProperty(value="Values")
    String[] keys;
    @Inject
    @Configured
    boolean retainKeyOrder = false;
    @Inject
    @Configured
    boolean includeNullValues = false;
    @Inject
    @Configured(required=false)
    @Description(value="Add key/value pairs to this (optional) existing map")
    InputColumn<Map<String, Object>> addToExistingMap;

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setRetainKeyOrder(boolean retainKeyOrder) {
        this.retainKeyOrder = retainKeyOrder;
    }

    public void setValues(InputColumn<?>[] values) {
        this.values = values;
    }

    public OutputColumns getOutputColumns() {
        StringBuilder sb = new StringBuilder("Map: ");
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            sb.append(key);
            if (sb.length() > 30) {
                sb.append("...");
                break;
            }
            if (i + 1 >= this.keys.length) continue;
            sb.append(",");
        }
        return new OutputColumns(new String[]{sb.toString()}, new Class[]{Map.class});
    }

    public Map<String, ?>[] transform(InputRow row) {
        Map existingMap = this.addToExistingMap != null ? (Map)row.getValue(this.addToExistingMap) : Collections.emptyMap();
        HashMap map = this.retainKeyOrder ? new LinkedHashMap(existingMap) : new HashMap(existingMap);
        for (int i = 0; i < this.keys.length; ++i) {
            String key = this.keys[i];
            Object value = row.getValue(this.values[i]);
            if (value == null && !this.includeNullValues) {
                logger.debug("Ignoring null value for {} in row: {}", (Object)key, (Object)row);
                continue;
            }
            map.put(key, value);
        }
        Map[] result = new Map[]{map};
        return result;
    }
}

