/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.datastructures;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Provided;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DataStructuresCategory;

@Named(value="Read keys and values from map")
@Description(value="Reads all key/value pairs of a map, creating a record for each pair")
@Categorized(value={DataStructuresCategory.class})
public class ReadFromMapTransformer
implements Transformer {
    @Inject
    @Configured
    InputColumn<Map<String, ?>> mapColumn;
    @Inject
    @Configured
    @Description(value="Expected type of the values")
    Class<?> valueType;
    @Inject
    @Configured
    @Description(value="Verify that expected value type and actual type are the same")
    boolean verifyTypes = false;
    @Inject
    @Provided
    OutputRowCollector outputRowCollector;

    public OutputColumns getOutputColumns() {
        String[] columnNames = new String[]{this.mapColumn.getName() + " (key)", this.mapColumn.getName() + " (value)"};
        Class[] columnTypes = new Class[]{String.class, this.valueType};
        return new OutputColumns(columnNames, columnTypes);
    }

    public Object[] transform(InputRow row) {
        Map map = (Map)row.getValue(this.mapColumn);
        if (map == null || map.isEmpty()) {
            return new Object[2];
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (this.verifyTypes) {
                value = this.valueType.cast(value);
            }
            this.outputRowCollector.putValues(new Object[]{key, value});
        }
        return null;
    }
}

