/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.beans.datastructures;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.DataStructuresCategory;

@Named(value="Select values from list")
@Description(value="Given a specified list of indices, this transformer will select the values from a list and place them as columns within the record")
@Categorized(value={DataStructuresCategory.class})
public class SelectFromListTransformer
implements Transformer {
    @Inject
    @Configured
    InputColumn<List<?>> listColumn;
    @Inject
    @Configured
    @Description(value="A list of (0-based) indices to use for fetching values from the list.")
    Number[] indices = new Number[]{0, 1, 2};
    @Inject
    @Configured
    Class<?> elementType;
    @Inject
    @Configured
    @Description(value="Verify that expected element type and actual type are the same")
    boolean verifyTypes = false;

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.indices.length];
        Class[] types = new Class[this.indices.length];
        for (int i = 0; i < this.indices.length; ++i) {
            names[i] = this.listColumn.getName() + "[" + this.indices[i] + "]";
            types[i] = this.elementType;
        }
        return new OutputColumns(names, types);
    }

    public Object[] transform(InputRow row) {
        Object[] result = new Object[this.indices.length];
        List list = (List)row.getValue(this.listColumn);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < this.indices.length; ++i) {
                int index = this.indices[i].intValue();
                if (index < 0 || index >= list.size()) continue;
                Object value = list.get(index);
                result[i] = value;
            }
        }
        return result;
    }
}

