/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.actions.PreviewSourceDataActionListener;
import org.datacleaner.actions.QueryActionListener;
import org.datacleaner.api.InputColumn;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.panels.MutableInputColumnListPanel;
import org.datacleaner.util.IconUtils;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.table.DCTable;
import org.jdesktop.swingx.table.TableColumnExt;

public final class ColumnListTable
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] HEADERS_WITH_ACTION_COLUMN = new String[]{"Name", "Type", ""};
    private static final String[] HEADERS_WITHOUT_ACTIONS = new String[]{"Name", "Type"};
    private final ImageManager imageManager = ImageManager.get();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Table _table;
    private final DCTable _columnTable;
    private final SortedMap<InputColumn<?>, JComponent> _columns = new TreeMap();
    private final WindowContext _windowContext;
    private final boolean _addShadowBorder;

    public ColumnListTable(Collection<? extends InputColumn<?>> columns, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this(null, columns, analysisJobBuilder, addShadowBorder, windowContext);
    }

    public ColumnListTable(Table table, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this(table, null, analysisJobBuilder, addShadowBorder, windowContext);
    }

    private ColumnListTable(Table table, Collection<? extends InputColumn<?>> columns, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this._table = table;
        this._analysisJobBuilder = analysisJobBuilder;
        this._addShadowBorder = addShadowBorder;
        this._windowContext = windowContext;
        this.setLayout(new BorderLayout());
        if (table != null) {
            DCPanel headerPanel = new DCPanel();
            headerPanel.setLayout(new FlowLayout(0, 0, 0));
            JLabel tableNameLabel = new JLabel(table.getQualifiedLabel(), this.imageManager.getImageIcon("images/model/column.png", 16, new ClassLoader[0]), 2);
            tableNameLabel.setOpaque(false);
            tableNameLabel.setFont(WidgetUtils.FONT_HEADER1);
            headerPanel.add(tableNameLabel);
            if (this._windowContext != null) {
                JButton previewButton = WidgetFactory.createSmallButton("images/actions/preview_data.png");
                previewButton.setToolTipText("Preview table rows");
                previewButton.addActionListener(new PreviewSourceDataActionListener(this._windowContext, this._analysisJobBuilder.getDatastore(), this._columns.keySet()));
                headerPanel.add(Box.createHorizontalStrut(4));
                headerPanel.add(previewButton);
            }
            if (this._windowContext != null) {
                JButton queryButton = WidgetFactory.createSmallButton("images/model/query.png");
                queryButton.setToolTipText("Ad-hoc query");
                queryButton.addActionListener(new QueryActionListener(this._windowContext, this._analysisJobBuilder, this._table, this._columns.keySet()));
                headerPanel.add(Box.createHorizontalStrut(4));
                headerPanel.add(queryButton);
            }
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove table from source");
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnListTable.this._analysisJobBuilder.removeSourceTable(ColumnListTable.this._table);
                }
            });
            headerPanel.add(Box.createHorizontalStrut(4));
            headerPanel.add(removeButton);
            this.add((Component)headerPanel, "North");
        }
        this._columnTable = new DCTable(HEADERS_WITH_ACTION_COLUMN);
        this._columnTable.setSortable(false);
        this._columnTable.setColumnControlVisible(false);
        this._columnTable.setRowHeight(20);
        if (columns != null) {
            for (InputColumn<?> column : columns) {
                this.addColumn(column, false);
            }
        }
        this.updateComponents();
    }

    private void updateComponents() {
        boolean hasPhysicalColumns = false;
        for (InputColumn<?> column : this._columns.keySet()) {
            if (!column.isPhysicalColumn()) continue;
            hasPhysicalColumns = true;
            break;
        }
        Object[] headers = hasPhysicalColumns ? HEADERS_WITH_ACTION_COLUMN : HEADERS_WITHOUT_ACTIONS;
        DefaultTableModel model = new DefaultTableModel(headers, this._columns.size());
        int i = 0;
        for (Map.Entry<InputColumn<?>, JComponent> entry : this._columns.entrySet()) {
            final InputColumn<?> column = entry.getKey();
            JComponent panel = entry.getValue();
            model.setValueAt(panel, i, 0);
            Class dataType = column.getDataType();
            String dataTypeString = LabelUtils.getDataTypeLabel((Class)dataType);
            model.setValueAt(dataTypeString, i, 1);
            if (column.isPhysicalColumn()) {
                DCPanel buttonPanel = new DCPanel();
                buttonPanel.setLayout(new GridBagLayout());
                JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
                removeButton.setToolTipText("Remove column from source");
                removeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ColumnListTable.this._analysisJobBuilder.removeSourceColumn(column.getPhysicalColumn());
                    }
                });
                WidgetUtils.addToGridBag(removeButton, buttonPanel, 0, 0);
                model.setValueAt(buttonPanel, i, 2);
            }
            ++i;
        }
        this._columnTable.setModel(model);
        if (hasPhysicalColumns) {
            TableColumnExt columnExt = this._columnTable.getColumnExt(2);
            columnExt.setMinWidth(26);
            columnExt.setMaxWidth(80);
            columnExt.setPreferredWidth(30);
        }
        this._columnTable.setRowHeight(30);
        DCPanel tablePanel = this._columnTable.toPanel();
        if (this._addShadowBorder) {
            tablePanel.setBorder(new CompoundBorder(WidgetUtils.BORDER_SHADOW, WidgetUtils.BORDER_THIN));
        }
        this.add((Component)tablePanel, "Center");
    }

    protected JComponent createComponentForColumn(InputColumn<?> column) {
        if (column instanceof MutableInputColumn) {
            MutableInputColumn mutableInputColumn = (MutableInputColumn)column;
            MutableInputColumnListPanel panel = new MutableInputColumnListPanel(this._analysisJobBuilder, mutableInputColumn);
            return panel;
        }
        Icon icon = IconUtils.getColumnIcon(column, 22);
        return new JLabel(column.getName(), icon, 2);
    }

    public Table getTable() {
        return this._table;
    }

    public void addColumn(InputColumn<?> column) {
        this.addColumn(column, true);
    }

    public void addColumn(InputColumn<?> column, boolean updatePanel) {
        if (this._columns.containsKey(column)) {
            return;
        }
        this._columns.put(column, this.createComponentForColumn(column));
        if (updatePanel) {
            this.updateComponents();
        }
    }

    public void removeColumn(InputColumn<?> column) {
        this.removeColumn(column, true);
    }

    public void removeColumn(InputColumn<?> column, boolean updatePanel) {
        if (!this._columns.containsKey(column)) {
            return;
        }
        JComponent panel = (JComponent)this._columns.remove(column);
        if (panel instanceof Closeable) {
            FileHelper.safeClose((Object[])new Object[]{panel});
        }
        if (updatePanel) {
            this.updateComponents();
        }
    }

    public void setColumns(List<? extends InputColumn<?>> columns) {
        ArrayList copyOfOldList = new ArrayList(this._columns.keySet());
        for (InputColumn inputColumn : copyOfOldList) {
            this.removeColumn(inputColumn, false);
        }
        assert (this._columns.isEmpty());
        this._columns.clear();
        for (InputColumn inputColumn : columns) {
            this.addColumn(inputColumn, false);
        }
        this.updateComponents();
    }

    public int getColumnCount() {
        return this._columns.size();
    }
}

