/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.datacleaner.widgets.Alignment;

public class DCPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Image _watermark;
    private final int _imageHeight;
    private final int _imageWidth;
    private final float _horizontalAlignment;
    private final float _verticalAlignment;
    private final Color _bottomColor;
    private final Color _topColor;

    public static DCPanel around(Component component) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(component);
        return panel;
    }

    public static DCPanel flow(Component ... components) {
        return DCPanel.flow(Alignment.LEFT, components);
    }

    public static DCPanel flow(Alignment alignment, Component ... components) {
        return DCPanel.flow(alignment, 10, 2, components);
    }

    public static DCPanel flow(Alignment alignment, int hgap, int vgap, Component ... components) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new FlowLayout(alignment.getFlowLayoutAlignment(), 0, vgap));
        for (int i = 0; i < components.length; ++i) {
            if (i != 0) {
                panel.add(Box.createHorizontalStrut(hgap));
            }
            panel.add(components[i]);
        }
        return panel;
    }

    public DCPanel() {
        this(null, 0, 0);
    }

    public DCPanel(Color bgColor) {
        this(null, 0, 0, bgColor, bgColor);
    }

    @Deprecated
    public DCPanel(Color topColor, Color bottomColor) {
        this(null, 0, 0, topColor, bottomColor);
    }

    public DCPanel(Image watermark, int horizontalAlignmentInPercent, int verticalAlignmentInPercent) {
        this(watermark, horizontalAlignmentInPercent, verticalAlignmentInPercent, null, null);
    }

    public DCPanel(Image watermark, int horizontalAlignmentInPercent, int verticalAlignmentInPercent, Color bgColor) {
        this(watermark, horizontalAlignmentInPercent, verticalAlignmentInPercent, bgColor, bgColor);
    }

    @Deprecated
    public DCPanel(Image watermark, int horizontalAlignmentInPercent, int verticalAlignmentInPercent, Color topColor, Color bottomColor) {
        if (topColor == null || bottomColor == null) {
            this.setOpaque(false);
        } else if (topColor.getAlpha() < 255) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
        this._topColor = topColor;
        this._bottomColor = bottomColor;
        this._watermark = watermark;
        this._horizontalAlignment = (float)horizontalAlignmentInPercent / 100.0f;
        this._verticalAlignment = (float)verticalAlignmentInPercent / 100.0f;
        if (watermark != null) {
            ImageIcon icon = new ImageIcon(watermark);
            this._imageWidth = icon.getIconWidth();
            this._imageHeight = icon.getIconHeight();
        } else {
            this._imageWidth = -1;
            this._imageHeight = -1;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._topColor != null) {
            if (this.isOpaque()) {
                this.paintPanelBackgroundColor(g);
            } else if (this._topColor.getAlpha() < 255) {
                this.paintPanelBackgroundColor(g);
            }
        } else {
            super.paintComponent(g);
        }
        if (this._watermark != null) {
            this.paintPanelBackgroundImage(g, this._watermark, this._imageWidth, this._imageHeight, this._horizontalAlignment, this._verticalAlignment);
        }
    }

    protected void paintPanelBackgroundImage(Graphics g, Image watermark, int imageWidth, int imageHeight, float horizontalAlignment, float verticalAlignment) {
        int x = this.getWidth() - imageWidth;
        x = (int)((float)x * horizontalAlignment);
        int y = this.getHeight() - imageHeight;
        y = (int)((float)y * verticalAlignment);
        g.drawImage(watermark, x, y, imageWidth, imageHeight, this);
    }

    protected void paintPanelBackgroundColor(Graphics g) {
        Paint paint = this._topColor == this._bottomColor || this._bottomColor == null ? this._topColor : new GradientPaint(0.0f, 0.0f, this._topColor, 0.0f, this.getHeight(), this._bottomColor);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint);
        } else {
            g.setColor(this._topColor);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public DCPanel setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public DCPanel setTitledBorder(String title) {
        this.setBorder(new TitledBorder(title));
        return this;
    }
}

