/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.datacleaner.actions.DisplayOptionsForFilterOutcomeActionListener;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.FilterChangeListener;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.panels.AbstractComponentBuilderPanel;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.panels.FilterComponentBuilderPresenter;
import org.datacleaner.util.ImageManager;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.widgets.Alignment;
import org.datacleaner.widgets.DCLabel;
import org.datacleaner.widgets.PopupButton;
import org.datacleaner.widgets.properties.FormPanel;
import org.datacleaner.widgets.properties.PropertyWidgetFactory;

public class FilterComponentBuilderPanel
extends AbstractComponentBuilderPanel
implements FilterComponentBuilderPresenter,
FilterChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.get();
    private final FilterComponentBuilder<?, ?> _filterComponentBuilder;
    private final DCPanel _outcomePanel;

    public FilterComponentBuilderPanel(FilterComponentBuilder<?, ?> filterJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory) {
        this(null, 95, 95, filterJobBuilder, windowContext, propertyWidgetFactory);
    }

    protected FilterComponentBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, FilterComponentBuilder<?, ?> filterComponentBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, (ComponentBuilder)filterComponentBuilder, propertyWidgetFactory);
        this._filterComponentBuilder = filterComponentBuilder;
        this._outcomePanel = new DCPanel();
        this._outcomePanel.setLayout(new FlowLayout(Alignment.LEFT.getFlowLayoutAlignment(), 0, 0));
        Set categoryNames = ((FilterDescriptor)this._filterComponentBuilder.getDescriptor()).getOutcomeCategoryNames();
        for (String categoryName : categoryNames) {
            PopupButton outcomeButton = WidgetFactory.createDefaultPopupButton(categoryName, "images/component-types/filter-outcome.png");
            outcomeButton.addActionListener(new DisplayOptionsForFilterOutcomeActionListener(outcomeButton, this._filterComponentBuilder, categoryName));
            this._outcomePanel.add(outcomeButton);
            this._outcomePanel.add(Box.createHorizontalStrut(4));
        }
        JButton helpButton = WidgetFactory.createSmallButton("images/actions/help.png");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DCPanel messagePanel = new DCPanel();
                messagePanel.setLayout(new BorderLayout());
                messagePanel.add((Component)new JLabel(imageManager.getImageIcon("images/help/help_requirement_mapping.png", new ClassLoader[0])), "West");
                messagePanel.add(DCLabel.darkMultiLine("Filter outcomes can be set as requirements<br>for other components, using the<br>\"(No requirement)\" buttons.<br><br>You can also click the categories directly to eg.<br>write categorized records or to map them<br>as requirements for existing or new components."));
                JOptionPane.showMessageDialog(FilterComponentBuilderPanel.this, messagePanel, "Help: Filter categories / outcomes", -1);
            }
        });
        this._outcomePanel.add(helpButton);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._filterComponentBuilder.addChangeListener((FilterChangeListener)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._filterComponentBuilder.removeChangeListener((FilterChangeListener)this);
    }

    @Override
    protected JComponent decorateMainPanel(DCPanel panel) {
        JComponent result = super.decorateMainPanel(panel);
        FormPanel outcomeFormPanel = new FormPanel();
        outcomeFormPanel.addFormEntry("This filter categorizes records as", null, (JComponent)this._outcomePanel);
        this.addTaskPane("images/component-types/filter-outcome.png", "Outcomes", (JComponent)outcomeFormPanel);
        return result;
    }

    @Override
    public FilterComponentBuilder<?, ?> getComponentBuilder() {
        return this._filterComponentBuilder;
    }

    public void onAdd(FilterComponentBuilder<?, ?> fjb) {
    }

    public void onConfigurationChanged(FilterComponentBuilder<?, ?> fjb) {
        this.onConfigurationChanged();
    }

    public void onRemove(FilterComponentBuilder<?, ?> fjb) {
    }

    public void onRequirementChanged(FilterComponentBuilder<?, ?> filterJobBuilder) {
    }
}

