/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.datacleaner.actions.DisplayOutputWritersForTransformedDataActionListener;
import org.datacleaner.actions.PreviewTransformedDataActionListener;
import org.datacleaner.api.InputColumn;
import org.datacleaner.bootstrap.WindowContext;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.TransformerChangeListener;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.panels.AbstractComponentBuilderPanel;
import org.datacleaner.panels.ColumnListTable;
import org.datacleaner.panels.DCPanel;
import org.datacleaner.panels.TransformerComponentBuilderPresenter;
import org.datacleaner.util.WidgetFactory;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.properties.PropertyWidgetFactory;

public class TransformerComponentBuilderPanel
extends AbstractComponentBuilderPanel
implements TransformerComponentBuilderPresenter,
TransformerChangeListener {
    private static final long serialVersionUID = 1L;
    private final TransformerComponentBuilder<?> _componentBuilder;
    private final ColumnListTable _outputColumnsTable;
    private final JButton _previewButton;
    private final JButton _writeDataButton;
    private final WindowContext _windowContext;

    public TransformerComponentBuilderPanel(TransformerComponentBuilder<?> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, DataCleanerConfiguration configuration) {
        this(null, 95, 95, transformerJobBuilder, windowContext, propertyWidgetFactory, configuration);
    }

    protected TransformerComponentBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, TransformerComponentBuilder<?> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, DataCleanerConfiguration configuration) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, (ComponentBuilder)transformerJobBuilder, propertyWidgetFactory);
        this._componentBuilder = transformerJobBuilder;
        this._windowContext = windowContext;
        ArrayList outputColumns = this._componentBuilder.isConfigured() ? this._componentBuilder.getOutputColumns() : new ArrayList(0);
        this._outputColumnsTable = new ColumnListTable(outputColumns, this.getAnalysisJobBuilder(), false, this._windowContext);
        this._writeDataButton = WidgetFactory.createDefaultButton("Write data", "images/component-types/type_output_writer.png");
        this._writeDataButton.addActionListener(new DisplayOutputWritersForTransformedDataActionListener(this._componentBuilder));
        this._previewButton = WidgetFactory.createDefaultButton("Preview data", "images/actions/preview_data.png");
        int previewRows = this.getPreviewRows();
        this._previewButton.addActionListener(new PreviewTransformedDataActionListener(this._windowContext, this, this._componentBuilder, previewRows));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._componentBuilder.addChangeListener((TransformerChangeListener)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._componentBuilder.removeChangeListener((TransformerChangeListener)this);
    }

    protected int getPreviewRows() {
        return 200;
    }

    public WindowContext getWindowContext() {
        return this._windowContext;
    }

    @Override
    protected JComponent decorateMainPanel(DCPanel panel) {
        JComponent result = super.decorateMainPanel(panel);
        DCPanel bottomButtonPanel = new DCPanel();
        bottomButtonPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        bottomButtonPanel.setLayout(new FlowLayout(2, 4, 0));
        bottomButtonPanel.add(this._writeDataButton);
        bottomButtonPanel.add(this._previewButton);
        DCPanel outputColumnsPanel = new DCPanel();
        outputColumnsPanel.setLayout(new BorderLayout());
        outputColumnsPanel.add((Component)WidgetUtils.decorateWithShadow(this._outputColumnsTable), "Center");
        outputColumnsPanel.add((Component)bottomButtonPanel, "South");
        this.addTaskPane("images/model/source.png", "Output columns", (JComponent)outputColumnsPanel);
        return result;
    }

    public void setOutputColumns(List<? extends InputColumn<?>> outputColumns) {
        this._outputColumnsTable.setColumns(outputColumns);
    }

    public void onAdd(TransformerComponentBuilder<?> tjb) {
    }

    public void onConfigurationChanged(TransformerComponentBuilder<?> tjb) {
        this.onConfigurationChanged();
    }

    public void onOutputChanged(TransformerComponentBuilder<?> tjb, List<MutableInputColumn<?>> outputColumns) {
        this._outputColumnsTable.setColumns(outputColumns);
    }

    public void onRemove(TransformerComponentBuilder<?> tjb) {
    }

    public void onRequirementChanged(TransformerComponentBuilder<?> transformerJobBuilder) {
    }

    @Override
    public TransformerComponentBuilder<?> getComponentBuilder() {
        return this._componentBuilder;
    }
}

