/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import org.datacleaner.util.WidgetUtils;
import org.datacleaner.widgets.result.DCDrawingSupplier;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;

public final class ChartUtils {
    private static final Stroke STROKE_NORMAL = new BasicStroke(1.2f, 1, 1);
    private static final Stroke STROKE_WIDE = new BasicStroke(2.2f, 1, 1);
    public static final int WIDTH_WIDE = 900;
    public static final int WIDTH_NORMAL = 600;
    public static final int HEIGHT_WIDE = 400;
    public static final int HEIGHT_NORMAL = 600;

    private ChartUtils() {
    }

    public static ChartPanel createPanel(JFreeChart chart, boolean wide) {
        if (wide) {
            return ChartUtils.createPanel(chart, 900, 400);
        }
        return ChartUtils.createPanel(chart, 600, 600);
    }

    public static ChartPanel createPanel(JFreeChart chart, int width, int height) {
        ChartPanel panel = new ChartPanel(chart);
        panel.setPreferredSize(new Dimension(width, height));
        return panel;
    }

    public static void applyStyles(JFreeChart chart) {
        TextTitle title = chart.getTitle();
        if (title != null) {
            title.setFont(WidgetUtils.FONT_HEADER1);
            title.setBackgroundPaint((Paint)WidgetUtils.BG_COLOR_BRIGHTEST);
        }
        for (int i = 0; i < chart.getSubtitleCount(); ++i) {
            Title subtitle = chart.getSubtitle(i);
            if (!(subtitle instanceof TextTitle)) continue;
            ((TextTitle)subtitle).setFont(WidgetUtils.FONT_NORMAL);
        }
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setItemFont(WidgetUtils.FONT_SMALL);
        }
        chart.setBackgroundPaint((Paint)WidgetUtils.BG_COLOR_BRIGHTEST);
        chart.setBorderVisible(false);
        Plot plot = chart.getPlot();
        plot.setInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)WidgetUtils.BG_COLOR_BRIGHTEST);
        plot.setOutlinePaint((Paint)WidgetUtils.BG_COLOR_BRIGHTEST);
        plot.setOutlineVisible(true);
        if (plot instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)plot;
            piePlot.setBaseSectionOutlinePaint((Paint)WidgetUtils.BG_COLOR_DARK);
            piePlot.setBaseSectionOutlineStroke(STROKE_NORMAL);
            piePlot.setLabelFont(WidgetUtils.FONT_SMALL);
            piePlot.setLabelBackgroundPaint((Paint)WidgetUtils.BG_COLOR_BRIGHT);
            piePlot.setLabelOutlineStroke(STROKE_NORMAL);
            piePlot.setLabelPaint((Paint)WidgetUtils.BG_COLOR_DARK);
            piePlot.setSectionOutlinesVisible(false);
            piePlot.setLabelLinkStyle(PieLabelLinkStyle.QUAD_CURVE);
            piePlot.setDrawingSupplier((DrawingSupplier)new DCDrawingSupplier());
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            int columnCount = categoryPlot.getDataset().getColumnCount();
            if (columnCount > 1) {
                categoryPlot.setDomainGridlinesVisible(true);
            } else {
                categoryPlot.setDomainGridlinesVisible(false);
            }
            categoryPlot.setDomainGridlinePaint((Paint)WidgetUtils.BG_COLOR_DARK);
            categoryPlot.setDomainGridlinePosition(CategoryAnchor.END);
            categoryPlot.getDomainAxis().setLabelFont(WidgetUtils.FONT_SMALL);
            categoryPlot.getDomainAxis().setTickLabelFont(WidgetUtils.FONT_SMALL);
            categoryPlot.getRangeAxis().setLabelFont(WidgetUtils.FONT_SMALL);
            categoryPlot.getRangeAxis().setTickLabelFont(WidgetUtils.FONT_SMALL);
            categoryPlot.setDrawingSupplier((DrawingSupplier)new DCDrawingSupplier());
            CategoryItemRenderer renderer = categoryPlot.getRenderer();
            renderer.setBaseOutlinePaint((Paint)WidgetUtils.BG_COLOR_DARK);
            renderer.setBaseOutlineStroke(STROKE_WIDE);
            if (renderer instanceof BarRenderer) {
                BarRenderer barRenderer = (BarRenderer)renderer;
                barRenderer.setShadowPaint((Paint)WidgetUtils.BG_COLOR_BRIGHT);
                barRenderer.setBarPainter((BarPainter)new StandardBarPainter());
            }
        } else if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            xyPlot.setDrawingSupplier((DrawingSupplier)new DCDrawingSupplier());
            xyPlot.getDomainAxis().setLabelFont(WidgetUtils.FONT_SMALL);
            xyPlot.getDomainAxis().setTickLabelFont(WidgetUtils.FONT_SMALL);
            xyPlot.getRangeAxis().setLabelFont(WidgetUtils.FONT_SMALL);
            xyPlot.getRangeAxis().setTickLabelFont(WidgetUtils.FONT_SMALL);
            XYItemRenderer renderer = xyPlot.getRenderer();
            int seriesCount = xyPlot.getSeriesCount();
            for (int i = 0; i < seriesCount; ++i) {
                renderer.setSeriesStroke(i, STROKE_WIDE);
            }
        }
    }
}

